void QuestComplete(string sQuestName)
{
	ref PChar, NPChar, sld;
// KK -->
	int iPassenger, cidx, iHP, cc, i, times;
	float locx, locy, locz;
	string homelocation, homegroup, homelocator, homeisland;
	int crewQty = 0;
	string attr, level;
// <-- KK
	aref arship; // PB
	aref PChar_land, PChar_quest_land;

	PChar = GetMainCharacter();

	switch(sQuestName)
	{
		case "begining":
// GR: choose island based on character nationality, this island will be checked for cancelling the tutorial -->
			switch(GetCurrentFlag())
			{
				case ENGLAND: homeisland = "Oxbay"; break;
				case FRANCE: homeisland = "FalaiseDeFleur"; break;
				case SPAIN: homeisland = "IslaMuelle"; break;
				case PIRATE: homeisland = "QuebradasCostillas"; break;
				case HOLLAND: homeisland = "Douwesen"; break;
				case PORTUGAL: homeisland = "Conceicao"; break;
				case AMERICA: homeisland = "Eleuthera"; break;
				homeisland = "Oxbay";
			}
			if (!CheckQuestAttribute("StartAdventure", "begin")) {
				pchar.quest.cancel_tutorial.win_condition.l1 = "location";
				pchar.quest.cancel_tutorial.win_condition.l1.location = homeisland;
				pchar.quest.cancel_tutorial.win_condition = "cancel_tutorial";
			}
// <<-- GR
			else LAi_QuestDelay("cancel_tutorial", 0.0); // KK
		break;

		case "cancel_tutorial":
// KK -->
			if (!CheckQuestAttribute("StartAdventure", "begin")) {

				DeleteQuestHeader("Tutorial_SpyGlass");
				DeleteQuestHeader("Tutorial_Store");
				DeleteQuestHeader("Tutorial_Shipyard");
				DeleteQuestHeader("Tutorial_Tavern");

				Pchar.quest.Tut_SellGoods.over = "yes";
				Pchar.quest.Tut_RepairShip.over = "yes";
				Pchar.quest.Tut_HireCrew.over = "yes";
			// TIH --> alternative methods for completion finished Sep3'06
				Pchar.quest.Tut_BuySpyGlass.over = "yes";
				Pchar.quest.Tut_BuySpyGlass3.over = "yes";
				Pchar.quest.Tut_BuySpyGlass4.over = "yes";
			// TIH <--
				DeleteAttribute(Pchar, "quest.tutorial.Spyglass");
			}
// <-- KK
		break;

///////////////////////////////////////////////////////////////
///// TALES OF A CHEVALIER
///////////////////////////////////////////////////////////////

		case "embora":
			PChar.quest.disable_rebirth = true;
			SetNextWeather("Foggy");
			pchar.originalmodel = pchar.model;
			SetQuestHeader("Beginning_Rogue");
			if (CharPlayerType == PLAYER_TYPE_ROGUE)
			{
				if (PChar.sex == "woman") AddQuestRecord("Beginning_Rogue", 6);
				else AddQuestRecord("Beginning_Rogue", 1);
			}
			else AddQuestRecord("Beginning_Rogue", 9);
			PChar.quest.celestino = "encontro";
			Pchar.quest.celestino.win_condition.l1 = "location";
			Pchar.quest.celestino.win_condition.l1.location = "Cuba_shore_03";
			PChar.quest.celestino.win_condition = "meetcelestino";
		break;

		case "meetcelestino":
			DisableFastTravel(true);
            ChangeCharacterAddressGroup(CharacterFromID("Celestino Villalobos"), "Cuba_shore_03", "goto", "citizen01");
            LAi_SetActorType(characterFromID("Celestino Villalobos"));
			LAi_ActorDialog(characterFromID("Celestino Villalobos"), pchar, "", 10.0, 1.0);
		break;

		case "fightcelestino":
			LAi_SetWarriorType(characterFromID("Celestino Villalobos"));
			LAi_group_MoveCharacter(characterFromID("Celestino Villalobos"), "QUEST_ENEMIES");
			LAi_group_SetRelation("QUEST_ENEMIES", LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);
			LAi_group_FightGroups("QUEST_ENEMIES", LAI_GROUP_PLAYER, true);
			LAi_SetFightMode(PChar, true);

			pchar.quest.salgada_died.win_condition.l1 = "NPC_Death";
			pchar.quest.salgada_died.win_condition.l1.character = "Celestino Villalobos";
			pchar.quest.salgada_died.win_condition = "vientsoldado";
		break;

		case "vientsoldado":
			LAi_SetFightMode(PChar, false);
			Locations[FindLocation("Cuba_shore_03")].reload.l1.disable = true;
			Locations[FindLocation("Cuba_shore_03")].reload.l2.disable = true;
            ChangeCharacterAddressGroup(CharacterFromID("Enrique Padilla"), "Cuba_shore_03", "reload", "reload2_back");

			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m2, "reload", "reload2_back");
			LAi_SetHP(sld, 80.0, 80.0);
			LAi_group_MoveCharacter(sld, "CUBAN_SOLDATS");
			LAi_SetActorType(sld);
			LAi_ActorFollow(sld, characterFromID("Enrique Padilla"), "", 10.0);

			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m3, "reload", "reload2_back");
			LAi_SetHP(sld, 80.0, 80.0);
			LAi_group_MoveCharacter(sld, "CUBAN_SOLDATS");
			LAi_SetActorType(sld);
			LAi_ActorFollow(sld, characterFromID("Enrique Padilla"), "", 10.0);

			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m4, "reload", "reload2_back");
			LAi_SetHP(sld, 80.0, 80.0);
			LAi_group_MoveCharacter(sld, "CUBAN_SOLDATS");
			LAi_SetActorType(sld);
			LAi_ActorFollow(sld, characterFromID("Enrique Padilla"), "", 10.0);

			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m5, "reload", "reload2_back");
			LAi_SetHP(sld, 80.0, 80.0);
			LAi_group_MoveCharacter(sld, "CUBAN_SOLDATS");
			LAi_SetActorType(sld);
			LAi_ActorFollow(sld, characterFromID("Enrique Padilla"), "", 10.0);

			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m6, "reload", "reload2_back");
			LAi_SetHP(sld, 80.0, 80.0);
			LAi_group_MoveCharacter(sld, "CUBAN_SOLDATS");
			LAi_SetActorType(sld);
			LAi_ActorFollow(sld, characterFromID("Enrique Padilla"), "", 10.0);

			LAi_SetActorType(characterFromID("Enrique Padilla"));
			Characters[GetCharacterIndex("Enrique Padilla")].dialog.currentnode = "begin_1";
			LAi_ActorDialog(characterFromID("Enrique Padilla"), pchar, "", 10.0, 1.0);
			SetCurrentTime(20, 0);
		break;

		case "LaCroix_jail":
			if(GetCurrentFlag() != FRANCE)
			{
				sld = CharacterFromID("Bart Renault");
				DeleteAttribute(sld, "questchar");
				sld.nation = GetCurrentFlag();	// Bart is supposed to be the same nation as you
				sld.nation.name = sld.nation;	// Necessary for "GetMyAddressForm" to work properly
				SetRandomNameToCharacter(sld);	// Rename him to match his nationality
			}

			pchar.vcskip = true; // PB: Avoid unwanted characters in jail
			DoQuestReloadToLocation("Havana_prison", "goto", "goto9","LaCroix_jail2");
			Locations[FindLocation("Cuba_shore_03")].reload.l1.disable = false;
			Locations[FindLocation("Cuba_shore_03")].reload.l2.disable = false;
			LAi_SetPlayerType(pchar);
			WaitDate("", 0,0,3,0,0);
			LAi_SetCurHPMax(pchar);
		break;

		case "LaCroix_jail2":
			ChangeCharacterAddress(characterFromID("Enrique Padilla"), "None", "");
			RemoveCharacterEquip(pchar, BLADE_ITEM_TYPE);
			EnableEquip(pchar, BLADE_ITEM_TYPE, false);
			EnableEquip(pchar, GUN_ITEM_TYPE, false);
            ChangeCharacterAddressGroup(CharacterFromID("Bart Renault"), "Havana_prison", "goto", "goto23");
			LAi_SetActorType(characterFromID("Bart Renault"));
			Characters[GetCharacterIndex("Bart Renault")].dialog.currentnode = "begin_3";
			LAi_ActorDialog(characterFromID("Bart Renault"), pchar, "", 2.0, 1.0);
			DeleteAttribute(&PChar,"vcskip"); // NK 04-06
		break;

		case "Breakout":
			PlayStereoSound("AMBIENT\JAIL\door_002.wav");
			EnableEquip(pchar, BLADE_ITEM_TYPE, true);
			EnableEquip(pchar, GUN_ITEM_TYPE, true);
			EquipCharacterByItem(pchar, FindCharacterItemByGroup(pchar, BLADE_ITEM_TYPE));
			EquipCharacterByItem(pchar, FindCharacterItemByGroup(pchar, GUN_ITEM_TYPE));
			locCameraFollow();
			ChangeCharacterAddressGroup(pchar, "Havana_prison", "reload", "reload12");
			pchar.quest.main_line = "escape_from_havana_prison";
			ChangeCharacterAddress(characterFromID("Bart Renault"), "Havana_prison", "goto23");
			LAi_group_MoveCharacter(characterFromID("Bart Renault"), LAI_GROUP_PLAYER);
			LAi_group_SetCheck("SPAIN_SOLDIERS", "kill_all_soldiers_in_prison_complete");
			LAi_LocationFightDisable(&Locations[FindLocation("Havana_prison")], false);
			LAi_SetFightMode(PChar, true);
		break;

		case "kill_all_soldiers_in_prison_complete":
			LAi_SetFightMode(PChar, false);
			LAi_SetActorType(characterFromID("Bart Renault"));
			Characters[GetCharacterIndex("Bart Renault")].dialog.currentnode = "begin_7";
			LAi_ActorDialog(characterFromID("Bart Renault"), pchar, "", 2.0, 1.0);
		break;

		// PB -->
		case "bartinjail":
			ChangeCharacterAddress(characterFromID("Bart Renault"), "Havana_prison", "goto9");
			LAi_SetActorType(PChar);
			LAi_ActorTurnToCharacter(PChar, characterFromID("Bart Renault"));
			postevent("resetpchar_event", 1000);
		break;
		// PB <--

		case "crewsavesme":
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean1"), "Havana_prison", "reload", "reload1");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean1"));
			LAi_SetImmortal(characterFromID("Crewmember_Jean1"), true);
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean2"), "Havana_prison", "reload", "reload1");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean2"));
			LAi_SetImmortal(characterFromID("Crewmember_Jean2"), true);
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean3"), "Havana_prison", "reload", "reload1");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean3"));

			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m3, "goto", "goto21");
			TakeItemFromCharacter(sld, CheckCharacterEquipByGroup(sld, BLADE_ITEM_TYPE));
			GiveItem2Character(sld, "blade4");
			EquipCharacterByItem(sld, "blade4");
			sld.dialog.filename = "soldier_dialog.c";
			sld.dialog.currentnode = "First time";
	        LAi_SetCitizenType(sld);
			LAi_group_MoveCharacter(sld, "SPAIN_SOLDIERS");

			 sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m4, "goto", "goto20");
			TakeItemFromCharacter(sld, CheckCharacterEquipByGroup(sld, BLADE_ITEM_TYPE));
			GiveItem2Character(sld, "blade4");
			EquipCharacterByItem(sld, "blade4");
			sld.dialog.filename = "soldier_dialog.c";
			sld.dialog.currentnode = "First time";
            LAi_SetStayType(sld);
			LAi_group_MoveCharacter(sld, "SPAIN_SOLDIERS");

			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Havana"), "Havana_prison", "reload", "reload1");
			LAi_SetActorType(characterFromID("Crewmember_Havana"));
			LAi_SetImmortal(characterFromID("Crewmember_Havana"), true);
			LAi_ActorRunToLocator(characterFromID("Crewmember_Havana"), "goto", "goto23", "crewsavesme2",10);
			LAi_group_SetRelation("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);
			LAi_group_FightGroups("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, true);
			pchar.quest.crewsavesme3.win_condition.l1 = "NPC_Death";
			pchar.quest.crewsavesme3.win_condition.l1.character = "Prison_Guard_Spa1";
			pchar.quest.crewsavesme3.win_condition.l2 = "NPC_Death";
			pchar.quest.crewsavesme3.win_condition.l2.character = "Prison_Guard_Spa2";
			pchar.quest.crewsavesme3.win_condition.l3 = "NPC_Death";
			pchar.quest.crewsavesme3.win_condition.l3.character = "Bart Renault";
			pchar.quest.crewsavesme3.win_condition = "crewsavesme3";
			LAi_LocationFightDisable(&Locations[FindLocation("Havana_prison")], false);
		break;

		case "crewsavesme2":
			Characters[GetCharacterIndex("Crewmember_Havana")].dialog.CurrentNode = "saved_you";
			LAi_SetActorType(characterFromID("Crewmember_Havana"));
			LAi_ActorDialog(characterFromID("Crewmember_Havana"), pchar, "", 10.0, 1.0);
		break;

		case "crewsavesme3":
			LAi_group_SetRelation("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, LAI_GROUP_FRIEND);
		break;

		case "freeme":
			PlayStereoSound("AMBIENT\JAIL\door_002.wav");
			EnableEquip(pchar, BLADE_ITEM_TYPE, true);
			EnableEquip(pchar, GUN_ITEM_TYPE, true);
			EquipCharacterByItem(pchar, FindCharacterItemByGroup(pchar, BLADE_ITEM_TYPE));
			EquipCharacterByItem(pchar, FindCharacterItemByGroup(pchar, GUN_ITEM_TYPE));
			locCameraFollow();
			ChangeCharacterAddressGroup(pchar, "Havana_prison", "reload", "reload12");
			SetCurrentTime(23, 0);
			LAi_SetImmortal(characterFromID("Bart Renault"), false);
			LAi_SetWarriorType(characterFromID("Bart Renault"));
			LAi_group_MoveCharacter(characterFromID("Bart Renault"), "QUEST_ENEMIES");
			LAi_group_SetRelation("QUEST_ENEMIES", LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);
			LAi_group_FightGroups("QUEST_ENEMIES", LAI_GROUP_PLAYER, true);
			LAi_SetFightMode(PChar, true);
			pchar.quest.spanishattack.win_condition.l1 = "location";
			pchar.quest.spanishattack.win_condition.l1 = "location";
			pchar.quest.spanishattack.win_condition.l1.location = "Havana_Town_05";
			pchar.quest.spanishattack.win_condition = "spanishattack";
		break;

		case "spanishattack":
			Locations[FindLocation("Havana_Town_05")].reload.l3.disable = true;
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean1"), "Havana_Town_05", "goto", "goto_43");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean1"));
			LAi_SetImmortal(characterFromID("Crewmember_Jean1"), true);
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean2"), "Havana_Town_05", "goto", "goto_25");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean2"));
			LAi_SetImmortal(characterFromID("Crewmember_Jean2"), true);
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean3"), "Havana_Town_05", "goto", "soldier03");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean3"));
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Havana"), "Havana_Town_05", "goto", "soldier04");
			LAi_SetOfficerType(characterFromID("Crewmember_Havana"));
			LAi_SetImmortal(characterFromID("Crewmember_Havana"), true);
			ChangeCharacterAddressGroup(CharacterFromID("SpainCommander"), "Havana_Town_05", "goto", "cityzen07");
			Characters[GetCharacterIndex("SpainCommander")].dialog.CurrentNode = "brokenout";
			LAi_SetActorType(characterFromID("SpainCommander"));
			LAi_ActorDialog(characterFromID("SpainCommander"), pchar, "", 10.0, 1.0);

			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m1, "goto", "goto_7");
			TakeItemFromCharacter(sld, CheckCharacterEquipByGroup(sld, BLADE_ITEM_TYPE));
			GiveItem2Character(sld, "blade4");
			EquipCharacterByItem(sld, "blade4");
			sld.dialog.filename = "soldier_dialog.c";
			sld.dialog.currentnode = "First time";
	        LAi_SetCitizenType(sld);
			LAi_group_MoveCharacter(sld, "SPAIN_SOLDIERS");

			 sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m2, "goto", "goto_10");
			TakeItemFromCharacter(sld, CheckCharacterEquipByGroup(sld, BLADE_ITEM_TYPE));
			GiveItem2Character(sld, "blade4");
			EquipCharacterByItem(sld, "blade4");
			sld.dialog.filename = "soldier_dialog.c";
			sld.dialog.currentnode = "First time";
	        LAi_SetCitizenType(sld);
			LAi_group_MoveCharacter(sld, "SPAIN_SOLDIERS");

			 sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m3, "goto", "goto_31");
			TakeItemFromCharacter(sld, CheckCharacterEquipByGroup(sld, BLADE_ITEM_TYPE));
			GiveItem2Character(sld, "blade4");
			EquipCharacterByItem(sld, "blade4");
			sld.dialog.filename = "soldier_dialog.c";
			sld.dialog.currentnode = "First time";
	        LAi_SetCitizenType(sld);
			LAi_group_MoveCharacter(sld, "SPAIN_SOLDIERS");

			 sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, Nations[SPAIN].fantomModel.m4, "goto", "goto_29");
			TakeItemFromCharacter(sld, CheckCharacterEquipByGroup(sld, BLADE_ITEM_TYPE));
			GiveItem2Character(sld, "blade4");
			EquipCharacterByItem(sld, "blade4");
			sld.dialog.filename = "soldier_dialog.c";
			sld.dialog.currentnode = "First time";
            LAi_SetStayType(sld);
			LAi_group_MoveCharacter(sld, "SPAIN_SOLDIERS");
		break;

		case "spanishattack2":
			LAi_ActorAttack(CharacterFromID("SpainCommander"), Pchar, "");
			LAi_group_SetRelation("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);
			LAi_group_FightGroups("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, true);
			LAi_group_SetCheck("SPAIN_SOLDIERS", "tochurch");
		break;

		case "tochurch":
			LAi_group_SetRelation("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);
			//Locations[FindLocation("Havana_town_02")].reload.l4.disable = false;
			Characters[GetCharacterIndex("Crewmember_Havana")].dialog.CurrentNode = "nowwhat";
			LAi_SetActorType(characterFromID("Crewmember_Havana"));
			LAi_ActorDialog(characterFromID("Crewmember_Havana"), pchar, "", 2.0, 1.0);
			LAi_group_FightGroups("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, false);
			pchar.quest.church.win_condition.l1 = "location";
			pchar.quest.church.win_condition.l1 = "location";
			pchar.quest.church.win_condition.l1.location = "Havana_church";
			pchar.quest.church.win_condition = "church";

			Pchar.quest.lecroix_remove_spaincommander.win_condition.l1 = "ExitFromLocation";
			PChar.quest.lecroix_remove_spaincommander.win_condition.l1.location = PChar.location;
			Pchar.quest.lecroix_remove_spaincommander.win_condition = "lecroix_remove_spaincommander";
		break;

		case "lecroix_remove_spaincommander":
			ChangeCharacterAddress(characterFromID("SpainCommander"), "None", "");
		break;

		case "church":
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean1"), "Havana_Church", "reload", "reload1");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean1"));
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean2"), "Havana_Church", "reload", "reload1");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean2"));
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean3"), "Havana_Church", "reload", "reload1");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean3"));
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Havana"), "Havana_Church", "reload", "reload1");
			LAi_SetOfficerType(characterFromID("Crewmember_Havana"));
			ChangeCharacterAddressGroup(CharacterFromID("PadreGerardo"), "Havana_church", "goto", "goto11");
			Characters[GetCharacterIndex("PadreGerardo")].dialog.CurrentNode = "whatthe";
			LAi_SetActorType(characterFromID("PadreGerardo"));
			LAi_ActorDialog(characterFromID("PadreGerardo"), pchar, "", 10.0, 1.0);
		break;

		case "gettingrobes":
			LAi_ActorRunToLocator(characterFromID("PadreGerardo"), "reload", "reload3", "gettingrobes3",10);
		break;

		case "gettingrobes3":
			ChangeCharacterAddressGroup(CharacterFromID("PadreGerardo"), "Havana_church", "reload", "reload3");
			Characters[GetCharacterIndex("PadreGerardo")].dialog.CurrentNode = "plan1";
			LAi_SetActorType(characterFromID("PadreGerardo"));
			LAi_ActorDialog(characterFromID("PadreGerardo"), pchar, "", 10.0, 1.0);
			GiveModel2Player("Priest", true);
			LAi_SetPlayerType(pchar);
            SetModelfromArray(characterFromID("Crewmember_Havana"), GetModelIndex("Priest"));
            SetModelfromArray(characterFromID("Crewmember_Jean3"), GetModelIndex("Priest"));
            SetModelfromArray(characterFromID("Crewmember_Jean2"), GetModelIndex("Priest"));
			SetModelfromArray(characterFromID("Crewmember_Jean1"), GetModelIndex("Priest"));
			LAi_group_SetRelation("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, LAI_GROUP_NEUTRAL);
		break;

		case "padreofficer":
			AddPassenger(Pchar, characterFromID("PadreGerardo"), 0);
			SetOfficersIndex(Pchar, 2, getCharacterIndex("PadreGerardo"));
			LAi_SetOfficerType(characterFromID("PadreGerardo"));
			Characters[GetCharacterIndex("PadreGerardo")].dialog.Filename = "Enc_Officer_dialog.c";
			Characters[GetCharacterIndex("PadreGerardo")].dialog.CurrentNode = "hired";
			Locations[FindLocation("Cuba_port")].vcskip = true;
			setCharacterShipLocation(characterFromID("Enrique Padilla"), "Cuba_port");
			pchar.quest.disguises.win_condition.l1 = "location";
			pchar.quest.disguises.win_condition.l1 = "location";
			pchar.quest.disguises.win_condition.l1.location = "Cuba_port";
			pchar.quest.disguises.win_condition = "disguises";
		break;

		case "disguises":
			ChangeCharacterAddressGroup(characterfromID("Shipguard1"), "Cuba_port", "goto", "goto_44");
			ChangeCharacterAddressGroup(characterfromID("Shipguard2"), "Cuba_port", "officers", "Sea_1_3");
			pchar.quest.In_you_go.win_condition.l1 = "locator";
			pchar.quest.In_you_go.win_condition.l1.location = "Cuba_port";
			pchar.quest.In_you_go.win_condition.l1.locator_group = "goto";
			pchar.quest.In_you_go.win_condition.l1.locator = "goto_60";
			pchar.quest.In_you_go.win_condition = "In_you_go";
		break;

		case "In_you_go":
			Characters[GetCharacterIndex("Shipguard1")].dialog.CurrentNode = "nightpadre";
			LAi_SetActorType(characterFromID("Shipguard1"));
			LAi_ActorDialog(characterFromID("Shipguard1"), pchar, "", 10.0, 1.0);
		break;

		case "believedus":
			DisableFastTravel(false);
			PChar.quest.disable_rebirth = false;
			HoistFlag(SPAIN);
			if(AUTO_SKILL_SYSTEM)
			{
				AddPartyExpChar(pchar, "Leadership", 500);
				AddPartyExpChar(pchar, "Sneak", 500);
			}
			else {AddPartyExp(pchar, 2000);}

			if (GetRMRelation(PChar, SPAIN) > REL_WAR) SetRMRelation(PChar, SPAIN, REL_WAR);

			LAi_SetPlayerType(pchar);
			GiveModel2Player(pchar.originalmodel, true);
            		SetModelfromArray(characterFromID("Crewmember_Havana"), GetModelIndex("Sailor4"));
            		SetModelfromArray(characterFromID("Crewmember_Jean3"), GetModelIndex("Sailor6"));
            		SetModelfromArray(characterFromID("Crewmember_Jean2"), GetModelIndex("Sailor3"));
			SetModelfromArray(characterFromID("Crewmember_Jean1"), GetModelIndex("Sailor5"));
			Locations[FindLocation("Havana_town_05")].reload.l3.disable = false;
			if (GetCurrentPeriod() >= PERIOD_REVOLUTIONS)
			{
				GiveShip2Character(PChar,"FastMerchantman2","Miguel de Cervantes",-1,SPAIN,true,true);
				AddQuestRecord("Beginning_Rogue", 11);
			}
			else
			{
				GiveShip2Character(PChar,"PO_Fleut50","Miguel de Cervantes",-1,SPAIN,true,true);
				AddQuestRecord("Beginning_Rogue", 5);
			}
			CloseQuestHeader("Beginning_Rogue");
			PlaceFleetNearShore("Cuba_port");

			QuestToSeaLogin_PrepareLoc("Cuba", "reload", "reload_3", false);
			QuestToSeaLogin_Launch();
			DeleteAttribute(&Locations[FindLocation("Cuba_port")],"vcskip");
			SetCharacterShipLocation(CharacterFromID("Enrique Padilla"), "None");
		break;

		case "seeyou":
			Preprocessor_AddQuestData("money", GetAttribute(CharacterFromID("Bart Renault"), "quest.money"));
			AddQuestRecord("Beginning_Rogue", 2);
			Preprocessor_Remove("money");
			if (pchar.quest.main_line == "escape_from_havana_prison")
			{
				LAi_group_SetRelation("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);
				LAi_group_FightGroups("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, true);
				//ChangeCharacterAddress(characterFromID("Havana prison commendant"), "none", "none");
			}
			pchar.quest.crewfoundyou.win_condition.l1 = "location";
			pchar.quest.crewfoundyou.win_condition.l1 = "location";
			pchar.quest.crewfoundyou.win_condition.l1.location = "Havana_Outskirts";
			pchar.quest.crewfoundyou.win_condition = "crewfoundyou";
		break;

		case "crewfoundyou":
			LAi_group_SetRelation("SPAIN_SOLDIERS", LAI_GROUP_PLAYER, LAI_GROUP_FRIEND);
           	ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Havana"), "Havana_Outskirts", "goto", "goto3");
			Characters[GetCharacterIndex("Crewmember_Havana")].dialog.CurrentNode = "hello_captain";
			LAi_SetActorType(characterFromID("Crewmember_Havana"));
			LAi_ActorDialog(characterFromID("Crewmember_Havana"), pchar, "", 10.0, 1.0);
		break;

		case "tosmuggler":
			LAi_ActorFollowEverywhere(characterFromID("Crewmember_Havana"), "", 200.0);
			setCharacterShipLocation(characterFromID("Smuggler"), "Cuba_shore_01");
			pchar.quest.crewtalk2.win_condition.l1 = "location";
			pchar.quest.crewtalk2.win_condition.l1 = "location";
			pchar.quest.crewtalk2.win_condition.l1.location = "Cuba_shore_01";
			pchar.quest.crewtalk2.win_condition = "commandeership";
			AddQuestRecord("Beginning_Rogue", 3);
		break;

		case "commandeership":
			Characters[GetCharacterIndex("Crewmember_Havana")].dialog.CurrentNode = "boarding";
			LAi_SetActorType(characterFromID("Crewmember_Havana"));
			LAi_ActorDialog(characterFromID("Crewmember_Havana"), pchar, "", 10.0, 1.0);
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean1"), "Cuba_Shore_01", "goto", "goto33");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean1"));
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean2"), "Cuba_Shore_01", "goto", "goto34");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean2"));
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean3"), "Cuba_Shore_01", "goto", "goto35");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean3"));
		break;

		case "waituntilnight":
			SetCurrentTime(24, 0);
			LAi_Fade("nightfall", "");
		break;

		case "nightfall":
			Characters[GetCharacterIndex("Crewmember_Havana")].dialog.currentnode = "night";
           	LAi_SetActorType(characterFromID("Crewmember_Havana"));
			LAi_ActorDialog(characterFromID("Crewmember_Havana"), pchar, "", 2.0, 1.0);
		break;

		case "attaque":
			DoQuestReloadToLocation("smuggler_ship", "goto", "goto1", "attaque1.5");
		break;

		case  "attaque1.5":
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean1"), "smuggler_ship", "rld", "loc2");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean1"));
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean2"), "smuggler_ship", "rld", "loc3");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean2"));
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean3"), "smuggler_ship", "goto", "goto2");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean3"));
            ChangeCharacterAddressGroup(CharacterFromID("Watch"), "smuggler_ship", "rld", "startloc");
			LAi_SetActorType(characterFromID("Watch"));
			Characters[GetCharacterIndex("Watch")].dialog.currentnode = "seeyou";
			LAi_ActorDialog(characterFromID("Watch"), pchar, "", 1.0, 1.0);
		break;

		case "attaque2":
			LAi_group_MoveCharacter(characterFromID("Watch"), "ENG_SMUGGLER");
			LAi_group_SetRelation("ENG_SMUGGLER", LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);
			LAi_group_FightGroups("ENG_SMUGGLER", LAI_GROUP_PLAYER, true);
			pchar.quest.nextstep.win_condition.l1 = "NPC_Death";
			pchar.quest.nextstep.win_condition.l1.character = "Watch";
			pchar.quest.nextstep.win_condition = "nextstep";
		break;

		case "nextstep":
			Locations[FindLocation("smuggler_ship")].reload.l2.disable = false;
			pchar.quest.nextstep2.win_condition.l1 = "location";
			pchar.quest.nextstep2.win_condition.l1 = "location";
			pchar.quest.nextstep2.win_condition.l1.location = "Smuggler_Quarter";
			pchar.quest.nextstep2.win_condition = "nextstep2";
		break;

		case "nextstep2":
			Locations[FindLocation("Smuggler_Quarter")].vcskip = true;
			Locations[FindLocation("Smuggler_Quarter")].reload.l1.disable = true;
			Locations[FindLocation("Smuggler_Quarter")].reload.l2.disable = true;
			ChangeCharacterAddress(characterFromID("Smuggler1"), "Smuggler_Quarter", "goto1");
			ChangeCharacterAddress(characterFromID("Smuggler2"), "Smuggler_Quarter", "goto2");
			ChangeCharacterAddress(characterFromID("Smuggler3"), "Smuggler_Quarter", "goto6");
			ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Jean1"), "Smuggler_Quarter", "reload", "reload1");
			LAi_SetOfficerType(characterFromID("Crewmember_Jean1"));
			LAi_group_SetRelation("ENG_SMUGGLER", LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);
			LAi_group_FightGroups("ENG_SMUGGLER", LAI_GROUP_PLAYER, true);
			pchar.quest.nextstep4.win_condition.l1 = "NPC_Death";
			pchar.quest.nextstep4.win_condition.l1.character = "Smuggler1";
			pchar.quest.nextstep4.win_condition.l2 = "NPC_Death";
			pchar.quest.nextstep4.win_condition.l2.character = "Smuggler2";
			pchar.quest.nextstep4.win_condition.l3 = "NPC_Death";
			pchar.quest.nextstep4.win_condition.l3.character = "Smuggler3";
			pchar.quest.nextstep4.win_condition = "nextstep4";
		break;

		case "nextstep4":
			Locations[FindLocation("Smuggler_Quarter")].reload.l2.disable = false;
			pchar.quest.nextstep5.win_condition.l1 = "location";
			pchar.quest.nextstep5.win_condition.l1 = "location";
			pchar.quest.nextstep5.win_condition.l1.location = "Smuggler_Cabin";
			pchar.quest.nextstep5.win_condition = "nextstep5";
		break;

		case "nextstep5":
			ChangeCharacterAddress(characterFromID("Crewmember_Jean1"), "None", "");
			ChangeCharacterAddress(characterFromID("Crewmember_Jean2"), "None", "");
			ChangeCharacterAddress(characterFromID("Crewmember_Jean3"), "None", "");
			Locations[FindLocation("Smuggler_Cabin")].reload.l1.disable = true;
            ChangeCharacterAddressGroup(CharacterFromID("Smuggler"), "Smuggler_Cabin", "sit", "sit0");
			LAi_SetActorType(characterFromID("Smuggler"));
			LAi_ActorSetSitMode(characterFromID("Smuggler"));
			Characters[GetCharacterIndex("Smuggler")].dialog.currentnode = "seeyou";
			LAi_ActorDialog(characterFromID("Smuggler"), pchar, "", 10.0, 1.0);
		break;

		case "killyou":
			ChangeCharacterAddressGroup(CharacterFromID("Smuggler"), "Smuggler_Cabin", "rld", "startloc");
			LAi_SetWarriorType(characterFromID("Smuggler"));
			LAi_group_MoveCharacter(characterFromID("Smuggler"), "ENG_SMUGGLER");
			LAi_group_SetRelation("ENG_SMUGGLER", LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);
			LAi_group_FightGroups("ENG_SMUGGLER", LAI_GROUP_PLAYER, true);
			LAi_SetFightMode(PChar, true);
			pchar.quest.captured_smuggler_ship.win_condition.l1 = "NPC_Death";
			pchar.quest.captured_smuggler_ship.win_condition.l1.character = "Smuggler";
			pchar.quest.captured_smuggler_ship.win_condition = "captured_smuggler_ship";
		break;

		case "captured_smuggler_ship":
			LAi_group_SetRelation("ENG_SMUGGLER", LAI_GROUP_PLAYER, LAI_GROUP_FRIEND);
           	ChangeCharacterAddressGroup(CharacterFromID("Crewmember_Havana"), "Smuggler_Cabin", "reload", "reload1");
			Characters[GetCharacterIndex("Crewmember_Havana")].dialog.CurrentNode = "ship_is_ours";
			LAi_SetActorType(characterFromID("Crewmember_Havana"));
			LAi_ActorDialog(characterFromID("Crewmember_Havana"), pchar, "", 2.0, 2.0);
		break;

		case "captured_smuggler_ship2":
			DisableFastTravel(false);
			PChar.quest.disable_rebirth = false;
			AddQuestRecord("Beginning_Rogue", 4);
			CloseQuestHeader("Beginning_Rogue");
			Locations[FindLocation("smuggler_ship")].reload.l1.disable = false;
			GiveShip2Character(pchar,"LuggerVML","Sea Horse",-1,ENGLAND,true,true);
			PlaceFleetNearShore("Cuba_Shore_01");
			QuestToSeaLogin_PrepareLoc("Cuba", "reload", "reload_2", false);
			QuestToSeaLogin_Launch();
		break;

		case "no_duel":
			CloseQuestHeader("Tutorial_AppearedOnIsland");
			DeleteQuestHeader("Tutorial_AppearedOnIsland");

			SetQuestHeader("Beginning_Rogue");
			if (CharPlayerType == PLAYER_TYPE_ROGUE)
			{
				if (PChar.sex == "woman") AddQuestRecord("Beginning_Rogue", 8);
				else AddQuestRecord("Beginning_Rogue", 7);
			}
			else AddQuestRecord("Beginning_Rogue", 10);
			CloseQuestHeader("Beginning_Rogue");
			DeleteAttribute(&PChar,"vcskip");

			if(CheckCharacterItem(PChar, "Spyglass1") == 0)			GiveItem2Character(PChar, "Spyglass1");
			if(CheckCharacterItem(PChar, "medical1") == 0)			TakeNItems(PChar, "medical1", 2); // PB
			if(CheckCharacterItem(PChar, PChar.start_weapon.blade) == 0)	GiveItem2Character(PChar, PChar.start_weapon.blade);
			if(CheckCharacterItem(PChar, PChar.start_weapon.gun) == 0)	GiveItem2Character(PChar, PChar.start_weapon.gun);
			DeleteAttribute(PChar, "start_weapon");

			EquiPCharacterbyItem(PChar, FindCharacterItemByGroup(&PChar, BLADE_ITEM_TYPE));
			EquiPCharacterbyItem(PChar, FindCharacterItemByGroup(&PChar, GUN_ITEM_TYPE));
			EquiPCharacterbyItem(PChar, FindCharacterItemByGroup(&PChar, SPYGLASS_ITEM_TYPE));

			//JRH ammo mod --->
			if (ENABLE_AMMOMOD) {	// LDH change
				if(CheckCharacterItem(PChar, "gunpowder") > 0)		TakeNItems(PChar, "gunpowder", -12);
				if(CheckCharacterItem(PChar, "gunpowder") == 0)		TakeNItems(PChar, "gunpowder", 6);
				if(CheckCharacterItem(PChar, "pistolbullets") > 0)	TakeNItems(PChar, "pistolbullets", -12);
				if(CheckCharacterItem(PChar, "pistolbullets") == 0)	TakeNItems(PChar, "pistolbullets", 6);
			}
			//JRH ammo mod <---

			SetCharacterGoods(PChar, CharGood1, 0); // dumps your cargo // KK
			SetCharacterGoods(PChar, CharGood2, 0);
			i = getRandomContrabandGood(GetIslandByID("Cuba"));
			if (i > 0) AddCharacterGoods(PChar, i, (2.0+rand(2))/10.0 * GetCharacterFreeSpace(PChar, i));
			SafePortLeave(SPAIN, false);

			//PW clear boat reloads ----->
			string ship_deck = GetCharacterShipQDeck(PChar);
			Locations[FindLocation(ship_deck)].reload.l4.disable = 0;
			Locations[FindLocation(ship_deck)].reload.l5.disable = 0;
			//PW clear boat reloads <-----
			//GR Clear cabin reload and remove tutorial officer ---->
			Locations[FindLocation("Tutorial_Deck")].reload.l1.disable = 0;
			ChangeCharacterAddressGroup(CharacterFromID("Malcolm Hatcher"), "none", "", "");
			//GR Clear cabin reload and remove tutorial officer <----

			QuestToSeaLogin_PrepareLoc("Cuba", "reload", "reload_7", false);
			QuestToSeaLogin_Launch();
		break;
		
///////////////////////////////////////////////////////////////
///// A FAMILY' STORY
///////////////////////////////////////////////////////////////

		case "madero_start":
			SetEnterLocationQuest("Eleuthera_townhall", "madero_start_check", 0);
		break;

		case "madero_start_check":
			if(makeint(PChar.rank) >= 10)
			{
				PlaceCharacter(characterFromID("Alonso Madero"), "goto");
				LAi_SetActorType(characterFromID("Alonso Madero"));
				Characters[GetCharacterIndex("Alonso Madero")].dialog.currentnode = "begin_1";
				LAi_ActorDialog(characterFromID("Alonso Madero"), pchar, "", 2.0, 1.0);	
			}
		break;

		case "recusar_oferta":
			DeleteEnterLocationQuest("Eleuthera_townhall", "madero_start_check");
			LAi_SetActorType(characterFromID("Alonso Madero"));
			LAi_ActorRunToLocation(characterFromID("Alonso Madero"), "reload", "reload1", "none", "", "", "", 0.0);	
			break;

		case "aceitar_oferta":
			DeleteEnterLocationQuest("Eleuthera_townhall", "madero_start_check");
			ChangeCharacterAddressGroup(CharacterFromID("Elvira Suarez"), "Suarez_House", "goto", "goto8");
			LAi_SetActorType(characterFromID("Alonso Madero"));
			LAi_ActorRunToLocation(characterFromID("Alonso Madero"), "reload", "reload1", "none", "", "", "", 0.0);
			Characters[GetCharacterIndex("Elvira Suarez")].dialog.currentnode = "begin_1";
			SetQuestHeader("Family_Story");
			AddQuestRecord("Family_Story", 1);
			break;

		case "recusar_oferta_2":
			AddQuestRecord("Family_Story", 2);
			CloseQuestHeader("Family_Story");
			break;

		case "aceitar_oferta_2":
			PChar.quest.kidnapping = "abel_barco";
			AddQuestRecord("Family_Story", 3);
			break;

		case "encontrar_abel":
			Locations[FindLocation("Tortuga_port")].reload.l11.disable = 1;
			AddQuestRecord("Family_Story", 4);
			PChar.quest.kidnapping.over = "yes";

			PChar.quest.ver_abel.win_condition.l1 = "Timer";
			PChar.quest.ver_abel.win_condition.l1 = "Timer";
			PChar.quest.ver_abel.win_condition.l1.date.day = GetAddingDataDay(0,0,1);
			PChar.quest.ver_abel.win_condition.l1.date.month = GetAddingDataMonth(0,0,1);
			PChar.quest.ver_abel.win_condition.l1.date.year = GetAddingDataYear(0,0,1);
			PChar.quest.ver_abel.win_condition = "encontrar_abel_2";
			break;
			
		case "encontrar_abel_2":
			AddQuestRecord("Family_Story", 5);
			ChangeCharacterAddressGroup(CharacterFromID("Abel Barco"), "Santiago_town_exit2", "goto", "citizen03");
			Characters[GetCharacterIndex("Abel Barco")].dialog.currentnode = "begin_1";
			break;

		case "combater_abel":
			LAi_SetImmortal(characterFromID("Abel Barco"), true);
			LAi_SetActorType(characterFromID("Abel Barco"));
			LAi_ActorAttack(CharacterFromID("Abel Barco"), Pchar, "");

			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, "pirat3", "goto", "locator8");
			GiveItem2Character(sld,"blade2");
			EquipCharacterByItem(sld,"blade2");
			LAi_SetHP(sld, 80.0, 80.0);
			LAi_group_MoveCharacter(sld, "PIRATES_ABEL");

			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.25, "pirat4", "goto", "locator8");
			GiveItem2Character(sld,"blade2");
			EquipCharacterByItem(sld,"blade2");
			LAi_SetHP(sld, 80.0, 80.0);
			LAi_group_MoveCharacter(sld, "PIRATES_ABEL");

			LAi_group_FightGroups("PIRATES_ABEL", LAI_GROUP_PLAYER, true);

			LAi_group_SetCheck("PIRATES_ABEL", "desistir_abel");
			break;

		case "desistir_abel":
			LAi_SetActorType(characterFromID("Abel Barco"));
			Characters[GetCharacterIndex("Abel Barco")].dialog.currentnode = "begin_5";
			LAi_ActorDialog(characterFromID("Abel Barco"), pchar, "", 2.0, 1.0);
			break;

		case "ir_tortuga":
			Locations[FindLocation("Tortuga_port")].models.day.locators = "Tortuga_lBOP_day";
			Locations[FindLocation("Tortuga_port")].models.night.locators = "Tortuga_lBOP_night";
			Locations[FindLocation("Tortuga_port")].locators_radius.goto.goto40 = 2.0;			
			ChangeCharacterAddressGroup(CharacterFromID("kidnapper_1"), "Tortuga_port", "reload", "brothel");	
			ChangeCharacterAddressGroup(CharacterFromID("kidnapper_2"), "Tortuga_port", "goto", "goto34");
			Characters[GetCharacterIndex("kidnapper_1")].dialog.currentnode = "begin_1";
			Characters[GetCharacterIndex("kidnapper_2")].dialog.currentnode = "begin_1";			
			AddQuestRecord("Family_Story", 6);	
			LAi_SetActorType(characterFromID("Abel Barco"));
			LAi_ActorRunToLocation(characterFromID("Abel Barco"), "reload", "reload2", "none", "", "", "", 4.0);
			break;	
			
		case "ir_janela":
			Characters[GetCharacterIndex("kidnapper_1")].dialog.currentnode = "First time";
			Characters[GetCharacterIndex("kidnapper_2")].dialog.currentnode = "First time";		
			AddQuestRecord("Family_Story", 7);

			pchar.quest.ate_janela.win_condition.l1 = "locator";			
			pchar.quest.ate_janela.win_condition.l1 = "locator";
			pchar.quest.ate_janela.win_condition.l1.location = "Tortuga_port";
			pchar.quest.ate_janela.win_condition.l1.locator_group = "goto";
			pchar.quest.ate_janela.win_condition.l1.locator = "goto40";
			pchar.quest.ate_janela.win_condition = "ir_suarez_quarto";
            break;

		case "ir_suarez_quarto":	
            DoQuestReloadToLocation("Tortuga_Pirate_House", "goto", "goto1" ,"falar_suarez");
            break;

		case "falar_suarez":
			ChangeCharacterAddressGroup(characterFromID("Fernando Suarez"), "Tortuga_Pirate_House", "reload", "reload1");
			Characters[GetCharacterIndex("Fernando Suarez")].dialog.currentnode = "begin_1";			
			LAi_SetActorType(characterFromID("Fernando Suarez"));
			LAi_ActorDialog(characterFromID("Fernando Suarez"), pchar, "", 5.0, 1.0);
            break;

		case "ir_santiago":
			HoistFlag(PIRATE);			
	        LAi_SetOfficerType(characterFromID("Fernando Suarez"));
			SetOfficersIndex(PChar, -1, GetCharacterIndex("Fernando Suarez"));
			GiveItem2Character(CharacterFromId("Fernando Suarez"), "blade44");
			EquipCharacterByItem(CharacterFromId("Fernando Suarez"), "blade44");
			GiveItem2Character(CharacterFromId("Fernando Suarez"), "pistol1");
			EquipCharacterByItem(CharacterFromId("Fernando Suarez"), "pistol1");
			
			ChangeCharacterAddressGroup(CharacterFromID("kidnapper_1"), "none", "", "");	
			ChangeCharacterAddressGroup(CharacterFromID("kidnapper_2"), "none", "", "");	
			ChangeCharacterAddressGroup(CharacterFromID("kidnapper_3"), "none", "", "");
			
			QuestToSeaLogin_PrepareLoc("Hispaniola", "reload", "reload_7", true);
			QuestToSeaLogin_Launch();
			AddQuestRecord("Family_Story", 8);
			
			Pchar.quest.ate_santiago.win_condition.l1 = "location";
			Pchar.quest.ate_santiago.win_condition.l1 = "location";
			Pchar.quest.ate_santiago.win_condition.l1.location = "Santiago_port";
			PChar.quest.ate_santiago.win_condition = "explicar_suarez";
            break;

		case "explicar_suarez":
			Locations[FindLocation("Santiago_town_01")].models.always.add9 = "globe";	//JRH: showing the way to the cartographer
			Locations[FindLocation("Tortuga_port")].models.day.locators = "Tortuga_l_day";
			Locations[FindLocation("Tortuga_port")].models.night.locators = "Tortuga_l_night";		
            Locations[FindLocation("Santiago_Tavern")].vcskip = true;		
			Characters[GetCharacterIndex("Fernando Suarez")].dialog.currentnode = "begin_5";		
			LAi_SetActorType(characterFromID("Fernando Suarez"));
			LAi_ActorDialog(characterFromID("Fernando Suarez"), pchar, "", 5.0, 1.0);
            break;
			
		case "ir_taberna":
			RemovePassenger(pchar, characterFromID("Fernando Suarez"));
			RemoveCharacterCompanion(pchar, characterFromID("Fernando Suarez"));
			RemoveOfficersIndex(pchar, GetCharacterIndex("Fernando Suarez"));
            DoQuestReloadToLocation("Santiago_Tavern", "sit", "sit6" ,"ir_taberna2");
            break;					
			
		case "ir_taberna2":
			Locations[FindLocation("Santiago_town_01")].models.always.add9 = "globe";	//JRH: showing the way to the cartographer
			ChangeCharacterAddressGroup(characterFromID("Fernando Suarez"), "Santiago_Tavern", "sit", "sit7");
			LAi_SetActorType(characterFromID("Fernando Suarez"));
			LAi_SetSitType(characterFromID("Fernando Suarez"));			
			LAi_SetActorType(pchar);
			LAi_ActorSetSitMode(pchar);
			Characters[GetCharacterIndex("Fernando Suarez")].dialog.currentnode = "begin_8";		
			LAi_ActorWaitDialog(CharacterFromID("Fernando Suarez"), Pchar);
			LAi_ActorDialog(pchar, characterFromID("Fernando Suarez"),"", 10.0, 10.0);
            break;
			
		case "meet_chaparro":
			Locations[FindLocation("Santiago_town_01")].models.always.add9 = "globe";	//JRH: showing the way to the cartographer
			DeleteAttribute(&Locations[FindLocation("Santiago_Tavern")],"vcskip");		
		    LAi_SetPlayerType(pchar);
			ChangeCharacterAddressGroup(CharacterFromID("Arnaldo Chaparro"), "Cartographer_House", "sit", "sit1");					
            DoQuestReloadToLocation("Santiago_Tavern", "goto", "goto6" ,"meet_chaparro2");		
            break;				

		case "meet_chaparro2":	
			ChangeCharacterAddressGroup(characterFromID("Fernando Suarez"), "Santiago_Tavern", "goto", "goto2");
	        LAi_SetOfficerType(characterFromID("Fernando Suarez"));
			SetOfficersIndex(PChar, -1, GetCharacterIndex("Fernando Suarez"));			
			Characters[GetCharacterIndex("Arnaldo Chaparro")].dialog.currentnode = "begin_1";				
			AddQuestRecord("Family_Story", 9);				
            break;
			
		case "ir_ile_vache":
			Characters[GetCharacterIndex("Fernando Suarez")].dialog.currentnode = "begin_23";				
			LAi_SetActorType(characterFromID("Fernando Suarez"));
			LAi_ActorDialog(characterFromID("Fernando Suarez"), pchar, "", 5.0, 1.0);	
            break;					

		case "ir_ile_vache2":
			LAi_SetActorType(characterFromID("Fernando Suarez"));		
	        LAi_SetOfficerType(characterFromID("Fernando Suarez"));		
			AddQuestRecord("Family_Story", 10);

			Pchar.quest.ir_vache.win_condition.l1 = "location";			
			Pchar.quest.ir_vache.win_condition.l1 = "location";
			Pchar.quest.ir_vache.win_condition.l1.location = "Hispaniola_shore_04";
			PChar.quest.ir_vache.win_condition = "search_bart";			
            break;

		case "search_bart":
			Characters[GetCharacterIndex("Fernando Suarez")].dialog.currentnode = "begin_24";				
			LAi_SetActorType(characterFromID("Fernando Suarez"));
			LAi_ActorDialog(characterFromID("Fernando Suarez"), pchar, "", 5.0, 1.0);	
            break;

		case "search_bart2":
	        LAi_SetOfficerType(characterFromID("Fernando Suarez"));
			
			Pchar.quest.find_bart.win_condition.l1 = "location";			
			Pchar.quest.find_bart.win_condition.l1 = "location";
			Pchar.quest.find_bart.win_condition.l1.location = "Hispaniola_Grot";
			PChar.quest.find_bart.win_condition = "encontrar_corpo";				
            break;

		case "encontrar_corpo":
            LAi_SetStayType(characterFromID("Fernando Suarez"));		
			ChangeCharacterAddressGroup(characterFromID("Fernando Suarez"), "Hispaniola_Grot", "monsters", "monster2");
			sld = LAi_CreateFantomCharacter(false, 0, true, false, 0.25, "Skel3", "monsters", "monster4");
		    sld.name = "Bartolomeu";
			sld.lastname = "Portugues";			
			LAi_SetActorType(sld);
			LAi_ActorSetLayMode(sld);
			sld = LAi_CreateFantomCharacter(false, 0, true, false, 0.25, "Skel1", "monsters", "monster3");
		    sld.name = "Guillaume";
			sld.lastname = "Auger";			
			LAi_SetActorType(sld);
			LAi_ActorSetLayMode(sld);				
			Characters[GetCharacterIndex("Fernando Suarez")].dialog.currentnode = "begin_25";
            break;

		case "voltar_praia":
			RemovePassenger(pchar, characterFromID("Fernando Suarez"));
			RemoveCharacterCompanion(pchar, characterFromID("Fernando Suarez"));
			RemoveOfficersIndex(pchar, GetCharacterIndex("Fernando Suarez"));	
            DoQuestReloadToLocation("Hispaniola_shore_04", "goto", "citizen08" ,"embarquar");		
            break;

		case "embarquar":
			ChangeCharacterAddressGroup(characterFromID("Fernando Suarez"), "Hispaniola_shore_04", "goto", "locator12");			
			Characters[GetCharacterIndex("Fernando Suarez")].dialog.currentnode = "begin_27";				
			LAi_SetActorType(characterFromID("Fernando Suarez"));
			LAi_ActorDialog(characterFromID("Fernando Suarez"), pchar, "", 5.0, 1.0);	
            break;

		case "voltar_havana":
	        LAi_SetOfficerType(characterFromID("Fernando Suarez"));
			SetOfficersIndex(PChar, -1, GetCharacterIndex("Fernando Suarez"));				
			Characters[GetCharacterIndex("Elvira Suarez")].dialog.currentnode = "begin_11";		
			AddQuestRecord("Family_Story", 11);
            break;

		case "adeus_fernando":		
			Characters[GetCharacterIndex("Fernando Suarez")].dialog.currentnode = "begin_28";				
			LAi_SetActorType(characterFromID("Fernando Suarez"));
			LAi_ActorDialog(characterFromID("Fernando Suarez"), pchar, "", 5.0, 1.0);	
            break;

		case "deixar_suarez":
			DisableFastTravel(true);
			DisableMenuLaunch(true);		
            LAi_SetCitizenType(characterFromID("Fernando Suarez"));		
			PlayStereoSound("INTERFACE\took_item.wav");
			GiveItem2Character(Pchar, "bladeBP");

			Pchar.quest.fight_acre.win_condition.l1 = "location";			
			Pchar.quest.fight_acre.win_condition.l1 = "location";
			Pchar.quest.fight_acre.win_condition.l1.location = "Havana_Town_02";
			PChar.quest.fight_acre.win_condition = "combat_acre";			
            break;

		case "combat_acre":
			ChangeCharacterAddressGroup(characterFromID("Robert Acre"), "Havana_Town_02", "goto", "goto16");
			
			LAi_SetActorType(characterFromID("Robert Acre"));
			LAi_NoRebirthEnable(characterFromID("Robert Acre"));
			LAi_ActorAttack(CharacterFromID("Robert Acre"), Pchar, "");

			pchar.quest.pirate_died.win_condition.l1 = "NPC_Death";
			pchar.quest.pirate_died.win_condition.l1.character = "Robert Acre";
			pchar.quest.pirate_died.win_condition = "final_estoria";
            break;

		case "final_estoria":
			DisableFastTravel(false);
			DisableMenuLaunch(false);		
			Locations[FindLocation("Tortuga_port")].reload.l11.disable = 0;		
			AddQuestRecord("Family_Story", 12);
			CloseQuestHeader("Family_Story");
			if(AUTO_SKILL_SYSTEM)
			{
				AddPartyExpChar(pchar, "Leadership", 20000);
				AddPartyExpChar(pchar, "Sneak", 200);
			}
			else { AddPartyExp(pchar, 20000); }			
            break;
			
		case "deixar_suarezB":
			DisableFastTravel(true);
			DisableMenuLaunch(true);		
            LAi_SetCitizenType(characterFromID("Fernando Suarez"));		
			PlayStereoSound("INTERFACE\took_item.wav");
			GiveItem2Character(Pchar, "bladeBP");

			Pchar.quest.fight_acreB.win_condition.l1 = "location";			
			Pchar.quest.fight_acreB.win_condition.l1 = "location";
			Pchar.quest.fight_acreB.win_condition.l1.location = "Havana_Town_02";
			PChar.quest.fight_acreB.win_condition = "combat_acreB";			
            break;

		case "combat_acreB":
			ChangeCharacterAddressGroup(characterFromID("Robert Acre"), "Havana_Town_02", "goto", "goto16");
			
			LAi_SetActorType(characterFromID("Robert Acre"));
			LAi_NoRebirthEnable(characterFromID("Robert Acre"));
			LAi_ActorAttack(CharacterFromID("Robert Acre"), Pchar, "");

			pchar.quest.pirate_diedB.win_condition.l1 = "NPC_Death";
			pchar.quest.pirate_diedB.win_condition.l1.character = "Robert Acre";
			pchar.quest.pirate_diedB.win_condition = "Ir_Grenada";
            break;	
			
		case "Ir_Grenada":	
			DisableFastTravel(false);
			DisableMenuLaunch(false);		
			Locations[FindLocation("Tortuga_port")].reload.l11.disable = 0;
		    //-> open Grenada Shore
			Island_SetReloadEnableLocal("Conceicao", "reload_4", true);
			Islands[FindIsland("Conceicao")].reload.l5.goto_enable = true; // PB			
		    //<- open Grenada Shore
    		Locations[FindLocation("Bartolomeu_Mansion")].locators_radius.goto.citizen06 = 1.2;
    		Locations[FindLocation("Bartolomeu_Mansion")].locators_radius.goto.goto1 = 8.0;
			
			Pchar.quest.shore_patrol.win_condition.l1 = "location";			
			Pchar.quest.shore_patrol.win_condition.l1 = "location";
			pchar.quest.shore_patrol.win_condition.l1.location = "Conceicao_Shore_03";
			pchar.quest.shore_patrol.win_condition = "found_patrol";			
			
			AddQuestRecord("Family_Story", 13);
			if(AUTO_SKILL_SYSTEM)
			{
				AddPartyExpChar(pchar, "Leadership", 20000);
				AddPartyExpChar(pchar, "Sneak", 200);
			}
			else { AddPartyExp(pchar, 20000); }			
            break;
			
		case "found_patrol":				
			LAi_SetActorType(Pchar);
			Pchar.Temp.self.dialog = Pchar.dialog.currentnode;
			Pchar.dialog.currentnode = "Dead_Patrol";
			LAi_ActorSelfDialog(Pchar, "player_back");
            break;

		case "meet_french":
            LAi_group_SetRelation("NAPOLEONIC_SOLDIERS", LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);		
			LAi_SetPlayerType(Pchar);
			
			Pchar.quest.meet_french_soldiers.win_condition.l1 = "location";			
			Pchar.quest.meet_french_soldiers.win_condition.l1 = "location";
			pchar.quest.meet_french_soldiers.win_condition.l1.location = "Bartolomeu_Mansion";
			pchar.quest.meet_french_soldiers.win_condition = "french_camp";			
            break;

		case "french_camp":
			LAi_SetActorType(Pchar);
			Pchar.Temp.self.dialog = Pchar.dialog.currentnode;
			if(GetTime() >= 22.0 || GetTime() < 6.0 ){			
			Pchar.dialog.currentnode = "See_French_Camp";
	        }else{
			Pchar.dialog.currentnode = "See_French_Camp_Bis";				
			}	
			LAi_ActorSelfDialog(Pchar, "player_back");		
            break;
			
		case "voltar_mais_tarde":
			LAi_SetPlayerType(Pchar);		
            DoQuestReloadToLocation("Conceicao_Shore_03", "goto", "citizen01" ,"voltar_mais_tarde_bis");		
            break;
			
		case "voltar_mais_tarde_bis":
			AddQuestRecord("Family_Story", 14);		
			pchar.quest.explosao_canao.win_condition.l1 = "locator";
			pchar.quest.explosao_canao.win_condition.l1.location = "Bartolomeu_Mansion";
			pchar.quest.explosao_canao.win_condition.l1.locator_group = "goto";
			pchar.quest.explosao_canao.win_condition.l1.locator = "goto1";
			pchar.quest.explosao_canao.win_condition = "explosao";			
            break;			

		case "explosao":
			if(GetTime() < 22.0 && GetTime() >= 6.0 ){
			CreateParticleSystemX("blast_inv", 1.337, 1, 18.652, -1.57, 0.0, 0.0,0);
			CreateParticleSystemX("cancloud", -3.337, 1, 18.652, -1.57, 0.0, 0.0,20);
			CreateParticleSystemX("cancloud", 5.337, 1, 18.652, -1.57, 0.0, 0.0,20);
			CreateParticleSystemX("cancloud", 1.337, 1, 22.652, -1.57, 0.0, 0.0,20);
			CreateParticleSystemX("cancloud", 1.337, 1, 14.652, -1.57, 0.0, 0.0,20);
			PlayStereoSound("OBJECTS\SHIPCHARGE\cannon_fire1.wav");
			PlaySound("OBJECTS\shipcharge\hit_torock.wav");
			LAi_KillCharacter(Pchar);
            }else{
			pchar.quest.bart_chest.win_condition.l1 = "locator";
			pchar.quest.bart_chest.win_condition.l1.location = "Bartolomeu_Mansion";
			pchar.quest.bart_chest.win_condition.l1.locator_group = "goto";
			pchar.quest.bart_chest.win_condition.l1.locator = "citizen06";
			pchar.quest.bart_chest.win_condition = "dialogue_chest";					
			}			
            break;		

		case "find_chest":
			LAi_SetPlayerType(Pchar);		
			pchar.quest.bart_chest.win_condition.l1 = "locator";
			pchar.quest.bart_chest.win_condition.l1.location = "Bartolomeu_Mansion";
			pchar.quest.bart_chest.win_condition.l1.locator_group = "goto";
			pchar.quest.bart_chest.win_condition.l1.locator = "citizen06";
			pchar.quest.bart_chest.win_condition = "dialogue_chest";			
            break;

		case "dialogue_chest":
			Pchar.quest.explosao_canao.over = "yes";		
			LAi_SetActorType(Pchar);
			Pchar.Temp.self.dialog = Pchar.dialog.currentnode;
			Pchar.dialog.currentnode = "Key_Chest";
			LAi_ActorSelfDialog(Pchar, "player_back");		
            break;

		case "search_rifle":
			PlayStereoSound("INTERFACE\took_item.wav");		
			LAi_SetPlayerType(Pchar);		
			pchar.quest.bart_chestB.win_condition.l1 = "locator";
			pchar.quest.bart_chestB.win_condition.l1.location = "Bartolomeu_Mansion";
			pchar.quest.bart_chestB.win_condition.l1.locator_group = "goto";
			pchar.quest.bart_chestB.win_condition.l1.locator = "citizen08";
			pchar.quest.bart_chestB.win_condition = "found_rifle";			
            break;

   		case "found_rifle":
			PlayStereoSound("INTERFACE\took_item.wav");
			GiveItem2Character(pchar, "LongRifle_BT");			
			AddQuestRecord("Family_Story", 15);

			Pchar.quest.french_patrol.win_condition.l1 = "location";			
			Pchar.quest.french_patrol.win_condition.l1 = "location";
			pchar.quest.french_patrol.win_condition.l1.location = "Conceicao_Shore_03";
			pchar.quest.french_patrol.win_condition = "french_patrol_beach";				
            break;

		case "french_patrol_beach":
		    DisableFastTravel(true);
			DisableMenuLaunch(true);
			locations[FindLocation("Conceicao_Shore_03")].reload.l3.disable = 1;
			locations[FindLocation("Conceicao_Shore_03")].reload.l2.disable = 1;
			
			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.0, Nations[FRANCE].fantomModel.m1, "goto", "citizen07");
			LAi_group_MoveCharacter(sld, "FRENCH_PATROL");
			sld.nation = FRANCE;
			SetRandomNameToCharacter(sld);
			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.0, Nations[FRANCE].fantomModel.m2, "goto", "citizen05");
			LAi_group_MoveCharacter(sld, "FRENCH_PATROL");
			sld.nation = FRANCE;
			SetRandomNameToCharacter(sld);
			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.0, Nations[FRANCE].fantomModel.m3, "goto", "citizen04");
			LAi_group_MoveCharacter(sld, "FRENCH_PATROL");
			sld.nation = FRANCE;
			SetRandomNameToCharacter(sld);
			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.0, Nations[FRANCE].fantomModel.m4, "goto", "citizen01");
			LAi_group_MoveCharacter(sld, "FRENCH_PATROL");
			sld.nation = FRANCE;
			SetRandomNameToCharacter(sld);
			LAi_group_FightGroups("FRENCH_PATROL", LAI_GROUP_PLAYER, true);
			LAi_group_SetCheck("FRENCH_PATROL", "Fight_Victorieuse");			
            break;		
			
		case "Fight_Victorieuse":
			DisableFastTravel(false);
			DisableMenuLaunch(false);
			locations[FindLocation("Conceicao_Shore_03")].reload.l3.disable = 0;
			locations[FindLocation("Conceicao_Shore_03")].reload.l2.disable = 0;
			
			Pchar.quest.combattre_victorieuse.win_condition.l1 = "location";		
			Pchar.quest.combattre_victorieuse.win_condition.l1 = "location";
			Pchar.quest.combattre_victorieuse.win_condition.l1.location = "Conceicao";
			PChar.quest.combattre_victorieuse.win_condition = "Fight_Victorieuse_Bis";
			break;

     	case "Fight_Victorieuse_Bis":
			HoistFlag(PERSONAL_NATION);		
			SetRMRelation(PChar, FRANCE, REL_WAR);		
			SetCharacterRelationBoth(GetCharacterIndex("Renouart Larrouse"),GetMainCharacterIndex(),RELATION_ENEMY);

			Group_CreateGroup("Renouart Larrouse");
			Group_AddCharacter("Renouart Larrouse", "Renouart Larrouse");
			Group_SetGroupCommander("Renouart Larrouse", "Renouart Larrouse");
			Group_SetPursuitGroup("Renouart Larrouse", PLAYER_GROUP);
			Group_SetTaskAttack("Renouart Larrouse", PLAYER_GROUP, true);
			Group_LockTask("Renouart Larrouse");
			Group_SetAddress("Renouart Larrouse", Characters[GetMainCharacterIndex()].location, "", "");

			UpdateRelations();

			Pchar.quest.gagne_victorieuse.win_condition.l1 = "NPC_Death";
			Pchar.quest.gagne_victorieuse.win_condition.l1.character = "Renouart Larrouse";
			Pchar.quest.gagne_victorieuse.win_condition = "won_victorieuse";
			break;

    	case "won_victorieuse":
			Pchar.quest.gagne_victorieuse.over = "yes";
			ChangeCharacterAddressGroup(CharacterFromID("Quest_French_Guard1"), "none", "", "");
			ChangeCharacterAddressGroup(CharacterFromID("Quest_French_Guard2"), "none", "", "");
			ChangeCharacterAddressGroup(CharacterFromID("Quest_French_Guard3"), "none", "", "");
			ChangeCharacterAddressGroup(CharacterFromID("Quest_French_Guard4"), "none", "", "");
			ChangeCharacterAddressGroup(CharacterFromID("Quest_French_Guard5"), "none", "", "");			
			ChangeCharacterAddressGroup(CharacterFromID("Quest_English_Patrol1"), "none", "", "");
			ChangeCharacterAddressGroup(CharacterFromID("Quest_English_Patrol2"), "none", "", "");

			Characters[GetCharacterIndex("Cole Arkwright")].dialog.currentnode = "gov_15";			
			AddQuestRecord("Family_Story","16");
			break;

    	case "meet_lafitte":
			CloseQuestHeader("Family_Story");		
			SetQuestHeader("French_Companion");		
			AddQuestRecord("French_Companion","1");
			ChangeCharacterAddressGroup(characterFromID("Jean Lafitte"), "Tortuga_tavern", "goto", "goto8");
			SetCharacterShipLocation(CharacterFromID("Jean Lafitte"), "Tortuga_port");			
			LAi_SetCitizenType(characterFromID("Jean Lafitte"));
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_1";			
		break;
		
		case "abandon_quest":
			SetQuestHeader("French_Companion");		
			AddQuestRecord("French_Companion","6");
			CloseQuestHeader("French_Companion");
        break;			

		case "lafitte_tavern":
            DoQuestReloadToLocation("Tortuga_tavern", "sit", "sit2" ,"lafitte_tavern2");
        break;					
			
		case "lafitte_tavern2":
            Locations[FindLocation("Tortuga_port")].vcskip = true;		
			ChangeCharacterAddressGroup(characterFromID("Jean Lafitte"), "Tortuga_tavern", "sit", "sit8");
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			LAi_SetSitType(characterFromID("Jean Lafitte"));			
			LAi_SetActorType(pchar);
			LAi_ActorSetSitMode(pchar);
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_4";		
			LAi_ActorWaitDialog(CharacterFromID("Jean Lafitte"), Pchar);
			LAi_ActorDialog(pchar, characterFromID("Jean Lafitte"),"", 10.0, 10.0);
        break;

		case "lafitte_tortuga_port":
            Locations[FindLocation("Tortuga_tavern")].vcskip = false;			
		    LAi_SetPlayerType(pchar);				
            DoQuestReloadToLocation("Tortuga_port", "reload", "reload2_back" ,"leave_tortuga");		
        break;				

		case "leave_tortuga":	
			ChangeCharacterAddressGroup(CharacterFromID("Jean Lafitte"), "Tortuga_port", "goto", "goto31");
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_16";
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			LAi_ActorDialog(characterFromID("Jean Lafitte"), pchar, "", 3.0, 1.0);
        break;

		case "leave_tortuga2":
            Locations[FindLocation("Tortuga_port")].vcskip = false;		
			AddQuestRecord("French_Companion","2");			
			SetCompanionIndex(Pchar, -1, GetCharacterIndex("Jean Lafitte"));
			SetCharacterRemovable(characterFromID("Jean Lafitte"), false);
            ChangeCharacterAddressGroup(CharacterFromID("Jean Lafitte"), "none", "", "");			

			pchar.quest.go_turks.win_condition.l1 = "location";
			pchar.quest.go_turks.win_condition.l1.location = "Turks_Lighthouse";
			pchar.quest.go_turks.win_condition = "arrived_turks";
	    break;

		case "arrived_turks":
			Locations[FindLocation("Turks_port")].models.always.locators = "Margarita_locators_quest";					
			ChangeCharacterAddressGroup(CharacterFromID("Jean Lafitte"), "Turks_Lighthouse", "goto", "goto2");
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_18";
			LAi_ActorDialog(characterFromID("Jean Lafitte"), pchar, "", 5.0, 1.0);
	    break;

		case "go_turks":
			SetCharacterShipLocation(CharacterFromID("Nigel Chandler"), "Turks_port");
			Locations[FindLocation("Turks_port")].locators_radius.goto.P_goto4 = 3.0;
            SetOfficersIndex(PChar, -1, GetCharacterIndex("Jean Lafitte"));				
			LAi_SetOfficerType(characterFromID("Jean Lafitte"));

			pchar.quest.go_town_turks.win_condition.l1 = "location";
			pchar.quest.go_town_turks.win_condition.l1.location = "Turks_port";
			pchar.quest.go_town_turks.win_condition = "arrived_town_turks";
		break;

		case "arrived_town_turks":
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_20";
			LAi_ActorDialog(characterFromID("Jean Lafitte"), pchar, "", 2.0, 1.0);
		break;

		case "go_port_turks":		
			LAi_SetOfficerType(characterFromID("Jean Lafitte"));			

			pchar.quest.go_turks_port.win_condition.l1 = "locator";
			pchar.quest.go_turks_port.win_condition.l1.location = "Turks_port";
			pchar.quest.go_turks_port.win_condition.l1.locator_group = "goto";
			pchar.quest.go_turks_port.win_condition.l1.locator = "P_goto4";
			pchar.quest.go_turks_port.win_condition = "see_warship_moored";			
		break;

		case "see_warship_moored":
			RemovePassenger(pchar, characterFromID("Jean Lafitte"));
			RemoveOfficersIndex(pchar, GetCharacterIndex("Jean Lafitte"));			
			Locations[FindLocation("Turks_Tavern")].vcskip = true;					
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_21";
			LAi_ActorDialog(characterFromID("Jean Lafitte"), pchar, "", 10.0, 1.0); 
		break;
			
		case "Talks_in_Turks_Tavern":	
			DoQuestReloadToLocation("Turks_Tavern", "candles", "sit3" ,"Talks_in_Turks_Tavern2");
		break;			

		case "Talks_in_Turks_Tavern2":
			ChangeCharacterAddressGroup(characterFromID("Jean Lafitte"), "Turks_Tavern", "sit", "sit4");
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			LAi_SetSitType(characterFromID("Jean Lafitte"));			
			LAi_SetActorType(pchar);
			LAi_ActorSetSitMode(pchar);
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_23";		
			LAi_ActorWaitDialog(CharacterFromID("Jean Lafitte"), Pchar);
			LAi_ActorDialog(pchar, characterFromID("Jean Lafitte"),"", 10.0, 10.0);
	    break;

		case "Talks_Turks_Barman":
			Locations[FindLocation("Turks_Tavern")].vcskip = false;			
			Characters[GetCharacterIndex("Josephine Bonassieu")].dialog.currentnode = "begin_1";				
			LAi_SetPlayerType(pchar);				
			DoQuestReloadToLocation("Turks_Tavern", "goto", "goto7" ,"Talks_Turks_Barman2");		
		break;				

		case "Talks_Turks_Barman2":	
			ChangeCharacterAddressGroup(CharacterFromID("Jean Lafitte"), "Turks_Tavern", "goto", "goto6");
			AddPassenger(Pchar, characterFromID("Jean Lafitte"), 0);
			SetOfficersIndex(PChar, -1, GetCharacterIndex("Jean Lafitte"));
		break;

		case "Talks_Laura_Cotton":
			AddQuestRecord("French_Companion","3");
		
			pchar.quest.go_laura_house.win_condition.l1 = "locator";
			pchar.quest.go_laura_house.win_condition.l1.location = "Turks_port";
			pchar.quest.go_laura_house.win_condition.l1.locator_group = "Reload";
			pchar.quest.go_laura_house.win_condition.l1.locator = "houseH3";
			pchar.quest.go_laura_house.win_condition = "See_Laura_Cotton";			
        break;

		case "See_Laura_Cotton":
			ChangeCharacterAddressGroup(characterFromID("Laura Cotton"), "Turks_port", "Reload", "reload_jail");
	        Characters[GetCharacterIndex("Laura Cotton")].dialog.currentnode = "begin_1";		
            LAi_SetActorType(characterFromID("Laura Cotton"));
			LAi_ActorDialog(characterFromID("Laura Cotton"), pchar, "", 5.0, 1.0);				
        break;

		case "waiting_Laura_Cotton":
			RemovePassenger(pchar, characterFromID("Jean Lafitte"));
			RemoveOfficersIndex(pchar, GetCharacterIndex("Jean Lafitte"));		
			WaitDate("", 0,0,1,0,0);		
			SetCurrentTime(00.00, 0); 
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_30";			
            DoQuestReloadToLocation("Turks_port", "goto", "goto36" ,"waiting_Laura_Cotton2");			
        break;

		case "waiting_Laura_Cotton2":
			ChangeCharacterAddressGroup(characterFromID("Jean Lafitte"), "Turks_port", "goto", "goto37");
			ChangeCharacterAddressGroup(characterFromID("Laura Cotton"), "Turks_port", "goto", "goto38");
			ChangeCharacterAddressGroup(characterFromID("Killian Bencroft"), "Turks_port", "goto", "goto39");				
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			LAi_ActorDialog(characterFromID("Jean Lafitte"), pchar, "", 2.0, 1.0);			
        break;

		case "seeing_Laura_Cotton":
			LAi_SetActorType(CharacterFromID("Laura Cotton"));
			LAi_ActorGoToLocator(CharacterFromID("Laura Cotton"), "Reload", "houseH3", "", 30.0);
			LAi_SetActorType(characterfromID("Killian Bencroft"));
			LAi_ActorFollow(characterFromID("Killian Bencroft"), characterFromID("Laura Cotton"), "", 60.0);			
			LAi_SetActorType(pchar);
            LAi_ActorTurnToCharacter(pchar, characterFromID("Laura Cotton"));
			LAi_QuestDelay("Laura_Cotton_House", 8.0);			
        break;

		case "Laura_Cotton_House":
            LAi_SetPlayerType(Pchar);	
            DoQuestReloadToLocation("Laura_Cotton_House", "reload", "reload1" ,"Laura_Cotton_House2");	
        break;

		case "Laura_Cotton_House2":
			ChangeCharacterAddressGroup(characterFromID("Jean Lafitte"), "Laura_Cotton_House", "goto", "goto2");
			ChangeCharacterAddressGroup(characterFromID("Laura Cotton"), "Laura_Cotton_House", "goto", "goto4");
			ChangeCharacterAddressGroup(characterFromID("Killian Bencroft"), "Laura_Cotton_House", "goto", "goto5");
			LAi_SetActorType(characterFromID("Killian Bencroft"));
			LAi_ActorSetLayMode(characterFromID("Killian Bencroft"));

			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_32";
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			LAi_ActorDialog(characterFromID("Jean Lafitte"), pchar, "", 2.0, 1.0);						
        break;

		case "Laura_Cotton_House3":
	        Characters[GetCharacterIndex("Laura Cotton")].dialog.currentnode = "begin_15";		
            LAi_SetActorType(characterFromID("Laura Cotton"));
			LAi_ActorDialog(characterFromID("Laura Cotton"), pchar, "", 2.0, 1.0);				
        break;

		case "Laura_Cotton_House4":
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_33";
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			LAi_ActorDialog(characterFromID("Jean Lafitte"), pchar, "", 2.0, 1.0);
        break;

		case "Laura_Cotton_House5":
	        Characters[GetCharacterIndex("Laura Cotton")].dialog.currentnode = "begin_16";		
            LAi_SetActorType(characterFromID("Laura Cotton"));
			LAi_ActorDialog(characterFromID("Laura Cotton"), pchar, "", 2.0, 1.0);				
        break;

		case "before_operation":
           DoQuestReloadToLocation("Turks_port", "goto", "goto35" ,"before_operation2");			
        break;

		case "before_operation2":
			ChangeCharacterAddressGroup(characterFromID("Jean Lafitte"), "Turks_port", "goto", "goto34");
			SetModelfromArray(&pchar, GetModelIndex("47_Blaze_brtlt"));
            PChar.DisableModelSelect = true;
            StoreOfficers(pchar.id);			
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_34";
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			LAi_ActorDialog(characterFromID("Jean Lafitte"), pchar, "", 2.0, 1.0);			
        break;

		case "boarding_warship":
           Locations[FindLocation("Quest_Deck1")].vcskip = true;		
           Locations[FindLocation("Quest_Deck2")].vcskip = true;					
		   Locations[FindLocation("Quest_ShipDeck6")].reload.l3.disable = 1;
		   Locations[FindLocation("Quest_Deck2")].reload.l3.disable = 1;		   
		   ChangeCharacterAddressGroup(characterFromID("Henri Caesar"), "Quest_Hold1", "rld", "prison4");	
		   LAi_SetPoorType(characterfromID("Henri Caesar"));
		   Characters[GetCharacterIndex("Henri Caesar")].dialog.currentnode = "begin_1";		   
           DoQuestReloadToLocation("Quest_ShipDeck6", "goto", "goto11" ,"_");
		break;

		case "fight_navy_soldiers":
			PlaySound("Ambient\Sea\bell8_0400_0800_1200.wav");
			LAi_group_FightGroups("BRITISH_NAVY_SOLDIERS", LAI_GROUP_PLAYER, true);			
			LAi_SetImmortal(Pchar, false);
			LAi_group_SetCheck("BRITISH_NAVY_SOLDIERS", "fight_navy_soldiers_over");
		break;
		
		case "fight_navy_soldiers_2":
			PlaySound("Ambient\Sea\bell8_0400_0800_1200.wav");
			LAi_group_FightGroups("BRITISH_NAVY_SOLDIERS", LAI_GROUP_PLAYER, true);
			LAi_group_FightGroups("BRITISH_NAVY_SOLDIERS_2", LAI_GROUP_PLAYER, true);
			LAi_group_FightGroups("BRITISH_NAVY_SOLDIERS_3", LAI_GROUP_PLAYER, true);			
			LAi_SetImmortal(Pchar, false);
			LAi_group_SetCheck("BRITISH_NAVY_SOLDIERS_3", "fight_navy_soldiers_over_2");
		break;		

		case "fight_navy_soldiers_over":
			Locations[FindLocation("Quest_ShipDeck6")].reload.l3.disable = 0;
			LAi_group_FightGroups("BRITISH_NAVY_SOLDIERS_2", LAI_GROUP_PLAYER, true);
			LAi_group_FightGroups("BRITISH_NAVY_SOLDIERS_3", LAI_GROUP_PLAYER, true);
			LAi_group_SetCheck("BRITISH_NAVY_SOLDIERS_3", "fight_navy_soldiers_over_2");			
			break;
			
		case "fight_navy_soldiers_over_2":
			Locations[FindLocation("Quest_Deck2")].reload.l3.disable = 0;	
		break;

		case "open_hold":
		    Locations[FindLocation("Quest_Deck2")].reload.l3.disable = 0;
			LAi_SetPatrolType(characterFromID("RN_soldier_6"));
		break;		

		case "plant_bomb":
		    Locations[FindLocation("Quest_ShipDeck6")].reload.l3.disable = 0;
			LAi_SetPatrolType(characterFromID("RN_soldier_1"));
		break;
		
		case "Caesar_stand_up":
			LAi_SetActorType(characterFromID("Henri Caesar"));		
			LAi_ActorAnimation(characterFromID("Henri Caesar"), "Ground_StandUp", "Caesar_stand_up2", 3.5);
		break;

		case "Caesar_stand_up2":
			LAi_SetActorType(characterFromID("Henri Caesar"));			
			Characters[GetCharacterIndex("Henri Caesar")].dialog.currentnode = "begin_6";
			LAi_ActorDialog(characterFromID("Henri Caesar"), pchar, "", 3.0, 1.0);	
		break;		
			
		case "endeavour_sinking_video":
			SetCharacterShipLocation(CharacterFromID("Nigel Chandler"), "none");
			
			GiveShip2Character(CharacterFromID("Laura Cotton"),"obj_soldier","Nothing",-1,ENGLAND,true,true);
			SetCharacterShipLocation(CharacterFromID("Laura Cotton"), "Turks_port");
			TakeItemFromCharacter(pchar, "time_bomb");					
			
			Locations[FindLocation("Turks_port")].models.always.general = "HMS_Endeavour";
			Locations[FindLocation("Turks_port")].models.always.general.locator.group = "ships_other";
			Locations[FindLocation("Turks_port")].models.always.general.locator.name = "ship1";			
			SetNextWeather("Clear");		
			PostVideoAndQuest("FreePlay\Endeavour",1, "seeing_endeavour_wreckage");		
		break;

		case "seeing_endeavour_wreckage":
			DoQuestReloadToLocation("Turks_port", "goto", "goto40" ,"seeing_endeavour_wreckage2");
		break;

		case "seeing_endeavour_wreckage2":
			ChangeCharacterAddressGroup(characterFromID("Jean Lafitte"), "Turks_port", "goto", "goto41");
			LAi_QuestDelay("seeing_endeavour_wreckage3", 6.0);				
		break;

		case "seeing_endeavour_wreckage3":
			RestoreOfficers(pchar.id);			
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_38";
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			LAi_ActorDialog(characterFromID("Jean Lafitte"), pchar, "", 2.0, 1.0);			
		break;

		case "back_to_lighthouse":	
			DoQuestReloadToLocation("Turks_Lighthouse", "goto", "goto1" ,"back_to_lighthouse2");	
		break;

		case "back_to_lighthouse2":
			DeleteAttribute(PChar, "DisableModelSelect");
			SetModelfromArray(&pchar, GetModelIndex("Almeida"));
			
			ChangeCharacterAddressGroup(characterFromID("Henri Caesar"), "Turks_Lighthouse", "goto", "goto5");
			ChangeCharacterAddressGroup(characterFromID("Jean Lafitte"), "Turks_Lighthouse", "goto", "goto3");
			Characters[GetCharacterIndex("Henri Caesar")].dialog.currentnode = "begin_9";
			LAi_SetActorType(characterFromID("Henri Caesar"));
			LAi_ActorDialog(characterFromID("Henri Caesar"), pchar, "", 2.0, 1.0);		    
		break;

		case "return_to_eleuthera":
			SetCharacterShipLocation(CharacterFromID("Laura Cotton"), "none");
			ChangeRMRelation(pchar, ENGLAND, -20.0);			
			AddQuestRecord("French_Companion","4");		
			Locations[FindLocation("Turks_port")].models.always.locators = "Margarita_locators";
			DeleteAttribute(&Locations[FindLocation("Turks_port")],"models.always.general");
			
			AddPassenger(Pchar, characterFromID("Jean Lafitte"), 0);
			SetOfficersIndex(PChar, -1, GetCharacterIndex("Jean Lafitte"));			
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			LAi_SetOfficerType(characterFromID("Jean Lafitte"));
			
			LAi_SetActorType(characterFromID("Henri Caesar"));			
			LAi_ActorRunToLocation(characterFromID("Henri Caesar"), "goto", "goto2", "none", "", "", "", 8.0);				

			pchar.quest.goodbye_caesar.win_condition.l1 = "location";
			pchar.quest.goodbye_caesar.win_condition.l1.location = "Eleuthera_Port";
			pchar.quest.goodbye_caesar.win_condition = "return_to_eleuthera2";		
		break;

		case "return_to_eleuthera2":
			Characters[GetCharacterIndex("Cole Arkwright")].dialog.currentnode = "gov_27";				
			ChangeCharacterAddressGroup(characterFromID("Henri Caesar"), "Eleuthera_Port", "goto", "goto8");		
			Characters[GetCharacterIndex("Henri Caesar")].dialog.currentnode = "begin_12";
			LAi_SetActorType(characterFromID("Henri Caesar"));
			LAi_ActorDialog(characterFromID("Henri Caesar"), pchar, "", 3.0, 1.0);		    
		break;

		case "return_to_eleuthera3":
			LAi_SetActorType(characterFromID("Henri Caesar"));			
			LAi_ActorRunToLocation(characterFromID("Henri Caesar"), "goto", "goto7", "none", "", "", "", 5.0);	
		break;

		case "leave_governor_eleuthera":				
			DoQuestReloadToLocation("Eleuthera_Port", "goto", "goto3" ,"leave_governor_eleuthera2");				
		break;

		case "leave_governor_eleuthera2":				
			Characters[GetCharacterIndex("Jean Lafitte")].dialog.currentnode = "begin_39";			
			LAi_SetActorType(characterFromID("Jean Lafitte"));
			LAi_ActorDialog(characterFromID("Jean Lafitte"), pchar, "", 4.0, 1.0);					
		break;

		case "goodbye_lafitte":	
			AddQuestRecord("French_Companion","5");
			CloseQuestHeader("French_Companion");			
			LAi_SetActorType(characterFromID("Jean Lafitte"));			
			LAi_ActorRunToLocation(characterFromID("Jean Lafitte"), "reload", "reload3_back", "none", "", "", "", 5.0);	
		break;

///////////////////////////////////////////////////////////////
//// Purpure: Purpure Longstride & GR
///////////////////////////////////////////////////////////////

		case "Purpure_arrest_check":
			if(sti(PChar.rank) >= 8 && !CheckAttribute(PChar, "quest.generate_trade_quest_progress"))
			{
				DeleteEnterLocationQuest("Charlestown_port", "Purpure_arrest_check");
				DeleteEnterLocationQuest("QC_port", "Purpure_arrest_check");
				DeleteEnterLocationQuest("QC_Shore1", "Purpure_arrest_check");
				LAi_QuestDelay("Purpure_arrest", 0.1);
			}
		break;

		case "Purpure_arrest":
			PlaceCharacter(CharacterFromID("Lucretia"), "goto");
			LAi_QuestDelay("Purpure_arrest2", 0.1);
		//	NPChar = CharacterfromID("Gillian Speedy");
		//	if (GetCharacterShipClass(PChar) < GetCharacterShipClass(NPChar)) GiveShip2Character(NPChar, "RN_FirstRate", "Hera", -1, ENGLAND, true, true);
		break;

		case "Purpure_arrest2":
			StartQuestMovie(true, false, false); TrackQuestMovie("start","Purpure_arrest");
			DisableFastTravel(true);
			LAi_LocationFightDisable(&Locations[FindLocation(PChar.location)], true);
			NPChar = CharacterFromID("Lucretia");
			NPChar.Dialog.CurrentNode = "Bad_Purpure";
			LAi_SetActorType(NPChar);
			LAi_ActorDialog(NPChar, PChar, "Purpure_to_prison", 25.0, 25.0);
		break;

		case "Purpure_to_prison":
			LAi_LocationFightDisable(&Locations[FindLocation(PChar.location)], false);
			StorePassengers(PChar.id);
           		Locations[FindLocation("Charlestown_prison")].vcskip = true;
			DoQuestReloadToLocation("Charlestown_prison", "goto", "goto24", "Purpure_in_prison");
		break;

		case "Purpure_in_prison":
			SetQuestHeader("Purpure_escape");
			AddQuestRecord("Purpure_escape", 1);
			if(CheckAttribute(PChar, "land"))
			{
				makearef(PChar_land, PChar.land);
				makearef(PChar_quest_land, PChar.quest.purpure.land);
				CopyAttributes(PChar_quest_land, PChar_land);
			}
			PChar.quest.purpure.old_england_relation = GetRMRelation(PChar, ENGLAND);
			PChar.quest.purpure.old_england_rank = GetRank(PChar, ENGLAND);
			if(CheckAttribute(PChar, "knighted"))
			{
				PChar.quest.purpure.old_knighted = PChar.knighted;
				PChar.quest.purpure.old_title = PChar.title;
			}

			LeaveService(PChar, ENGLAND, true);
			PChar.quest.purpure.old_shipname = GetMyShipName(PChar);
			ExchangeCharacterShip(PChar, CharacterFromID("Thomas Modiford"));	// Governor of Charlestown takes your ship. You might get it back later.
			LAi_QuestDelay("Purpure_in_prison_wait", 5.0);
		break;

		case "Purpure_in_prison_wait":
			LAi_Fade("Purpure_in_prison_next_morning", "Purpure_in_prison_interrogation");
		break;

		case "Purpure_in_prison_next_morning":
			WaitDate("", 0,0,1,0,0);
			SetCurrentTime(9, rand(59));
		break;

		case "Purpure_in_prison_next_night":
			WaitDate("", 0,0,1,0,0);
			SetCurrentTime(22, rand(59));
		break;

		case "Purpure_in_prison_interrogation":
			NPChar = CharacterFromID("Gillian Speedy");
			LAi_SetLoginTime(NPChar, 0.0, 24.0);
			ChangeCharacterAddressGroup(NPChar, "Charlestown_prison", "goto", "goto21");
			LAi_SetActorType(NPChar);
			LAi_ActorGoToLocator(NPChar, "reload", "reload12", "Purpure_in_prison_interrogation2", 30.0);
		break;

		case "Purpure_in_prison_interrogation2":
			NPChar = CharacterFromID("Gillian Speedy");
			LAi_SetActorType(NPChar);
			LAi_ActorTurnToCharacter(NPChar, (PChar));
			NPChar.dialog.CurrentNode = "Interrogation";
			LAi_ActorDialogNow(NPChar, PChar, "Purpure_after_interrogation", 1.0);
		break;

		case "Purpure_after_interrogation":
			AddQuestRecord("Purpure_escape", 2);
			NPChar = CharacterFromID("Gillian Speedy");
			LAi_SetActorType(NPChar);
			LAi_ActorGoToLocator(NPChar, "goto", "goto21", "Purpure_in_prison_wait2", 30.0);
		break;

		case "Purpure_in_prison_wait2":
			LAi_Fade("Purpure_in_prison_next_night", "Purpure_in_prison_rescue");
		break;

		case "Purpure_in_prison_rescue":
			ChangeCharacterAddressGroup(CharacterFromID("Gillian Speedy"), "none", "", "");
			NPChar = CharacterFromID("Simon");
			LAi_SetLoginTime(NPChar, 0.0, 24.0);
			ChangeCharacterAddressGroup(NPChar, "Charlestown_prison", "goto", "goto21");
			LAi_SetImmortal(NPChar, true);		// Make sure Simon survives walk to Pirate Settlement
			LAi_SetActorType(NPChar);
			LAi_ActorGoToLocator(NPChar, "reload", "reload12", "Purpure_in_prison_rescue2", 30.0);
		break;

		case "Purpure_in_prison_rescue2":
			NPChar = CharacterFromID("Simon");
			LAi_SetActorType(NPChar);
			LAi_ActorTurnToCharacter(NPChar, (PChar));
			StoreDialog(NPChar);
			NPChar.dialog.Filename = "Purpure_officers_dialog.c";
			NPChar.dialog.CurrentNode = "Jailbreak";
			LAi_ActorDialogNow(NPChar, PChar, "Purpure_in_prison_rescue3", 1.0);
		break;

		case "Purpure_in_prison_rescue3":
			PlaySound("PEOPLE\lockpick2.wav");
			LAi_QuestDelay("Purpure_in_prison_rescue4", 1.0);
		break;

		case "Purpure_in_prison_rescue4":
			ChangeCharacterAddressGroup(CharacterFromID("Simon"), "Charlestown_prison", "goto", "goto23");
			DoQuestReloadToLocation("Charlestown_prison", "reload", "reload12", "Purpure_in_prison_rescue5");
		break;

		case "Purpure_in_prison_rescue5":
			EndQuestMovie();TrackQuestMovie("end","Purpure_in_prison_rescue5");
			DeleteAttribute(&Locations[FindLocation("Charlestown_prison")],"vcskip");
           		Locations[FindLocation("Charlestown_port")].vcskip = true;
			AddQuestRecord("Purpure_escape", 3);

			NPChar = CharacterFromID("Simon");
			LAi_SetActorType(NPChar);
			LAi_ActorGoToLocator(NPChar, "reload", "reload1", "", 30.0);

			PChar.quest.Purpure_Simon_to_port.win_condition.l1 = "location";
			PChar.quest.Purpure_Simon_to_port.win_condition.l1.location = "Charlestown_Guardhouse";
			PChar.quest.Purpure_Simon_to_port.win_condition = "Purpure_Simon_to_port";
		break;

		case "Purpure_Simon_to_port":
			NPChar = CharacterFromID("Simon");
			ChangeCharacterAddressGroup(NPChar, "Charlestown_Guardhouse", "goto", "goto4");
			LAi_SetActorType(NPChar); LAi_type_Actor_Reset(NPChar);
			LAi_ActorGoToLocator(NPChar, "reload", "reload2", "", 10.0);

			PChar.quest.Purpure_Simon_to_QC_Jungle_03.win_condition.l1 = "location";
			PChar.quest.Purpure_Simon_to_QC_Jungle_03.win_condition.l1.location = "Charlestown_port";
			PChar.quest.Purpure_Simon_to_QC_Jungle_03.win_condition = "Purpure_Simon_to_QC_Jungle_03";

			PChar.quest.trap_no_follow = "true";
			LAi_QuestDelay("Purpure_prepare_trap", 0.1);
		break;

		case "Purpure_Simon_to_QC_Jungle_03":
			DeleteQuestAttribute("trap_no_follow");
			DeleteAttribute(&Locations[FindLocation("Charlestown_port")],"vcskip");
           		Locations[FindLocation("QC_Jungle_03")].vcskip = true;
			LAi_LocationFightDisable(&Locations[FindLocation("Charlestown_port")], true);

			NPChar = CharacterFromID("Simon");
			LAi_SetActorType(NPChar); LAi_type_Actor_Reset(NPChar);
			ChangeCharacterAddressGroup(NPChar, "Charlestown_port", "officers", "houseS2_1");
			LAi_ActorRunToLocator(NPChar, "reload", "gate", "", 20.0);

			PChar.quest.Purpure_Simon_to_QC_Jungle_2.win_condition.l1 = "location";
			PChar.quest.Purpure_Simon_to_QC_Jungle_2.win_condition.l1.location = "QC_Jungle_03";
			PChar.quest.Purpure_Simon_to_QC_Jungle_2.win_condition = "Purpure_Simon_to_QC_Jungle_2";

			LAi_QuestDelay("Purpure_prepare_trap", 0.1);
		break;

		case "Purpure_Simon_to_QC_Jungle_2":
			DeleteAttribute(&Locations[FindLocation("QC_Jungle_03")],"vcskip");
           		Locations[FindLocation("QC_Jungle_2")].vcskip = true;
			LAi_LocationFightDisable(&Locations[FindLocation("Charlestown_port")], false);
			LAi_LocationFightDisable(&Locations[FindLocation("QC_Jungle_03")], true);
			AddQuestRecord("Purpure_escape", 4);

			NPChar = CharacterFromID("Simon");
			ChangeCharacterAddressGroup(NPChar, "QC_Jungle_03", "officers", "reload1_3");
			LAi_SetActorType(NPChar); LAi_type_Actor_Reset(NPChar);
			LAi_ActorRunToLocator(NPChar, "reload", "reload2_back", "", 30.0);

			PChar.quest.Purpure_Simon_to_QC_jungle_04.win_condition.l1 = "location";
			PChar.quest.Purpure_Simon_to_QC_jungle_04.win_condition.l1.location = "QC_Jungle_2";
			PChar.quest.Purpure_Simon_to_QC_jungle_04.win_condition = "Purpure_Simon_to_QC_jungle_04";

			LAi_QuestDelay("Purpure_prepare_trap", 0.1);
		break;

		case "Purpure_Simon_to_QC_jungle_04":
			DeleteAttribute(&Locations[FindLocation("QC_Jungle_2")],"vcskip");
           		Locations[FindLocation("QC_Jungle_04")].vcskip = true;
			LAi_LocationFightDisable(&Locations[FindLocation("QC_Jungle_03")], false);
			LAi_LocationFightDisable(&Locations[FindLocation("QC_Jungle_2")], true);

			NPChar = CharacterFromID("Simon");
			ChangeCharacterAddressGroup(NPChar, "QC_Jungle_2", "officers", "reload1_1");
			LAi_SetActorType(NPChar); LAi_type_Actor_Reset(NPChar);
			LAi_ActorRunToLocator(NPChar, "reload", "reload3_back", "", 30.0);

			PChar.quest.Purpure_Simon_to_QC_town_exit.win_condition.l1 = "location";
			PChar.quest.Purpure_Simon_to_QC_town_exit.win_condition.l1.location = "QC_Jungle_04";
			PChar.quest.Purpure_Simon_to_QC_town_exit.win_condition = "Purpure_Simon_to_QC_town_exit";

			LAi_QuestDelay("Purpure_prepare_trap", 0.1);
		break;

		case "Purpure_Simon_to_QC_town_exit":
			DeleteAttribute(&Locations[FindLocation("QC_Jungle_04")],"vcskip");
			LAi_LocationFightDisable(&Locations[FindLocation("QC_Jungle_2")], false);
			LAi_LocationFightDisable(&Locations[FindLocation("QC_Jungle_04")], true);

			NPChar = CharacterFromID("Simon");
			ChangeCharacterAddressGroup(NPChar, "QC_Jungle_04", "officers", "reload2_1");
			LAi_SetActorType(NPChar); LAi_type_Actor_Reset(NPChar);
			LAi_ActorRunToLocator(NPChar, "reload", "reload1_back", "", 30.0);

			PChar.quest.Purpure_Simon_arrived_outskirts.win_condition.l1 = "location";
			PChar.quest.Purpure_Simon_arrived_outskirts.win_condition.l1.location = "QC_town_exit";
			PChar.quest.Purpure_Simon_arrived_outskirts.win_condition = "Purpure_Simon_arrived_outskirts";

		//	PChar.quest.trap_no_follow = "true";
			LAi_QuestDelay("Purpure_prepare_trap", 0.1);
		break;

		case "Purpure_Simon_arrived_outskirts":
			LAi_LocationFightDisable(&Locations[FindLocation("QC_Jungle_04")], false);
			LAi_LocationFightDisable(&Locations[FindLocation("QC_town_exit")], true);
			GiveShip2Character(PChar, "US_Interceptor", "Lotus", -1, PIRATE, true, true);
			SetCharacterShipLocation(PChar, "QC_port");
			RestorePassengers(PChar.ID);

			NPChar = CharacterFromID("Simon");
			ChangeCharacterAddressGroup(NPChar, "QC_town_exit", "officers", "reload3_1");
			NPChar.Dialog.CurrentNode = "arrived_at_QC_exit";
			LAi_SetActorType(NPChar); LAi_type_Actor_Reset(NPChar);
			LAi_ActorDialog(NPChar, PChar, "Purpure_Simon_to_QC_port", 10.0, 10.0);
		break;

		case "Purpure_Simon_to_QC_port":
			LAi_LocationFightDisable(&Locations[FindLocation("QC_town_exit")], false);
			NPChar = CharacterFromID("Simon");
			LAi_SetActorType(NPChar);
			LAi_ActorGoToLocator(NPChar, "reload", "reload2_back", "", 45.0);

			PChar.quest.Purpure_Simon_arrived_port.win_condition.l1 = "location";
			PChar.quest.Purpure_Simon_arrived_port.win_condition.l1.location = "QC_port";
			PChar.quest.Purpure_Simon_arrived_port.win_condition = "Purpure_Simon_arrived_port";
		break;

		case "Purpure_Simon_arrived_port":
			PChar.quest.Purpure_trap.over = "yes";
			DeleteQuestAttribute("purpure.old_location");
			DeleteQuestAttribute("trap_no_follow");
			DisableFastTravel(false);
			SafePortLeave(ENGLAND, false);
			AddQuestRecord("Purpure_escape", 5);
			CloseQuestHeader("Purpure_escape");
			sld = CharacterFromID("Lucretia");
			LAi_SetActorType(sld); LAi_type_Actor_Reset(sld);
			ChangeCharacterAddressGroup(sld, "none", "", "");

			NPChar = CharacterFromID("Simon");
			ChangeCharacterAddressGroup(NPChar, "QC_port", "officers", "reload3_1");
			LAi_SetOfficerType(NPChar);
			SetOfficersIndex(PChar, -1, GetCharacterIndex("Simon"));
			AddPassenger(PChar, NPChar, 0);
			LAi_SetImmortal(NPChar, false);
			NPChar.dialog.Filename = "Enc_Officer_dialog.c";
			NPChar.dialog.CurrentNode = "hired";
			SetOfficersIndex(PChar, -1, GetCharacterIndex("Edgar"));
			AddPassenger(PChar, CharacterFromID("Edgar"), 0);
			LAi_QuestDelay("Purpure_place_Margaret_Wilda", 0.1);
		break;

		case "Purpure_place_Margaret_Wilda":
			ChangeCharacterAddressGroup(CharacterFromID("Wilda"), "new_cloister_garden", "goto", "goto6");
			ChangeCharacterAddressGroup(CharacterFromID("Margaret Jocasta"), "Cartagena_tavern", "sit", "sit25");
			LAi_SetSitType(CharacterFromID("Margaret Jocasta"));
			SetRumourState("Margaret_Jocasta_start", true);
		break;

		case "Purpure_prepare_trap":
			PChar.quest.purpure.old_location = PChar.location;
			PChar.quest.Purpure_set_trap.win_condition.l1 = "ExitFromLocation";
			PChar.quest.Purpure_set_trap.win_condition.l1.location = PChar.location;
			PChar.quest.Purpure_set_trap.win_condition = "Purpure_set_trap";
			if (!CheckAttribute(PChar, "quest.trap_no_follow")) LAi_QuestDelay("Purpure_Lucretia_follows", 10.0);
		break;

		case "Purpure_Lucretia_follows":
			NPChar = CharacterFromID("Lucretia");
			ChangeCharacterAddressGroup(NPChar, PChar.location, PChar.location.group, PChar.location.locator);
			LAi_SetActorType(NPChar); LAi_type_Actor_Reset(NPChar);
			NPChar.Dialog.CurrentNode = "Caught_you";
			LAi_ActorDialog(NPChar, PChar, "Purpure_return_to_prison", 60.0, 60.0);
		break;

		case "Purpure_set_trap":	// If you're stupid enough to go back a step instead of following Simon
			PChar.quest.Purpure_trap.win_condition.l1 = "location";
			PChar.quest.Purpure_trap.win_condition.l1.location = PChar.quest.purpure.old_location;
			PChar.quest.Purpure_trap.win_condition = "Purpure_trap";
		break;

		case "Purpure_trap":
			DisableFastTravel(true);
			StartQuestMovie(true, false, false); TrackQuestMovie("start","Purpure_trap");
			PlaceCharacter(CharacterFromID("Lucretia"), "goto");
			LAi_QuestDelay("Purpure_trap_arrest", 0.1);
		break;

		case "Purpure_trap_arrest":
			LAi_LocationFightDisable(&Locations[FindLocation(PChar.location)], true);
			NPChar = CharacterFromID("Lucretia");
			NPChar.Dialog.CurrentNode = "Caught_you";
			LAi_SetActorType(NPChar);
			LAi_ActorDialog(NPChar, PChar, "Purpure_return_to_prison", 25.0, 25.0);
		break;

		case "Purpure_return_to_prison":
			ChangeCharacterAddressGroup(CharacterFromID("Simon"), "Charlestown_prison", "goto", "goto9");
           		Locations[FindLocation("Charlestown_prison")].vcskip = true;
			DoQuestReloadToLocation("Charlestown_prison", "goto", "goto24", "Purpure_final_talk");
		break;

		case "Purpure_final_talk":
			AddQuestRecord("Purpure_escape", 6);
			NPChar = CharacterFromID("Simon");
			NPChar.Dialog.CurrentNode = "back_in_prison";
			LAi_SetActorType(NPChar);
			LAi_ActorDialog(NPChar, PChar, "Purpure_in_prison_selfdialog", 5.0, 25.0);
		break;

		case "Purpure_in_prison_selfdialog":
			LAi_QuestDelay("Purpure_in_prison_selfdialog2", 0.1);
		break;

		case "Purpure_in_prison_selfdialog2":
			PChar.dialog.filename = "Purpure_officers_dialog.c";
			Pchar.dialog.currentnode = "end_in_prison";
			LAi_SetActorType(PChar);
			LAi_ActorSelfDialog(Pchar, "player_back");
		break;

		case "Purpure_duel_prepare_trigger":	// Triggered by dialog with Margaret Jocasta
			PChar.quest.Purpure_duel_trigger.win_condition.l1 = "ExitFromLocation";
			PChar.quest.Purpure_duel_trigger.win_condition.l1.location = PChar.location;
			PChar.quest.Purpure_duel_trigger.win_condition = "Purpure_duel_trigger";

			// Margaret told you she would only wait seven days.  Time's up.
			PChar.quest.Purpure_duel_too_late.win_condition.l1 = "Timer";
			PChar.quest.Purpure_duel_too_late.win_condition.l1.date.day = GetAddingDataDay(0, 0, 8);
			PChar.quest.Purpure_duel_too_late.win_condition.l1.date.month = GetAddingDataMonth(0, 0, 8);
			PChar.quest.Purpure_duel_too_late.win_condition.l1.date.year = GetAddingDataYear(0, 0, 8);
			PChar.quest.Purpure_duel_too_late.win_condition = "Purpure_duel_too_late";

			SetRumourState("Margaret_Jocasta_start", false);	// Cancel rumour about Margaret waiting for someone
			SetQuestHeader("Purpure_duel");
			AddQuestRecord("Purpure_duel", 1);

			NPChar = CharacterFromID("Margaret Jocasta");		// Upgrade Margaret to an expert fighter - has to be done here because levelling messed up her skills and perks earlier
			if (GetDifficulty() >= DIFFICULTY_MARINER)
			{
				NPChar.rank = 9;
				NPChar.experience = CalculateExperienceFromRank(9) + (CalculateExperienceFromRank(5)/10 + rand(500));
				NPChar.skill.Fencing = "8";
				NPChar.perks.list.Toughness = true;
			}
			else							// But tone her down a bit for novice players
			{
				NPChar.rank = 7;
				NPChar.experience = CalculateExperienceFromRank(7) + (CalculateExperienceFromRank(5)/10 + rand(500));
				NPChar.skill.Fencing = "6";
			}
			NPChar.perks.list.BasicDefence = true;
			NPChar.perks.list.AdvancedDefence = true;
			NPChar.perks.list.CriticalHit = true;
			NPChar.perks.list.SwordplayProfessional = true;
			ResetEffectiveSkillAll(NPChar);
			ResetHP(NPChar);
		break;

		case "Purpure_duel_trigger":
			DisableFastTravel(true);
			ChangeCharacterAddressGroup(CharacterFromID("Margaret Jocasta"), "none", "", "");
           		Locations[FindLocation("Cartagena_Exit")].vcskip = true;
			PChar.quest.Purpure_arrived_for_duel.win_condition.l1 = "location";
			PChar.quest.Purpure_arrived_for_duel.win_condition.l1.location = "Cartagena_Exit";
			PChar.quest.Purpure_arrived_for_duel.win_condition = "Purpure_arrived_for_duel";
		break;

		case "Purpure_arrived_for_duel":
			if (IsDay())
			{
				PChar.quest.Purpure_duel_too_late.over = "yes";
				LAi_LocationFightDisable(&Locations[FindLocation("Cartagena_Exit")], true);

				// Spectators
				if (Characters[GetCharacterIndex("Wilda")].Dialog.Filename != "Enc_Officer_dialog.c")
				{
					ChangeCharacterAddressGroup(CharacterFromID("Wilda"), "Cartagena_Exit", "goto", "goto47");
					LAi_SetActorType(CharacterFromID("Wilda")); LAi_type_Actor_Reset(CharacterFromID("Wilda"));
					LAi_ActorTurnToLocator(CharacterFromID("Wilda"), "goto", "goto43");
				}
				ChangeCharacterAddressGroup(CharacterFromID("Jose Puablo"), "Cartagena_Exit", "goto", "goto48");
				ChangeCharacterAddressGroup(CharacterFromID("Diego Martinez"), "Cartagena_Exit", "goto", "goto49");
				ChangeCharacterAddressGroup(CharacterFromID("Raquel Torres"), "Cartagena_Exit", "goto", "goto20");
				ChangeCharacterAddressGroup(CharacterFromID("Quirino Mendoza"), "Cartagena_Exit", "goto", "goto21");
				LAi_SetActorType(CharacterFromID("Jose Puablo")); LAi_type_Actor_Reset(CharacterFromID("Jose Puablo"));
				LAi_ActorTurnToCharacter(CharacterFromID("Jose Puablo"), CharacterFromID("Diego Martinez"));
				LAi_SetActorType(CharacterFromID("Diego Martinez")); LAi_type_Actor_Reset(CharacterFromID("Diego Martinez"));
				LAi_ActorTurnToCharacter(CharacterFromID("Diego Martinez"), CharacterFromID("Jose Puablo"));
				LAi_SetActorType(CharacterFromID("Raquel Torres")); LAi_type_Actor_Reset(CharacterFromID("Raquel Torres"));
				LAi_ActorTurnToCharacter(CharacterFromID("Raquel Torres"), CharacterFromID("Quirino Mendoza"));
				LAi_SetActorType(CharacterFromID("Quirino Mendoza")); LAi_type_Actor_Reset(CharacterFromID("Quirino Mendoza"));
				LAi_ActorTurnToCharacter(CharacterFromID("Quirino Mendoza"), CharacterFromID("Raquel Torres"));

				NPChar = CharacterFromID("Margaret Jocasta");
				ChangeCharacterAddressGroup(NPChar, "Cartagena_Exit", "goto", "goto43");
				LAi_SetActorType(NPChar);
				LAi_ActorTurnToCharacter(NPChar, PChar);
				LAi_SetStayType(NPChar);
				string my_armour = GetCharacterEquipByGroup(PChar, ARMOR_ITEM_TYPE);
				if (my_armour != "")
				{
					GiveItem2Character(NPChar, my_armour);
					EquipCharacterByItem(NPChar, my_armour);
				}
				NPChar.Dialog.CurrentNode = "Margaret_begin_duel";

				// You came, you saw, you ran away.
				PChar.quest.Purpure_duel_ran_away.win_condition.l1 = "ExitFromLocation";
				PChar.quest.Purpure_duel_ran_away.win_condition.l1.location = PChar.location;
				PChar.quest.Purpure_duel_ran_away.win_condition = "Purpure_duel_ran_away";
			}
			else LAi_QuestDelay("Purpure_duel_prepare_trigger", 0.1);
		break;

		case "Purpure_fight_duel":	// triggered by dialog with Margaret Jocasta
			NPChar = CharacterFromID("Margaret Jocasta");
			PChar.quest.old_blade = GetCharacterEquipByGroup(PChar, BLADE_ITEM_TYPE);
			NPChar.quest.old_blade = GetCharacterEquipByGroup(NPChar, BLADE_ITEM_TYPE);
			LAi_LocationFightDisable(&Locations[FindLocation("Cartagena_Exit")], false);

			LAi_ActorTurnToCharacter(CharacterFromID("Jose Puablo"), NPChar);
			LAi_ActorTurnToCharacter(CharacterFromID("Diego Martinez"), PChar);
			LAi_ActorTurnToCharacter(CharacterFromID("Raquel Torres"), NPChar);
			LAi_ActorTurnToCharacter(CharacterFromID("Quirino Mendoza"), PChar);

			if (LAi_IsImmortal(PChar) && GetDifficulty() >= DIFFICULTY_MARINER)	// Immortal, are you?
			{
				PChar.quest.Purpure_was_immortal = true;
				LAi_SetImmortal(PChar, false);					// Not any more! :p
			}

			string have_rapier = "";
			if (HasSubstr(GetCharacterEquipByGroup(NPChar, BLADE_ITEM_TYPE), "blade13")) TakeItemFromCharacter(NPChar, GetCharacterEquipByGroup(NPChar, BLADE_ITEM_TYPE));	// If Margaret is holding any version of duelling rapier, remove and refresh it
			if(ENABLE_WEAPONSMOD)
			{
				if (!CheckCharacterItem(NPChar, "blade13+3")) GiveItem2Character(NPChar, "blade13+3");
				EquipCharacterByItem(NPChar, "blade13+3");
				for (i=-2; i<=3; i++)
				{
					attr = "blade13";
					if (i>0) attr = attr + "+";
					if (i!=0) attr = attr + i;
					if (CheckCharacterItem(PChar, attr)) have_rapier = attr;
				}
				if (have_rapier == "" || !CheckAttribute(PChar, "quest.Purpure_rapier_given"))
				{
					GiveItem2Character(PChar, "blade13+3");
					have_rapier = "blade13+3";
				}
				EquipCharacterByItem(PChar, have_rapier);
			}
			else
			{
				if (!CheckCharacterItem(NPChar, "blade13")) GiveItem2Character(NPChar, "blade13");
				EquipCharacterByItem(NPChar, "blade13");
				if (!CheckCharacterItem(PChar, "blade13") || !CheckAttribute(PChar, "quest.Purpure_rapier_given")) GiveItem2Character(PChar, "blade13");
				EquipCharacterByItem(PChar, "blade13");
			}
			PChar.quest.Purpure_rapier_given = true;
			EnableEquip(PChar, BLADE_ITEM_TYPE, false);
			LAi_SetFightMode(PChar, true);
			LAi_SetActorType(NPChar);
			LAi_ActorAttack(NPChar, PChar, "");
			LAi_SetCheckMinHP(NPChar, LAi_GetCharacterMaxHP(NPChar)*0.5, false, "Purpure_duel_won");
			LAi_SetCheckMinHP(PChar, LAi_GetCharacterMaxHP(PChar)*0.5, false, "Purpure_duel_lost");
		break;

		case "Purpure_duel_won":
			LAi_QuestDelay("Purpure_after_duel", 0.1);
			NPChar = CharacterFromID("Margaret Jocasta");
			LAi_RemoveCheckMinHP(PChar);
			LAi_RemoveCheckMinHP(NPChar);
			if (!LAi_IsDead(NPChar))
			{
				LAi_SetActorType(NPChar);
				NPChar.Dialog.CurrentNode = "Margaret_duel_won";
				LAi_QuestDelay("Purpure_Margaret_after_duel", 0.3);
			}
		break;

		case "Purpure_duel_lost":
			LAi_QuestDelay("Purpure_after_duel", 0.1);
			NPChar = CharacterFromID("Margaret Jocasta");
			LAi_RemoveCheckMinHP(PChar);
			LAi_RemoveCheckMinHP(NPChar);
			if (!LAi_IsDead(NPChar))
			{
				LAi_SetActorType(NPChar);
				NPChar.Dialog.CurrentNode = "Margaret_duel_lost";
				LAi_QuestDelay("Purpure_Margaret_after_duel", 0.3);
			}
		break;

		case "Purpure_Margaret_after_duel":					// Prevent dialog disappearing due to player pressing "Attack" button during duel
			DisableFastTravel(false);
			NPChar = CharacterFromID("Margaret Jocasta");
			LAi_SetActorType(PChar);
			LAi_ActorWaitDialog(PChar, NPChar);
			LAi_ActorDialog(NPChar, PChar, "", 5.0, 5.0);
		break;

		case "Purpure_Margaret_leaves_after_duel":				// Triggered by dialog with Margaret Jocasta after you lose duel
			AddQuestRecord("Purpure_duel", 4);
			NPChar = CharacterFromID("Margaret Jocasta");
			LAi_SetPlayerType(PChar);
			LAi_SetActorType(NPChar);
			LAi_ActorGoToLocation(NPChar, "reload", "reload2", "none", "", "", "", -1);
			PChar.quest.Purpure_Margaret_to_tavern.win_condition.l1 = "ExitFromLocation";
			PChar.quest.Purpure_Margaret_to_tavern.win_condition.l1.location = PChar.location;
			PChar.quest.Purpure_Margaret_to_tavern.win_condition = "Purpure_Margaret_to_tavern";
		break;

		case "Purpure_Margaret_to_tavern":
			NPChar = CharacterFromID("Margaret Jocasta");
			ChangeCharacterAddressGroup(NPChar, "Cartagena_tavern", "sit", "sit25");
			LAi_SetSitType(NPChar);
			NPChar.Dialog.CurrentNode = "Margaret_try_again";
		break;

		case "Purpure_Margaret_joins":					// Triggered by dialog with Margaret Jocasta after you win duel
			NPChar = CharacterFromID("Margaret Jocasta");
			LAi_SetPlayerType(PChar);
			LAi_SetActorType(NPChar);
			LAi_ActorRunToLocation(NPChar, "reload", "reload2", "none", "", "", "", -1);
			PChar.quest.Purpure_Margaret_joins2.win_condition.l1 = "ExitFromLocation";
			PChar.quest.Purpure_Margaret_joins2.win_condition.l1.location = PChar.location;
			PChar.quest.Purpure_Margaret_joins2.win_condition = "Purpure_Margaret_joins2";
		break;

		case "Purpure_Margaret_joins2":
			NPChar = CharacterFromID("Margaret Jocasta");
			PlaceCharacter(NPChar, "goto");
			LAi_SetOfficerType(NPChar);
			cidx = GetCharacterIndex("Margaret Jocasta");
			if (SetOfficersIndex(PChar, -1, cidx) == cidx)		// Try to put Margaret into a free slot.  If none free...
			{
				iPassenger = -1;
				for(i=1; i<OFFICER_MAX; i++)			// ... try to find an officer who is not marked unremovable and is not Lizzie...
				{
					cc = GetOfficersIndex(PChar, i);
					if (cc < 1 || cc >= TOTAL_CHARACTERS) continue;
					sld = GetCharacter(cc);
					if (GetAttribute(sld, "id") != "Lizzie" && GetRemovable(sld)) iPassenger = i;
				}
				if (iPassenger != -1) SetOfficersIndex(PChar, iPassenger, cidx);
			}							// ... and Margaret will displace that officer
			AddPassenger(PChar, NPChar, 0);
			NPChar.Dialog.Filename = "Enc_Officer_dialog.c";
			NPChar.Dialog.CurrentNode = "hired";
			AddQuestRecord("Purpure_duel", 5);
			if (Characters[GetCharacterIndex("Wilda")].Dialog.Filename != "Enc_Officer_dialog.c") AddQuestRecord("Purpure_duel", 6);
			CloseQuestHeader("Purpure_duel");

			EnableEquip(PChar, BLADE_ITEM_TYPE, true);
			if (CheckAttribute(PChar, "quest.old_blade"))
			{
				EquipCharacterByItem(PChar,PChar.quest.old_blade);
				DeleteQuestAttribute("old_blade");
			}
			if (CheckAttribute(NPChar, "quest.old_blade"))
			{
				EquipCharacterByItem(NPChar,NPChar.quest.old_blade);
				DeleteAttribute(NPChar, "quest.old_blade");
			}
			DeleteQuestAttribute("Purpure_rapier_given");
		break;

		case "Purpure_duel_too_late":
			AddQuestRecord("Purpure_duel", 2);
			CloseQuestHeader("Purpure_duel");
			PChar.quest.Purpure_chicken = "too late";
			LAi_QuestDelay("Purpure_duel_chicken", 0.1);
		break;

		case "Purpure_duel_ran_away":
			AddQuestRecord("Purpure_duel", 3);
			CloseQuestHeader("Purpure_duel");
			EnableEquip(PChar, BLADE_ITEM_TYPE, true);
			if (CheckAttribute(PChar, "quest.old_blade"))
			{
				EquipCharacterByItem(PChar,PChar.quest.old_blade);
				DeleteQuestAttribute("old_blade");
			}
			PChar.quest.Purpure_chicken = "ran away";
			LAi_QuestDelay("Purpure_duel_chicken", 0.1);
		break;

		case "Purpure_duel_chicken":
			PChar.quest.Purpure_duel_ran_away.over = "yes";
			PChar.quest.Purpure_duel_too_late.over = "yes";
			DisableFastTravel(false);
			LAi_QuestDelay("Purpure_restore_citizens", 0.1);

			// Margaret and Wilda disappear.  If you already recruited Wilda, she deserts and if you gave her a ship, she takes it with her.
			Characters[GetCharacterIndex("Margaret Jocasta")].location = "none";
			NPChar = CharacterFromID("Wilda");
			NPChar.location = "none";
			if (IsPassenger(NPChar) || IsOfficer(NPChar))
			{
				RemovePassenger(PChar, NPChar);
			}
			if (IsCompanion(NPChar))
			{
				RemoveCharacterCompanion(PChar, NPChar);
			}

			i = makeint(makefloat(REPUTATION_NEUTRAL-GetCharacterReputation(PChar))*2.0/3.0);	// Move reputation towards neutral - whether you've been trying to cultivate a good or evil reputation, you just lost it.
			PChar.reputation = sti(PChar.reputation) + i;						// Don't use function 'ChangeCharacterReputation', it does other things which should not happen here
			LogIt(TranslateString("","CHANGE REP FOR PLAYER:") + " " + i);
			PChar.Ship.Crew.Morale = stf(PChar.Ship.Crew.Morale)/4;					// The crew don't like finding out that their captain is the chicken of the sea!
		break;

		case "Purpure_after_duel":
			PChar.quest.Purpure_duel_ran_away.over = "yes";
			DisableFastTravel(false);
			LAi_LocationFightDisable(&Locations[FindLocation("Cartagena_Exit")], true);
			if (CheckAttribute(PChar, "quest.Purpure_was_immortal"))				// If you were immortal before the duel,
			{
				LAi_SetImmortal(PChar, true);							// restore your immortality.
				DeleteQuestAttribute("Purpure_was_immortal");
			}

			LAi_SetActorType(CharacterFromID("Jose Puablo")); LAi_ActorGoToLocation(CharacterFromID("Jose Puablo"), "reload", "reload2", "none", "", "", "", -1);
			LAi_SetActorType(CharacterFromID("Diego Martinez")); LAi_ActorGoToLocation(CharacterFromID("Diego Martinez"), "reload", "reload2", "none", "", "", "", -1);
			LAi_SetActorType(CharacterFromID("Raquel Torres")); LAi_ActorGoToLocation(CharacterFromID("Raquel Torres"), "reload", "reload2", "none", "", "", "", -1);
			LAi_SetActorType(CharacterFromID("Quirino Mendoza")); LAi_ActorGoToLocation(CharacterFromID("Quirino Mendoza"), "reload", "reload2", "none", "", "", "", -1);
			if (Characters[GetCharacterIndex("Wilda")].Dialog.Filename != "Enc_Officer_dialog.c")
			{
				LAi_SetActorType(CharacterFromID("Wilda")); LAi_ActorRunToLocation(CharacterFromID("Wilda"), "reload", "reload2", "none", "", "", "", 20);
			}

			PChar.quest.Purpure_restore_citizens.win_condition.l1 = "ExitFromLocation";
			PChar.quest.Purpure_restore_citizens.win_condition.l1.location = PChar.location;
			PChar.quest.Purpure_restore_citizens.win_condition = "Purpure_restore_citizens";
		break;

		case "Purpure_restore_citizens":
			if (!CheckAttribute(PChar, "quest.Purpure_chicken") && Characters[GetCharacterIndex("Wilda")].Dialog.Filename != "Enc_Officer_dialog.c")	// If you chickened out of the duel, Wilda should disappear.  Don't put her back.
			{
				ChangeCharacterAddressGroup(CharacterFromID("Wilda"), "new_cloister_garden", "goto", "goto6");
    				LAi_SetCitizenType(CharacterFromID("Wilda"));
			}
			ChangeCharacterAddressGroup(CharacterFromID("Jose Puablo"), "Cartagena_Port", "goto", "goto4");
    			LAi_SetCitizenType(CharacterFromID("Jose Puablo"));
			ChangeCharacterAddressGroup(CharacterFromID("Diego Martinez"), "Cartagena_Port", "goto", "goto1");
    			LAi_SetCitizenType(CharacterFromID("Diego Martinez"));
			ChangeCharacterAddressGroup(CharacterFromID("Raquel Torres"), "Cartagena_town_01", "goto", "goto20");
    			LAi_SetCitizenType(CharacterFromID("Raquel Torres"));
			ChangeCharacterAddressGroup(CharacterFromID("Quirino Mendoza"), "Cartagena_town_01", "goto", "goto21");
    			LAi_SetCitizenType(CharacterFromID("Quirino Mendoza"));

			DeleteAttribute(&Locations[FindLocation("Cartagena_Exit")],"vcskip");
			LAi_LocationFightDisable(&Locations[FindLocation("Cartagena_Exit")], false);
		break;

		case "Purpure_Wilda_joins":
			NPChar = CharacterFromID("Wilda");
			NPChar.Dialog.Filename = "Enc_Officer_dialog.c";
			NPChar.Dialog.CurrentNode = "hired";
			LAi_SetActorType(NPChar);
			LAi_ActorRunToLocation(NPChar, "reload", "reload1", "none", "", "", "", 25.0);
			PChar.quest.Purpure_Wilda_officer.win_condition.l1 = "location";
			PChar.quest.Purpure_Wilda_officer.win_condition.l1.location = PChar.location.from_sea;
			PChar.quest.Purpure_Wilda_officer.win_condition = "Purpure_Wilda_officer";
		break;

		case "Purpure_Wilda_officer":
			NPChar = CharacterFromID("Wilda");
			SetModelFromID(NPChar, "Brinkley");
			LAi_SetActorType(NPChar);
			LAi_type_Actor_Reset(NPChar);
			PlaceCharacter(NPChar, "goto");
			if (CheckAttribute(PChar, "quest.Purpure_chicken"))
			{
				NPChar.Dialog.Filename = "Purpure_officers_dialog.c";
				NPChar.Dialog.CurrentNode = "Wilda_reject_coward";
				LAi_ActorDialog(NPChar, PChar, "", 15.0, 15.0);
				NPChar.location = "";
				LAi_SetCheckMinHP(NPChar, LAi_GetCharacterHP(NPChar)-1, false, "Purpure_attacked_Wilda");
			}
			else
			{
				PChar.quest.Purpure_new_officer = "Wilda";
				LAi_QuestDelay("Purpure_Wilda_officer2", 0.1);
			}
		break;

		case "Purpure_attacked_Wilda":
			ChangeCharacterReputation(PChar, -5);
			NPChar = CharacterFromID("Wilda");
			LAi_RemoveCheckMinHP(NPChar);
			GiveItem2Character(NPChar, "Piratesdagger");
			EquipCharacterByItem(NPChar, "Piratesdagger");
			LAi_SetActorType(NPChar);
			LAi_ActorAttack(NPChar, PChar, "");
		break;

		case "Purpure_Wilda_officer2":
			cidx = GetCharacterIndex(PChar.quest.Purpure_new_officer);
			NPChar = CharacterFromID(PChar.quest.Purpure_new_officer);
			SetOfficersIndex(PChar, -1, cidx);
			AddPassenger(PChar, NPChar, 0);
			NPChar.Dialog.Filename = "Enc_Officer_dialog.c";
			NPChar.Dialog.CurrentNode = "hired";
			NPChar.location = "";
			DeleteQuestAttribute("Purpure_new_officer");
		break;

		case "Purpure_new_outfit":
			GiveModel2Player("Purpure_Pirate", true);
		break;

///////////////////////////////////////////////////////////////
///// FREEPLAY: ENGINEER JRH
///////////////////////////////////////////////////////////////

		case "monk_map_talk":
			PlaySound("PEOPLE\creak2.wav");	
			LAi_SetStayType(Pchar);
			ChangeCharacterAddressGroup(characterFromID("NC_monk3"), "new_cloister_inside", "sit", "stay1");
			LAi_SetActorType(characterFromID("NC_monk3"));

			LAi_QuestDelay("monk_map_talk1", 0.5);
		break;

		case "monk_map_talk1":
			LAi_SetActorType(characterFromID("NC_monk3"));
			LAi_ActorDialog(characterFromID("NC_monk3"), pchar, "", 0.0, 0.0);
			LAi_ActorWaitDialog(Pchar, characterFromID("NC_monk3"));
			Characters[GetCharacterIndex("NC_monk3")].dialog.CurrentNode  = "map";
		break;		

		case "library_bars1":
			if (Pchar.sex == "man") { PlaySound("OBJECTS\VOICES\DEAD\male\dead0.wav"); }
			else PlaySound("VOICE\ENGLISH\gr_wench3_oh.wav");

			if(GetAttribute(pchar, "sakharine_phase") == "0")
			{
				Pchar.sakharine_phase = 1;
				LogIt(TranslateString("","It's Sakharine - is he dead?"));
			}
			else
			{
				LogIt(TranslateString("","There's poor Sakharine again."));
			}	

			LAi_SetCitizenType(characterFromID("NC_monkL"));
		break;

		case "library_bars2":
			if (Pchar.sex == "man") { PlaySound("VOICE\ENGLISH\blaze_huh.wav"); }
			else PlaySound("VOICE\ENGLISH\gr_wench3_aye.wav");

			if(GetAttribute(pchar, "sakharine_phase") == "0")
			{
				Pchar.sakharine_phase = 1;
				LogIt(TranslateString("","It's Sakharine - is he dead?"));
			}
			else
			{
				LogIt(TranslateString("","There's poor Sakharine again."));
			}

			LAi_SetCitizenType(characterFromID("NC_monkL"));
		break;

		case "portugize_extra_sound":
			PlaySound("PEOPLE\beltkey.wav");
		break;

		case "check_portugize_parts":
			if(CheckCharacterItem(Pchar,"port_stock") || CheckCharacterItem(Pchar,"port_metal") || CheckCharacterItem(Pchar,"port_rest")
			|| CheckCharacterItem(Pchar,"port_magazine") || CheckCharacterItem(Pchar,"port_barrel") || CheckCharacterItem(Pchar,"port_mechanism"))
			{
				AddQuestRecord("Beginning_Engineer", "6");
			}

			if(CheckCharacterItem(Pchar,"port_stock") && CheckCharacterItem(Pchar,"port_metal") && CheckCharacterItem(Pchar,"port_rest")
			&& CheckCharacterItem(Pchar,"port_magazine") && CheckCharacterItem(Pchar,"port_barrel") && CheckCharacterItem(Pchar,"port_mechanism"))
			{
				if(CheckCharacterItem(Pchar,"port_tools"))
				{
					AddQuestRecord("Beginning_Engineer", "9");	
				}
				else AddQuestRecord("Beginning_Engineer", "7");

				if(GetAttribute(pchar, "portugize_phase") == "0")
				{
					Pchar.portugize_phase = 1;
				}	
			}
			else 
			{
				if(CheckCharacterItem(Pchar,"port_tools")) AddQuestRecord("Beginning_Engineer", "8");
			}
		break;

		case "portugize_equip":
			PlaySound("OBJECTS\DUEL\reload1.wav");

			string weaponID = GetCharacterEquipByGroup(Pchar,BLADE_ITEM_TYPE);
			aref weapon;
			Items_FindItem(weaponID, &weapon);

			if(CheckAttribute(weapon, "id") && weapon.id == "")
			{
				EquipCharacterByItem(Pchar, BLADE_ITEM_TYPE);	
			}

			RemoveCharacterEquip(Pchar, GUN_ITEM_TYPE);
			EquipCharacterByItem(pchar, "portugize");

			LAi_QuestDelay("portugize_yes", 1.0);
		break;

		case "portugize_yes":
			if (PChar.sex == "man") { PlaySound("OBJECTS\DUEL\man_attack6.wav"); }
			else PlaySound("VOICE\ENGLISH\gr_wench3_pos.wav");

			LAi_QuestDelay("engineer_mission_complete_check", 0.5);
		break;

		case "engineer_mission_complete_check":
			if(GetAttribute(pchar, "engineer_mission") == "done") return;

			int gp = GetCharacterItem(Pchar, "gunpowder");
			int pg = GetCharacterItem(Pchar, "pistolgrapes");

			if(gp >= 5 && pg >= 5 && CheckCharacterItem(Pchar,"portugize"))
			{
				//mission complete
				DeleteQuestHeader("Beginning_Engineer");
				SetQuestHeader("Beginning_Engineer");
				AddQuestRecord("Beginning_Engineer", "11");
				CloseQuestHeader("Beginning_Engineer");

				Pchar.engineer_mission = "done";
			}
			else
			{
				if(CheckCharacterItem(Pchar,"portugize"))
				{
					AddQuestRecord("Beginning_Engineer", "10");
				}
			}
		break;

		case "check_portugize_books":
			if(CheckCharacterItem(Pchar,"book21F") && CheckCharacterItem(Pchar,"book22F") && CheckCharacterItem(Pchar,"book23F")
			&& CheckCharacterItem(Pchar,"book24F") && CheckCharacterItem(Pchar,"book26F") && CheckCharacterItem(Pchar,"book27F")
			&& CheckCharacterItem(Pchar,"book28F") && CheckCharacterItem(Pchar,"book29F") && CheckCharacterItem(Pchar,"book31F")
			&& CheckCharacterItem(Pchar,"book33F") && CheckCharacterItem(Pchar,"book34F") && CheckCharacterItem(Pchar,"book35F")
			&& CheckCharacterItem(Pchar,"book36F")) 
			{
				LAi_QuestDelay("librarian_change", 0.5);
			}
			else
			{
				if(CheckCharacterItem(Pchar,"book21F") || CheckCharacterItem(Pchar,"book22F") || CheckCharacterItem(Pchar,"book23F")
				|| CheckCharacterItem(Pchar,"book24F") || CheckCharacterItem(Pchar,"book26F") || CheckCharacterItem(Pchar,"book27F")
				|| CheckCharacterItem(Pchar,"book28F") || CheckCharacterItem(Pchar,"book29F") || CheckCharacterItem(Pchar,"book31F")
				|| CheckCharacterItem(Pchar,"book33F") || CheckCharacterItem(Pchar,"book34F") || CheckCharacterItem(Pchar,"book35F")
				|| CheckCharacterItem(Pchar,"book36F")) 
				{
					LAi_QuestDelay("librarian_hostile", 0.5);
				}
				else
				{
					//no books stolen - no attack from librarian
					LAi_QuestDelay("librarian_neutral", 0.5);
				}
			}
		break;

		case "librarian_change":
			if(GetAttribute(pchar, "NC_librarian") == "gone") return;

			LAi_SetActorType(characterFromID("NC_monkL"));
			ChangeCharacterAddressGroup(characterFromID("NC_monkL"), "new_cloister_library", "quest", "end");
			
			SetLocatorRadius(locations[FindLocation(Pchar.location)], "box", "box13", 1.0);
			Locations[FindLocation("new_cloister_library")].locators_radius.box.box13 = 1.0;
			SetLocatorRadius(locations[FindLocation(Pchar.location)], "reload", "reload1", 0.0001);
			Locations[FindLocation("new_cloister_library")].locators_radius.reload.reload1 = 0.0001;

			pchar.quest.librarian_change1.win_condition.l1 = "locator";
			pchar.quest.librarian_change1.win_condition.l1.location = "new_cloister_library";
			pchar.quest.librarian_change1.win_condition.l1.locator_group = "quest";
			pchar.quest.librarian_change1.win_condition.l1.locator = "end";
			pchar.quest.librarian_change1.win_condition = "librarian_change1";	
		break;

		case "librarian_change1":
			Pchar.NC_librarian = "gone";

			LAi_SetActorType(characterFromID("NC_monkL"));
			LAi_ActorDialog(characterFromID("NC_monkL"), pchar, "", 0.0, 0.0);
			LAi_ActorWaitDialog(Pchar, characterFromID("NC_monkL"));
			Characters[GetCharacterIndex("NC_monkL")].dialog.CurrentNode  = "change";
		break;

		case "librarian_change7":
			//1 librarian diappears
			
			LAi_SetStayType(Pchar);
			PlaySound("OBJECTS\DUEL\censer.wav");
			PlaySound("OBJECTS\DUEL\censer.wav");
			CreateParticleSystem("smoke_short" , -3.7, 3.7, -1.3, 0.0, 0.0, 0.0, sti(20) );
		//CreateParticleSystemX("blast_dirt", -17.2, 4.9, -24.4, -17.2, 4.9, -24.4, 10);
			ChangeCharacterAddressGroup(CharacterFromID("NC_monkL"), "none", "", "");

			LAi_QuestDelay("librarian_change8", 1.5);
		break;

		case "librarian_change8":
			//2 pchar new outfit

			PlaySound("PEOPLE\transform.wav");
			float u, v, w;
			GetCharacterPos(Pchar, &u, &v, &w);
			CreateParticleSystem("stars_short" , u, v+1.4, w, 0.0, 0.0, 0.0, sti(20) );

			SetModel(PChar, "Animists3_empty", Pchar.model.animation, PChar.sex, stf(PChar.model.height), true);
			Pchar.old.name = "Librarian";
			Pchar.old.lastname = "";
			Pchar.name = TranslateString("", "Librarian");
			Pchar.lastname = "";

			LAi_QuestDelay("librarian_change9", 1.5);
		break;

		case "librarian_change9":
			LAi_SetPlayerType(Pchar);
			if (PChar.sex == "man") { PlaySound("VOICE\ENGLISH\blaze_scream.wav"); }
			else PlaySound("VOICES\DEAD\female\dead_wom1.wav");
		break;

		case "library_for_ever":
			LAi_SetActorType(pchar);	
			characters[GetCharacterIndex("Blaze")].dialog.CurrentNode = "library_for_ever";
			LAi_ActorSelfDialog(pchar, "");
		break;

		case "library_for_ever1":
			LAi_SetPlayerType(pchar);
		break;

		case "librarian_hostile":
			if(GetAttribute(pchar, "NC_librarian") == "gone") return;

			PlaySound("VOICE\ENGLISH\c_brother21.wav");
			LAi_LocationFightDisable(&Locations[FindLocation("new_cloister_library")], false);
		
			LAi_SetActorType(characterFromID("NC_monkL"));
			LAi_ActorAttack(CharacterFromID("NC_monkL"), Pchar, "");
		break;

		case "librarian_neutral":
			if(GetAttribute(pchar, "NC_librarian") == "gone") return;

			LAi_LocationFightDisable(&Locations[FindLocation("new_cloister_library")], true);
			if(LAi_IsFightMode(characterFromID("NC_monkL")))
			{
				LAi_SetFightMode(characterFromID("NC_monkL"), false);
			}
			
			LAi_SetCitizenType(characterFromID("NC_monkL"));
		break;

		case "cartagena_cloister_open":
			PlaySound("PEOPLE\creak2.wav");			

			SetLocatorRadius(locations[FindLocation(Pchar.location)], "reload", "reload5", 1.5);		//access to library
			Locations[FindLocation("new_cloister_inside")].locators_radius.reload.reload5 = 1.5;

			ChangeCharacterAddressGroup(characterFromID("NC_monk3"), "new_cloister_inside", "sit", "sit1");
			LAi_SetSitType(characterFromID("NC_monk3"));
			Characters[GetCharacterIndex("NC_monk3")].dialog.CurrentNode  = "First time";

			Pchar.cartagena_library = "open";
			LAi_SetPlayerType(Pchar);
		break;

///////////////////////////////////////////////////////////////
///// FREEPLAY: GAMBLER JRH & PW
///////////////////////////////////////////////////////////////

		
		case "Competition_Day_One_Start": //from bouncer_dialog
			PChar.quest.poker.started = "true";
			PChar.quest.poker.day = "1";
			PChar.quest.poker.result = "0";
			sld = &characters[GetCharacterIndex("Reg_L")];
			LAi_SetActorType(sld);
			LAi_SetActorType(Pchar);
			LAi_ActorWaitDialog(Pchar,sld);
			LAi_ActorDialog(sld, Pchar, "", 0, 0);
			LAi_SetPlayerType(Pchar);
			Locations[FindLocation("Turks_poker_room")].reload.l1.disable = true;
			DisableFastTravel(true);
			DeleteAttribute(PChar, "quest.Poker_next_tournament_Noreturn");
		break;
		
		
		case "Instructions":
		locations[FindLocation(Pchar.location)].image = "poker_entre.tga";
		sld = &characters[GetCharacterIndex("Reg_L")];
		if (!checkAttribute(PChar,"quest.poker.winner"))
			{
			Characters[GetCharacterIndex("Reg_L")].dialog.CurrentNode  = "Instructions1";
			}
			else
			{
			Characters[GetCharacterIndex("Reg_L")].dialog.CurrentNode  = "Onward 2";
			}
		LAi_SetActorType(sld);
		LAi_SetActorType(Pchar);
		LAi_ActorWaitDialog(Pchar,sld);
		LAi_ActorDialog(sld, Pchar, "", 1.0, 0);
		LAi_SetPlayerType(Pchar);
		break;
		
		case "Competition_Day_One_Start2": //from Poker Twins_dialog.c
			
			if (CheckAttribute(Pchar,"quest.poker.winner"))
			{
			RemoveCharacterEquip(characterFromID(Pchar.quest.poker.winner), BLADE_ITEM_TYPE);//
			if (CheckCharacterItem(characterFromID(Pchar.quest.poker.winner),"bladetrophy"))TakeItemFromCharacter(characterFromID(Pchar.quest.poker.winner), "bladetrophy");
			}
			EquipCharacterByItem(Pchar, Pchar.equip.blade);
			sld = &characters[GetCharacterIndex("Ron_L")];
			Characters[GetCharacterIndex("Ron_L")].dialog.CurrentNode  = "Ronnie speaks";
			times = sti(pchar.quest.poker.times) + 1;
			pchar.quest.poker.times = times;
		break;
		
		
		
		case "Competition_day_end":// from quests.commom.c
		switch (Pchar.quest.poker.day)
		{
			case "1":	
				Characters[GetCharacterIndex("Reg_L")].dialog.CurrentNode  = "Day one end";
				
			break;

			case "3":
			Characters[GetCharacterIndex("Reg_L")].dialog.CurrentNode  = "Day two end";
			
			break;
			
			case "5":
			//workout who won
				switch(Pchar.quest.poker.result)
				{
				case "9":Pchar.quest.poker.winner = "Blaze";break;
				case "8":Pchar.quest.poker.winner = "Gambler 1";break;
				case "6":Pchar.quest.poker.winner = "Gambler 2";break;
				case "5":Pchar.quest.poker.winner = "Gambler 2";break;
				case "4":Pchar.quest.poker.winner = "Gambler 3";break;
				case "3":Pchar.quest.poker.winner = "Gambler 3";break;
				case "1":Pchar.quest.poker.winner = "Gambler 3";break;
				case "0":Pchar.quest.poker.winner = "Gambler 1";break;
				}
			
				Characters[GetCharacterIndex("Reg_L")].dialog.CurrentNode  = "Day three end";
				LAi_SetActorType(Pchar);
				Lai_ActorRunToLocator(pchar, "goto", "goto18", "", 0);//pw was 17
			break;
		}		
				
		ChangeCharacterAddressGroup(characterFromID("Ron_L"), "Turks_poker_room", "goto", "goto14");
		ChangeCharacterAddressGroup(characterFromID("Reg_L"), "Turks_poker_room", "goto", "goto15");
				
		sld = &characters[GetCharacterIndex("Ron_L")];
		LAi_SetActorType(sld);
		sld = &characters[GetCharacterIndex("Reg_L")];
		LAi_SetActorType(sld);
		LAi_SetActorType(Pchar);
		LAi_ActorTurnToLocator(Pchar,"goto","goto15");
		LAi_ActorWaitDialog(Pchar, sld);
		LAi_ActorDialog(sld, Pchar, "", 1.0, 0);
		LAi_SetPlayerType(Pchar);
		DisableFastTravel(false);
		break;
		
		case "Competition_Day_One_Timer"://from Poker Twins_dialog.c
		PChar.quest.Day_Expired.win_condition.l1 = "Timer";
		PChar.quest.Day_Expired.win_condition.l1.date.day = GetAddingDataDay(0, 0, 1);
		PChar.quest.Day_Expired.win_condition.l1.date.month = GetAddingDataMonth(0, 0, 1);
		PChar.quest.Day_Expired.win_condition.l1.date.year = GetAddingDataYear(0, 0, 1);
		PChar.quest.Day_Expired.win_condition = "Competition_Day_Two_Start";
		
		PChar.quest.Day_Noreturn.win_condition.l1 = "Timer";
		PChar.quest.Day_Noreturn.win_condition.l1.date.day = GetAddingDataDay(0, 0, 2);
		PChar.quest.Day_Noreturn.win_condition.l1.date.month = GetAddingDataMonth(0, 0, 2);
		PChar.quest.Day_Noreturn.win_condition.l1.date.year = GetAddingDataYear(0, 0, 2);
		PChar.quest.Day_Noreturn.win_condition = "Competition_Lockout";
		break;
		
		
		case "Competition_Day_Two_Start"://timer set in this file
		ChangeCharacterAddressGroup(characterFromID("Gambler 1"), "Turks_poker_room", "sit", "sit6");
		ChangeCharacterAddressGroup(characterFromID("Gambler 2"), "Turks_poker_room", "sit", "sit3");
		ChangeCharacterAddressGroup(characterFromID("Gambler 3"), "Turks_poker_room", "sit", "sit2");
		ChangeCharacterAddressGroup(characterFromID("Ron_L"), "Turks_poker_room", "goto", "goto14");
		ChangeCharacterAddressGroup(characterFromID("Reg_L"), "Turks_poker_room", "goto", "goto5");
		Pchar.quest.poker.day = "3";
		Locations[FindLocation("Turks_poker_room")].reload.l1.disable = true;
		Locations[FindLocation("Turks_poker_entre")].reload.l3.disable = false;
		sld = &characters[GetCharacterIndex("Ron_L")];
		Characters[GetCharacterIndex("Ron_L")].dialog.CurrentNode  = "Day two";
		LAi_SetPlayerType(sld);	
		DisableFastTravel(true);
		
		break;
		
		case "Competition_Day_Two_Timer"://from Poker Twins_dialog.c
		PChar.quest.Day_Expired.win_condition.l1 = "Timer";
		PChar.quest.Day_Expired.win_condition.l1.date.day = GetAddingDataDay(0, 0, 1);
		PChar.quest.Day_Expired.win_condition.l1.date.month = GetAddingDataMonth(0, 0, 1);
		PChar.quest.Day_Expired.win_condition.l1.date.year = GetAddingDataYear(0, 0, 1);
		PChar.quest.Day_Expired.win_condition = "Competition_Day_Three_Start";
		
		PChar.quest.Day_Noreturn.win_condition.l1 = "Timer";
		PChar.quest.Day_Noreturn.win_condition.l1.date.day = GetAddingDataDay(0, 0, 2);
		PChar.quest.Day_Noreturn.win_condition.l1.date.month = GetAddingDataMonth(0, 0, 2);
		PChar.quest.Day_Noreturn.win_condition.l1.date.year = GetAddingDataYear(0, 0, 2);
		PChar.quest.Day_Noreturn.win_condition = "Competition_Lockout";
		break;
		
		case "Competition_Day_Three_Start"://timer set in this file
		ChangeCharacterAddressGroup(characterFromID("Gambler 1"), "Turks_poker_room", "sit", "sit6");
		ChangeCharacterAddressGroup(characterFromID("Gambler 2"), "Turks_poker_room", "sit", "sit4");
		ChangeCharacterAddressGroup(characterFromID("Gambler 3"), "Turks_poker_room", "sit", "sit3");
		ChangeCharacterAddressGroup(characterFromID("Ron_L"), "Turks_poker_room", "goto", "goto14");
		ChangeCharacterAddressGroup(characterFromID("Reg_L"), "Turks_poker_room", "goto", "goto7");
		PChar.quest.poker.day = "5";
		DisableFastTravel(true);
		Locations[FindLocation("Turks_poker_room")].reload.l1.disable = true;
		Locations[FindLocation("Turks_poker_entre")].reload.l3.disable = false;
		sld = &characters[GetCharacterIndex("Ron_L")];
		Characters[GetCharacterIndex("Ron_L")].dialog.CurrentNode  = "Day three";
		LAi_SetPlayerType(sld);	
		
		break;
		
			
		case "Competition_New_Comp_Timer": //from Poker Twins_dialog.c
		
		PChar.quest.Poker_near_next_tournament.win_condition.l1 = "Timer";
		PChar.quest.Poker_near_next_tournament.win_condition.l1.date.day = GetAddingDataDay(0, 5, 0);
		PChar.quest.Poker_near_next_tournament.win_condition.l1.date.month = GetAddingDataMonth(0, 5, 0);
		PChar.quest.Poker_near_next_tournament.win_condition.l1.date.year = GetAddingDataYear(0, 5, 0);
		PChar.quest.Poker_near_next_tournament.win_condition = "Nearly Next Competition";
		
		
		PChar.quest.Poker_next_tournament.win_condition.l1 = "Timer";
		PChar.quest.Poker_next_tournament.win_condition.l1.date.day = GetAddingDataDay(0, 6, 0);
		PChar.quest.Poker_next_tournament.win_condition.l1.date.month = GetAddingDataMonth(0, 6, 0);
		PChar.quest.Poker_next_tournament.win_condition.l1.date.year = GetAddingDataYear(0, 6, 0);
		PChar.quest.Poker_next_tournament.win_condition = "Competition_Reset_Stuff";
		
		PChar.quest.Poker_next_tournament_Noreturn.win_condition.l1 = "Timer";
		PChar.quest.Poker_next_tournament_Noreturn.win_condition.l1.date.day = GetAddingDataDay(0, 7, 0);
		PChar.quest.Poker_next_tournament_Noreturn.win_condition.l1.date.month = GetAddingDataMonth(0, 7, 0);
		PChar.quest.Poker_next_tournament_Noreturn.win_condition.l1.date.year = GetAddingDataYear(0, 7, 0);
		PChar.quest.Poker_next_tournament_Noreturn.win_condition = "Competition_Lockout3";
		break;
		
		
		case "Nearly Next Competition"://timer set in this file 5 months - 1 month before next one give warning/reminder
		AddQuestRecord("Poker_Tournament", 8);
		break;
		
		case "Competition Winner": //Trophy presentation to pchar//from Poker Twins_dialog.c
		LAi_SetActorType(&characters[GetCharacterIndex("Gambler 3")]);
		LAi_SetActorType(&characters[GetCharacterIndex("Gambler 1")]);
		LAi_SetActorType(&characters[GetCharacterIndex("Gambler 2")]);
		LAi_SetActorType(&characters[GetCharacterIndex("Reg_L")]);
		LAi_ActorTurnToLocator(characterFromID("Gambler 1"),"goto","goto19");

		//LAi_SetActorType(Pchar);	
		//Lai_ActorRunToLocator(pchar, "goto", "goto17", "", 0);
		ChangeCharacterAddressGroup(characterFromID("Gambler 1"), "Turks_poker_room", "goto", "goto17");//pw was 18
		ChangeCharacterAddressGroup(characterFromID("Gambler 2"), "Turks_poker_room", "goto", "goto19");
		ChangeCharacterAddressGroup(characterFromID("Gambler 3"), "Turks_poker_room", "goto", "goto20");
		Pchar.quest.poker.blade = Pchar.equip.blade;
			
			switch(Pchar.quest.poker.winner)
				{
					
				case "Blaze":
				LAi_SetActorType(Pchar);
				LAi_ActorTurnToCharacter(Pchar, characterFromID("Ron_L"));
				Lai_ActorRunToLocator(Pchar, "goto", "goto16", "presentation", 2);
				
				break;
				
				case "Gambler 1":
				ChangeCharacterAddressGroup(Pchar, "Turks_poker_room", "goto", "goto18");//pw was 17
				LAi_SetActorType(Pchar);
				LAi_ActorTurnToCharacter(Pchar, characterFromID("Ron_L"));
				LAi_ActorRunToLocator(characterFromID("Gambler 1"),"goto","goto16", "presentation", 3);
				break;
				
				case "Gambler 2":
				ChangeCharacterAddressGroup(Pchar, "Turks_poker_room", "goto", "goto18");//pw was 17
				LAi_SetActorType(Pchar);
				LAi_ActorTurnToCharacter(Pchar, characterFromID("Ron_L"));
				Lai_ActorRunToLocator(characterFromID("Gambler 2"), "goto", "goto16", "presentation", 3);
				break;
											
				case "Gambler 3":
				ChangeCharacterAddressGroup(Pchar, "Turks_poker_room", "goto", "goto18");//pw was 17
				LAi_SetActorType(Pchar);
				LAi_ActorTurnToCharacter(Pchar, characterFromID("Ron_L"));
				Lai_ActorRunToLocator(characterFromID("Gambler 3"), "goto", "goto16", "presentation", 3);
				break;
				
				}
		
		break;
		
		case "presentation":
		LAi_LocationFightDisable(&Locations[FindLocation("Turks_poker_room")], false);//unset room	
			switch(Pchar.quest.poker.winner)
				{
					
				case "Blaze":
				LAi_SetPlayerType(characterFromID("Ron_L"));
				LAi_SetFightMode(characterFromID("Ron_L"), true);
				EquipCharacterByItem(Pchar, "bladeX4");
				LAi_SetPlayerType(Pchar);
				LAi_SetFightMode(PChar, true);
				break;
				
				case "Gambler 1":
				LAi_ActorTurnToCharacter(characterFromID("Gambler 1"), characterFromID("Ron_L"));
				LAi_SetPlayerType(characterFromID("Ron_L"));
				LAi_SetFightMode(characterFromID("Ron_L"), true);
				RemoveCharacterEquip(characterFromID("Gambler 1"), BLADE_ITEM_TYPE);
				GiveItem2Character(characterFromID("Gambler 1"), "bladeX4");
				EquipCharacterByItem(characterFromID("Gambler 1"), "bladeX4");
				LAi_SetPlayerType(characterFromID("Gambler 1"));
				LAi_SetFightMode(characterFromID("Gambler 1"), true);
				break;
				
				case "Gambler 2":
				LAi_ActorTurnToCharacter(characterFromID("Gambler 2"), characterFromID("Ron_L"));
				LAi_SetPlayerType(characterFromID("Ron_L"));
				LAi_SetFightMode(characterFromID("Ron_L"), true);
				RemoveCharacterEquip(characterFromID("Gambler 2"), BLADE_ITEM_TYPE);
				GiveItem2Character(characterFromID("Gambler 2"), "bladeX4");
				EquipCharacterByItem(characterFromID("Gambler 2"), "bladeX4");
				LAi_SetPlayerType(characterFromID("Gambler 2"));
				LAi_SetFightMode(characterFromID("Gambler 2"), true);
				break;
											
				case "Gambler 3":
				LAi_ActorTurnToCharacter(characterFromID("Gambler 3"), characterFromID("Ron_L"));
				LAi_SetPlayerType(characterFromID("Ron_L"));
				LAi_SetFightMode(characterFromID("Ron_L"), true);
				RemoveCharacterEquip(characterFromID("Gambler 3"), BLADE_ITEM_TYPE);
				GiveItem2Character(characterFromID("Gambler 3"), "bladeX4");
				EquipCharacterByItem(characterFromID("Gambler 3"), "bladeX4");
				LAi_SetPlayerType(characterFromID("Gambler 3"));
				LAi_SetFightMode(characterFromID("Gambler 3"), true);
				break;
				
				}
				LAi_QuestDelay("presentation1", 2);
		break;
		
		case "presentation1": 
				RemoveCharacterEquip(characterFromID("Ron_L"), BLADE_ITEM_TYPE);
				GiveItem2Character(characterFromID("Ron_L"), "bladeX4");
				EquipCharacterByItem(characterFromID("Ron_L"), "bladeX4");
								
			switch(Pchar.quest.poker.winner)
				{
					
				case "Blaze":
				RemoveCharacterEquip(Pchar, BLADE_ITEM_TYPE);
				GiveItem2Character(Pchar, "bladetrophy");//give trophy
				EquipCharacterByItem(Pchar, "bladetrophy");//show trophy  
				break;
				
				case "Gambler 1":
				RemoveCharacterEquip(characterFromID("Gambler 1"), BLADE_ITEM_TYPE);
				GiveItem2Character(characterFromID("Gambler 1"), "bladetrophy");//give trophy
				EquipCharacterByItem(characterFromID("Gambler 1"), "bladetrophy");//show trophy  
				break;
				
				case "Gambler 2":
				RemoveCharacterEquip(characterFromID("Gambler 2"), BLADE_ITEM_TYPE);
				GiveItem2Character(characterFromID("Gambler 2"), "bladetrophy");//give trophy
				EquipCharacterByItem(characterFromID("Gambler 2"), "bladetrophy");//show trophy  
				break;
											
				case "Gambler 3":
				RemoveCharacterEquip(characterFromID("Gambler 3"), BLADE_ITEM_TYPE);
				GiveItem2Character(characterFromID("Gambler 3"), "bladetrophy");//give trophy
				EquipCharacterByItem(characterFromID("Gambler 3"), "bladetrophy");//show trophy 
				break;
				
				}
				LAi_QuestDelay("presentation2", 1);
		break;
		
		case "presentation2": 
		
				if(LAi_IsFightMode(characterFromID("Ron_L"))) LAi_SetFightMode(characterFromID("Ron_L"), false);
				if(LAi_IsFightMode(Pchar)) LAi_SetFightMode(Pchar, false);
				if(LAi_IsFightMode(characterFromID("Gambler 1"))) LAi_SetFightMode(characterFromID("Gambler 1"), false);
				if(LAi_IsFightMode(characterFromID("Gambler 2"))) LAi_SetFightMode(characterFromID("Gambler 2"), false);
				if(LAi_IsFightMode(characterFromID("Gambler 3"))) LAi_SetFightMode(characterFromID("Gambler 3"), false);
				
				LAi_LocationFightDisable(&Locations[FindLocation("Turks_poker_room")], true);		
				
				
				LAi_QuestDelay("presentation3", 1.0);
				
		break;
		
		case "presentation3": 
	
		Switch (pchar.quest.poker.times)
{
		
		case "1":
		Preprocessor_AddQuestData("date1", GetHumanDate(GetAddingDataYear(0, 6, 0), GetAddingDataMonth(0, 6, 0), GetAddingDataDay(0, 6, 0)));
		if (Pchar.quest.poker.winner  == "Blaze")
				{
				PlaySound("INTERFACE\coins8.wav");
				AddMoneyToCharacter(Pchar, 60000);
				AddQuestRecord("Poker_Tournament", 10);
				LAi_SetPlayerType(Pchar);
				}
				else AddQuestRecord("Poker_Tournament", 11);
		Preprocessor_Remove("date1");
		break;

		case "2":
		Preprocessor_AddQuestData("date2", GetHumanDate(GetAddingDataYear(0, 6, 0), GetAddingDataMonth(0, 6, 0), GetAddingDataDay(0, 6, 0)));
		if (Pchar.quest.poker.winner  == "Blaze")
				{
				PlaySound("INTERFACE\coins8.wav");
				AddMoneyToCharacter(Pchar, 60000);
				AddQuestRecord("Poker_Tournament", 12);
				LAi_SetPlayerType(Pchar);
				}
				else AddQuestRecord("Poker_Tournament", 13);
		Preprocessor_Remove("date2");
		break;
		
		case "3":
		Preprocessor_AddQuestData("date3", GetHumanDate(GetAddingDataYear(0, 6, 0), GetAddingDataMonth(0, 6, 0), GetAddingDataDay(0, 6, 0)));
		if (Pchar.quest.poker.winner  == "Blaze")
				{
				PlaySound("INTERFACE\coins8.wav");
				AddMoneyToCharacter(Pchar, 60000);
				AddQuestRecord("Poker_Tournament", 14);
				LAi_SetPlayerType(Pchar);
				}
				else AddQuestRecord("Poker_Tournament", 15);
		Preprocessor_Remove("date3");
		break;
		
		case "4":
		Preprocessor_AddQuestData("date4", GetHumanDate(GetAddingDataYear(0, 6, 0), GetAddingDataMonth(0, 6, 0), GetAddingDataDay(0, 6, 0)));
		if (Pchar.quest.poker.winner  == "Blaze")
				{
				PlaySound("INTERFACE\coins8.wav");
				AddMoneyToCharacter(Pchar, 60000);
				AddQuestRecord("Poker_Tournament", 16);
				LAi_SetPlayerType(Pchar);
				}
				else AddQuestRecord("Poker_Tournament", 17);
			Preprocessor_Remove("date4");
		break;

				Preprocessor_AddQuestData("date", GetHumanDate(GetAddingDataYear(0, 6, 0), GetAddingDataMonth(0, 6, 0), GetAddingDataDay(0, 6, 0)));
		
				if (Pchar.quest.poker.winner  == "Blaze")
				{
				PlaySound("INTERFACE\coins8.wav");
				AddMoneyToCharacter(Pchar, 60000);
				AddQuestRecord("Poker_Tournament", 4);
				LAi_SetPlayerType(Pchar);
				}
				else AddQuestRecord("Poker_Tournament", 5);
		Preprocessor_Remove("date");
}	
		sld = &characters[GetCharacterIndex("Ron_L")];
		Characters[GetCharacterIndex("Ron_L")].dialog.CurrentNode  = "Day three presentation";
		LAi_SetActorType(sld);
		LAi_SetActorType(pchar);
		LAi_ActorTurnToLocator(Pchar,"goto","goto14");
		LAi_ActorDialog(sld, Pchar, "", 0, 0);
		GiveItem2Character(Pchar, "poker_invite2");//give poker_invite 
		LAi_SetPlayerType(Pchar);			
		LAi_SetPlayerType(characterFromID("Gambler 1"));
		LAi_SetPlayerType(characterFromID("Gambler 2"));
		LAi_SetPlayerType(characterFromID("Gambler 3"));
		RemoveCharacterEquip(Pchar, BLADE_ITEM_TYPE);
		EquipCharacterByItem(Pchar, Pchar.quest.poker.blade);//re equip sword
		DeleteAttribute(PChar,"quest.poker.started");//pw prevent wrong style game in tavern
		DeleteAttribute(PChar,"quest.poker.hands");
		DeleteAttribute(PChar,"quest.poker.blade");
		DisableFastTravel(false);
			
		
		break;
		
		
		case "Competition_Lockout"://timer set in this file
		Locations[FindLocation("Turks_poker_entre")].reload.l3.disable = true;
		DeleteAttribute(PChar,"quest.poker.started");//pw prevent wrong style game in tavern
		PChar.quest.poker.lockout = true;//set dialogue for bouncer
		AddQuestRecord("Poker_Tournament", 3);
		CloseQuestHeader("Poker_Tournament");
		DisableFastTravel(false);//make sure fast travel restored just in case it was blocked
		break;
		
		case "Competition_Lockout2"://from bouncer_dialog.c
		Locations[FindLocation("Turks_port")].reload.l19.disable = true;//final close entre after dialogue with bouncer
		
		break;
		
		case "Competition_Lockout3"://timer set in this file at 7 months from last tournament
		Locations[FindLocation("Turks_port")].reload.l19.disable = true;
		AddQuestRecord("Poker_Tournament", 7);
		CloseQuestHeader("Poker_Tournament");
		
		if (CheckCharacterItem(PChar,"poker_invite2"))TakeItemFromCharacter(pchar, "poker_invite2");
		if (CheckCharacterItem(PChar,"bladetrophy"))TakeItemFromCharacter(pchar, "bladetrophy");
		break;
		
		case "Competition_Reset_Stuff"://timer set in this file for next competition reset after 6 months
				
		
		DeleteAttribute(PChar,"quest.poker.day");
		DeleteAttribute(PChar,"quest.poker.result");
		DeleteAttribute(PChar,"quest.poker.hands");
		DeleteAttribute(PChar,"quest.poker.blade");
		
		ChangeCharacterAddressGroup(characterFromID("Reg_L"), "Turks_poker_entre", "goto", "goto8");
		Characters[GetCharacterIndex("Reg_L")].dialog.CurrentNode  = "First time";
		LAi_SetPlayerType(characterFromID("Reg_L"));
		
		if(PChar.sex == "man")
		{
		AddQuestRecord("Poker_Tournament", 6);
		}
		else
		{ 
		AddQuestRecord("Poker_Tournament", 9); 
		}	
		ChangeCharacterAddressGroup(characterFromID("Gambler 1"), "Turks_poker_room", "sit", "sit3");
		LAi_SetActorType(Characters[GetCharacterIndex("Gambler 1")]);
		LAi_SetSitType(characterFromID("Gambler 1"));
		LAi_SetPlayerType(Characters[GetCharacterIndex("Gambler 2")]);
		ChangeCharacterAddressGroup(characterFromID("Gambler 2"), "Turks_poker_room", "sit", "sit4");
		LAi_SetActorType(Characters[GetCharacterIndex("Gambler 2")]);
		LAi_SetSitType(characterFromID("Gambler 2"));
		LAi_SetPlayerType(Characters[GetCharacterIndex("Gambler 3")]);
		ChangeCharacterAddressGroup(characterFromID("Gambler 3"), "Turks_poker_room", "sit", "sit6");
		LAi_SetActorType(Characters[GetCharacterIndex("Gambler 3")]);
		LAi_SetSitType(characterFromID("Gambler 3"));
		LAi_SetPlayerType(Characters[GetCharacterIndex("Gambler 3")]);
		Characters[GetCharacterIndex("Ron_L")].dialog.CurrentNode  = "Ronnie speaks";
		LAi_SetPlayerType(characterFromID("Ron_L"));
					
		break;

///////////////////////////////////////////////////////////////
//    Agent: GR
///////////////////////////////////////////////////////////////

// Starting quest -->
		case "AgentStart_get_room":	// Triggered by dialog with "TQ_Char1", then renting tavern room
			StartQuestMovie(true, false, false);
			TrackQuestMovie("start","AgentStart_get_room");
			LAi_QuestDelay("AgentStart_get_room2", 1.5);
		break;

		case "AgentStart_get_room2":
			NPChar = CharacterFromID("TQ_Char1");
			ChangeCharacterAddressGroup(NPChar, PChar.location, "reload", "reload1");
			EndQuestMovie();TrackQuestMovie("end","AgentStart_get_room2");
			LAi_SetActorType(NPChar);
			NPChar.Dialog.CurrentNode = "agent_start_talk_in_room";
			LAi_ActorDialog(NPChar, PChar, "", 5.0, 5.0);
		break;

		case "AgentStart_Prepare_Leave_Room":	// Triggered by dialog with "TQ_Char1" in tavern room if your ship is in port
			Characters[GetCharacterIndex("TQ_Char1")].location = "None";
			PChar.quest.AgentStartPrepareLeaveRoom2.win_condition.l1 = "ExitFromLocation";
			PChar.quest.AgentStartPrepareLeaveRoom2.win_condition.l1.location = PChar.location;
			PChar.quest.AgentStartPrepareLeaveRoom2.win_condition = "AgentStart_Prepare_Leave_Room2";
		break;

		case "AgentStart_Prepare_Leave_Room2":
			PChar.quest.agent_start.agent_tavern = PChar.location;
			PChar.quest.AgentStartBackToTavern.win_condition.l1 = "ExitFromLocation";
			PChar.quest.AgentStartBackToTavern.win_condition.l1.location = PChar.location;
			PChar.quest.AgentStartBackToTavern.win_condition = "AgentStart_Back_To_Tavern";
		break;

		case "AgentStart_Back_To_Tavern":
			NPChar = CharacterFromID("TQ_Char1");
			ChangeCharacterAddressGroup(NPChar, PChar.quest.agent_start.agent_tavern, "goto", "goto2");
			LAi_SetCitizenType(NPChar);
			NPChar.Dialog.CurrentNode = "agent_start_ship_moved";
		break;

		case "AgentStart_follow_to_ship":	// Triggered by dialog with"TQ_Char1"
			NPChar = CharacterFromID("TQ_Char1");
			NPChar.Dialog.CurrentNode = "First time";
			NPChar.name = NPChar.old.name;
			if (CheckAttribute(NPChar, "middlename")) NPChar.middlename = NPChar.old.middlename;
			NPChar.lastname = NPChar.old.lastname;
			NPChar.nation = Characters[GetCharacterIndex("Malcolm Hatcher")].nation;
			LAi_SetActorType(NPChar);
			LAi_ActorFollowEverywhere(NPChar, "", 10.0);
			LAi_group_MoveCharacter(NPChar, LAI_GROUP_PLAYER);
			DisableFastTravel(true);
           		Locations[FindLocation(PChar.location.from_sea)].vcskip = true;
			PChar.quest.AgentStart_arrived_ship.win_condition.l1 = "location";
			PChar.quest.AgentStart_arrived_ship.win_condition.l1.location = PChar.location.from_sea;
			PChar.quest.AgentStart_arrived_ship.win_condition = "AgentStart_arrived_ship";
			PChar.quest.AgentStart_arrived_ship.fail_condition.l1 = "NPC_Death";
			PChar.quest.AgentStart_arrived_ship.fail_condition.l1.character = "TQ_Char1";
			PChar.quest.AgentStart_arrived_ship.fail_condition = "AgentStart_contact_dead";
		break;

		case "AgentStart_contact_dead":
			Preprocessor_AddQuestData("name2", GetMySimpleOldName(CharacterFromID("TQ_Char1")));
			AddQuestRecord("Beginning_Agent", 1);
			Preprocessor_Remove("island1");
		break;

		case "AgentStart_arrived_ship":
			DisableFastTravel(false);
			DeleteAttribute(&Locations[FindLocation(PChar.location.from_sea)],"vcskip");
			LAi_SetFightMode(PChar, false);
			i = sti(Characters[GetCharacterIndex("TQ_Char1")].nation);
			if (i == PERSONAL_NATION) i = FindFriendlyNation2Nation(PERSONAL_NATION);
			switch(i)
			{
				case ENGLAND:
					if (GetCurrentPeriod() == PERIOD_EARLY_EXPLORERS) PChar.quest.agent_start.HQ = "Tortuga_townhall";
					else PChar.quest.agent_start.HQ = "Antigua_Residence";
				break;

				case FRANCE:
					if (GetCurrentPeriod() == PERIOD_EARLY_EXPLORERS) PChar.quest.agent_start.HQ = "Tortuga_townhall";
					else PChar.quest.agent_start.HQ = "PaP_Academy";
				break;

				case SPAIN:
					PChar.quest.agent_start.HQ = "Havana_House_03";
				break;

				case PIRATE:
					PChar.quest.agent_start.HQ = "QC_residence";
				break;

				case HOLLAND:
					if (GetCurrentPeriod() == PERIOD_EARLY_EXPLORERS) PChar.quest.agent_start.HQ = "Tortuga_townhall";
					else PChar.quest.agent_start.HQ = "Willemstad_townhall";
				break;

				case PORTUGAL:
					PChar.quest.agent_start.HQ = "Conceicao_townhall";
				break;

				case GUEST1_NATION:
					if (GetCurrentPeriod() >= PERIOD_REVOLUTIONS) PChar.quest.agent_start.HQ = "Eleuthera_townhall";
					else PChar.quest.agent_start.HQ = Characters[GetCharacterIndex("Swedish Emissary")].location;
				break;
			}
			NPChar = CharacterFromID("TQ_Char1");
			if(NPChar.location != PChar.location && !LAi_IsDead(NPChar)) PlaceCharacter(NPChar, "goto");
			LAi_SetActorType(NPChar);
			LAi_type_Actor_Reset(NPChar);
			NPChar.Dialog.CurrentNode = "agent_start_where_to_go";
//			LAi_SetActorType(NPChar);
//			LAi_ActorWaitDialog(NPChar, PChar);
//			LAi_ActorDialog(NPChar, PChar, "AgentStart_Prepare_Board_Ship", 5.0, 5.0);
			LAi_ActorDialog(NPChar, PChar, "AgentStart_Prepare_Board_Ship", -1, -1);
		break;

		case "AgentStart_Prepare_Board_Ship":
			NPChar = CharacterFromID("TQ_Char1");
			LAi_SetActorType(NPChar);
			LAi_ActorFollowEverywhere(NPChar, "", 10.0);
			PChar.quest.AgentStart_arrived_destination.win_condition.l1 = "location";
			PChar.quest.AgentStart_arrived_destination.win_condition.l1.location = PChar.quest.agent_start.HQ;
			PChar.quest.AgentStart_arrived_destination.win_condition = "AgentStart_arrived_destination";
		break;

		case "AgentStart_arrived_destination":
			NPChar = CharacterFromID("TQ_Char1");
			ChangeRMRelation(PChar, sti(NPChar.nation), 1.0);
			LAi_SetActorType(NPChar);
			LAi_type_Actor_Reset(NPChar);
			NPChar.Dialog.CurrentNode = "agent_start_reward";
			LAi_ActorDialog(NPChar, PChar, "AgentStart_ended", 5.0, 5.0);
		break;

		case "AgentStart_ended":
			Characters[GetCharacterIndex("TQ_Char1")].location = "None";
		break;

// <-- Starting quest

// Trophy quest -->
		case "AgentQuest_setup":	// Triggered by dialog with a governor
			sld = CharacterFromID("TQ_Captain1");
			sld.fantomtype = "war";
			sld.quest.officertype = OFFIC_TYPE_CAPNAVY;
			SetRandomNameToCharacter(sld);
			SetModelfromID(sld, Nations[sti(sld.nation)].fantomModel.m0);
			SetCharacterShipLocation(sld, PChar.quest.agentquest.port1);

			NPChar = CharacterFromID("TQ_Char1");
			SetModelfromID(NPChar, "Sailor15");
			NPChar.nation = PChar.quest.agentquest.enemy_nation;
			NPChar.Dialog.Filename = "Agent_docker_dialog.c";
			if (PChar.sex == "woman") NPChar.Dialog.CurrentNode = "help_you";
			else NPChar.Dialog.CurrentNode = "busy";
			SetRandomNameToCharacter(NPChar);
			switch(sti(NPChar.nation))
			{
				case ENGLAND:  NPChar.greeting = "Gr_redmond Citizen"; break;
				case FRANCE:   NPChar.greeting = "Gr_falaise de fleur citizen"; break;
				case SPAIN:    NPChar.greeting = "Gr_isla muelle citizen"; break;
				case PIRATE:   NPChar.greeting = "Gr_QC Citizen"; break;
				case HOLLAND:  NPChar.greeting = "Gr_Douwesen Citizen"; break;
				case PORTUGAL: NPChar.greeting = "Gr_Conceicao Citizen"; break;
				NPChar.greeting = "Gr_Herald";
			}
			LAi_SetStayType(NPChar);


			sld = LAi_CreateFantomCharacter(false, 0, true, true, 0.0, "9R_Carp", "reload", "reload1");
			PlaceCharacter(sld, "reload");
			sld.nation = GetServedNation();
			sld.Dialog.Filename = "Agent_soldier_dialog.c";
			sld.Dialog.CurrentNode = "Q_arrives";
			SetRandomNameToCharacter(sld);
			LAi_SetActorType(sld);
			LAi_ActorDialog(sld, PChar, "", 5.0, 5.0);

			switch(PChar.quest.agentquest.port1)
			{
				case "Tortuga_port":
           				Locations[FindLocation("Tortuga_port")].vcskip = true;
					PChar.quest.agentquest.docker_location.group = "officers";
					PChar.quest.agentquest.docker_location.locator = "reload1_1";
					PChar.quest.agentquest.docker_depart.locator = "reload4_back";
					PChar.quest.agentquest.ship.locator = "reload1_back";
					PChar.quest.agentquest.ship.reload_disable1 = "l1";
					PChar.quest.agentquest.ship.reload_disable2 = "l2";
				break;

				case "Cuba_port":
           				Locations[FindLocation("Cuba_port")].vcskip = true;
					PChar.quest.agentquest.docker_location.group = "goto";
					PChar.quest.agentquest.docker_location.locator = "goto_45";
					PChar.quest.agentquest.docker_depart.locator = "reload_2_city";
					PChar.quest.agentquest.ship.locator = "sea_1_back";
					PChar.quest.agentquest.ship.reload_disable1 = "l2";
					PChar.quest.agentquest.ship.reload_disable2 = "l3";
					PChar.quest.agentquest.ship.reload_disable3 = "l4";
					PChar.quest.agentquest.ship.reload_disable4 = "l5";
				break;

				case "Antigua_port":
					PChar.quest.agentquest.docker_location.group = "reload";
					PChar.quest.agentquest.docker_location.locator = "reload2_back";
					PChar.quest.agentquest.docker_depart.locator = "reload_2_city";
					PChar.quest.agentquest.ship.locator = "sea_2_back";
					PChar.quest.agentquest.ship.reload_disable1 = "l3";
					PChar.quest.agentquest.ship.reload_disable2 = "l5";
				break;

				case "Marigot_port":
					PChar.quest.agentquest.docker_location.group = "goto";
					PChar.quest.agentquest.docker_location.locator = "goto13";
					PChar.quest.agentquest.docker_depart.locator = "Falaise_de_fleur_location_01_02";
					PChar.quest.agentquest.ship.locator = "sea_back";
					PChar.quest.agentquest.ship.reload_disable1 = "l4";
					PChar.quest.agentquest.ship.reload_disable2 = "l5";
				break;

				case "Willemstad_port":
					PChar.quest.agentquest.docker_location.group = "goto";
					PChar.quest.agentquest.docker_location.locator = "goto13";
					PChar.quest.agentquest.docker_depart.locator = "Falaise_de_fleur_location_01_02";
					PChar.quest.agentquest.ship.locator = "sea_back";
					PChar.quest.agentquest.ship.reload_disable1 = "l3";
					PChar.quest.agentquest.ship.reload_disable2 = "l5";
				break;

				case "REDMOND_PORT":
					PChar.quest.agentquest.docker_location.group = "goto";
					PChar.quest.agentquest.docker_location.locator = "goto_33";
					PChar.quest.agentquest.docker_depart.locator = "reload_2_city";
					PChar.quest.agentquest.ship.locator = "sea_2_back";
					PChar.quest.agentquest.ship.reload_disable1 = "l2";
					PChar.quest.agentquest.ship.reload_disable2 = "l3";
					PChar.quest.agentquest.ship.reload_disable3 = "l4";
					PChar.quest.agentquest.ship.reload_disable4 = "l5";
				break;

				case "Eleuthera_Port":
					PChar.quest.agentquest.docker_location.group = "goto";
					PChar.quest.agentquest.docker_location.locator = "goto8";
					PChar.quest.agentquest.docker_depart.locator = "reload4_back";
					PChar.quest.agentquest.ship.locator = "reload1_back";
					PChar.quest.agentquest.ship.reload_disable1 = "l1";
					PChar.quest.agentquest.ship.reload_disable2 = "l2";
				break;

				case "QC_port":
					PChar.quest.agentquest.docker_location.group = "officers";
					PChar.quest.agentquest.docker_location.locator = "reload2_1";
					PChar.quest.agentquest.docker_depart.locator = "reload3_back";
					PChar.quest.agentquest.ship.locator = "reload2";
					PChar.quest.agentquest.ship.reload_disable1 = "l2";
					PChar.quest.agentquest.ship.reload_disable2 = "l3";
				break;

				case "Muelle_port":
					PChar.quest.agentquest.docker_location.group = "goto";
					PChar.quest.agentquest.docker_location.locator = "goto7";
					PChar.quest.agentquest.docker_depart.locator = "reload2";
					PChar.quest.agentquest.ship.locator = "reload1_back";
					PChar.quest.agentquest.ship.reload_disable1 = "l2";
					PChar.quest.agentquest.ship.reload_disable2 = "l3";
					PChar.quest.agentquest.ship.reload_disable3 = "l4";
					PChar.quest.agentquest.ship.reload_disable4 = "l5";
				break;
			}
			if (CheckAttribute(PChar, "quest.agentquest.docker_location.locator"))
			{
				ChangeCharacterAddressGroup(NPChar, PChar.quest.agentquest.port1, PChar.quest.agentquest.docker_location.group, PChar.quest.agentquest.docker_location.locator);
			}

			PChar.quest.AgentQuest_dismiss_ship.win_condition.l1 = "location";
			PChar.quest.AgentQuest_dismiss_ship.win_condition.l1.location = PChar.quest.agentquest.port1;
			PChar.quest.AgentQuest_dismiss_ship.win_condition = "AgentQuest_dismiss_ship";
			LAi_SetLoginTime(CharacterFromID("TQ_Char1"), 0.0, 24.0);
			LAi_SetLoginTime(CharacterFromID("TQ_Char2"), 0.0, 24.0);

			Preprocessor_AddQuestData("ship", PChar.quest.agentquest.enemy_ship.name);
			Preprocessor_AddQuestData("governor", GetMyFullName(CharacterFromID(PChar.quest.agentquest.governor)));
			Preprocessor_AddQuestData("town", FindTownName(PChar.quest.agentquest.original_town));
			Preprocessor_AddQuestData("island", FindIslandName(GetIslandIDFromTown(PChar.quest.agentquest.original_town)));
			Preprocessor_AddQuestData("nation", XI_ConvertString(GetNationDescByType(sti(PChar.quest.agentquest.enemy_nation))));
			Preprocessor_AddQuestData("port1", FindTownName(PChar.quest.agentquest.town1));
			Preprocessor_AddQuestData("island1", FindIslandName(GetIslandIDFromTown(PChar.quest.agentquest.town1)));
			SetQuestHeader("Agent_Quest");
			AddQuestRecord("Agent_Quest", 1);
			Preprocessor_Remove("island1");
			Preprocessor_Remove("port1");
			Preprocessor_Remove("nation");
			Preprocessor_Remove("island");
			Preprocessor_Remove("town");
			Preprocessor_Remove("governor");
			Preprocessor_Remove("ship");
		break;

		case "AgentQuest_dismiss_ship":
			cidx = -1;
			for (i=OFFICER_MAX-1; i>0; i--)
			{
				if(GetOfficersIndex(PChar, i) != -1)
				{
					cidx = GetOfficersIndex(PChar, i);
				}
			}
			if (cidx == -1)
			{
				cidx = GetCharacterIndex("TQ_Char2");
				NPChar = GetCharacter(cidx);
				SetModelfromID(NPChar, "pirat2");
				NPChar.nation = GetServedNation();
				SetRandomNameToCharacter(NPChar);
				PlaceCharacter(NPChar, "officers");
			}
			else
			{
				NPChar = GetCharacter(cidx);
				StoreDialog(NPChar);
			}
			PChar.quest.agentquest.dismisser = NPChar.id;
			NPChar.Dialog.Filename = "Agent_crewman_dialog.c";
			NPChar.Dialog.CurrentNode = "dismiss_ship";
			LAi_SetActorType(PChar);
			LAi_ActorWaitDialog(PChar, NPChar);
			LAi_SetActorType(NPChar);
			LAi_ActorDialog(NPChar, PChar, "AgentQuest_dismiss_ship2", 10.0, 10.0);
		break;

		case "AgentQuest_dismiss_ship2":
			NPChar = CharacterFromID(PChar.quest.agentquest.dismisser);
			if (PChar.quest.agentquest.dismisser != "TQ_Char2")
			{
				RestoreDialog(NPChar);
			}
			else NPChar.location = "none";
			LAi_SetOfficerType(NPChar);
			LAi_SetPlayerType(PChar);

			Preprocessor_AddQuestData("locationfromsea", FindTownName(PChar.quest.agentquest.original_town));
			Preprocessor_AddQuestData("ship", PChar.quest.agentquest.enemy_ship.name);
			AddQuestRecord("Agent_Quest", 2);
			Preprocessor_Remove("ship");
			Preprocessor_Remove("locationfromsea");
		break;

		case "AgentQuest_ready_to_board":	// Triggered by dialog with "TQ_Char1"
			NPChar = CharacterFromID("TQ_Char1");
			if (PChar.sex == "woman")
			{
				LAi_SetStayType(NPChar);
			}
			else
			{
				LAi_SetActorType(NPChar);
				LAi_ActorGoToLocation(NPChar, "reload", PChar.quest.agentquest.docker_depart.locator, "none", "", "", "", -1);
			}
			NPChar.location = "none";

			DisableFastTravel(true);
			bQuestDisableSeaEnter = true;
			for (i=1; i<=4; i++)
			{
				if (CheckAttribute(PChar, "quest.agentquest.ship.reload_disable"+i))
				{
					attr = GetAttribute(PChar, "quest.agentquest.ship.reload_disable"+i);
					Locations[FindLocation(PChar.location)].reload.(attr).disable = 1;
				}
			}
			if (PChar.location == "Tortuga_port" || PChar.location == "Cuba_port")
			{
				DeleteAttribute(&Locations[FindLocation(PChar.location)],"vcskip");
			}
			PChar.quest.AgentQuest_board_ship.win_condition.l1 = "locator";
			PChar.quest.AgentQuest_board_ship.win_condition.l1.location = PChar.location;
			PChar.quest.AgentQuest_board_ship.win_condition.l1.locator_group = "reload";
			PChar.quest.AgentQuest_board_ship.win_condition.l1.locator = PChar.quest.agentquest.ship.locator;
			PChar.quest.AgentQuest_board_ship.win_condition = "AgentQuest_board_ship";
		break;

		case "AgentQuest_board_ship":
			sld = CharacterFromID("TQ_Soldier1");
			sld.nation = PChar.quest.agentquest.enemy_nation;
			SetRandomNameToCharacter(sld);
			SetModelfromID(sld, Nations[sti(sld.nation)].fantomModel.m2);
			sld.Dialog.Filename = "Agent_soldier_dialog.c";
			sld = CharacterFromID("TQ_Soldier2");
			sld.nation = PChar.quest.agentquest.enemy_nation;
			SetRandomNameToCharacter(sld);
			SetModelfromID(sld, Nations[sti(sld.nation)].fantomModel.m4);
			sld.Dialog.Filename = "Agent_soldier_dialog.c";
			DoQuestReloadToLocation(GetCharacterShipQDeck(CharacterFromID("TQ_Captain1")), "goto", "goto4", "AgentQuest_board_ship2");
		break;

		case "AgentQuest_board_ship2":
			for (i=1; i<=4; i++)
			{
				if (CheckAttribute(PChar, "quest.agentquest.ship.reload_disable"+i))
				{
					attr = GetAttribute(PChar, "quest.agentquest.ship.reload_disable"+i);
					Locations[FindLocation(PChar.location)].reload.(attr).disable = 0;
				}
			}

			StorePassengers(PChar.id);
			for (i=1; i<COMPANION_MAX; i++)
			{
				cc = GetCompanionIndex(PChar,i);
				attr = "companion" + i;
				if (cc > 0)
				{
					PChar.quest.AgentQuest.(attr) = characters[cc].id;
					if (HasSubStr(PChar.quest.AgentQuest.(attr), "Enc_Officer")) LAi_StoreFantom(CharacterFromId(PChar.quest.AgentQuest.(attr))); // Prevent character from being overwritten by another "Enc_Officer"
					RemoveCharacterCompanion(PChar, Characters[cc]);
				}
				else PChar.quest.AgentQuest.(attr) = "*NULL*";
			}
			ExchangeCharacterShip(PChar, CharacterFromID("TQ_Char1"));	// Store player's ship by giving it to a generic quest character
			GiveShip2Character(PChar, PChar.quest.agentquest.enemy_ship.type, PChar.quest.agentquest.enemy_ship.name, -1, sti(PChar.quest.agentquest.enemy_nation), true, true);
			PChar.isnotcaptain = true;

			PlaceCharacter(CharacterFromID("TQ_Soldier1"), "goto");
			PlaceCharacter(CharacterFromID("TQ_Soldier2"), "goto");
			LAi_SetActorType(CharacterFromID("TQ_Soldier1"));
			LAi_SetActorType(CharacterFromID("TQ_Soldier2"));
			LAi_ActorTurnToCharacter(CharacterFromID("TQ_Soldier1"), PChar);
			LAi_ActorTurnToCharacter(CharacterFromID("TQ_Soldier2"), PChar);
			LAi_SetActorType(PChar);
			LAi_ActorTurnToCharacter(PChar, CharacterFromID("TQ_Soldier1"));
			Characters[GetCharacterIndex("TQ_Soldier1")].dialog.currentnode = "challenge";
			LAi_ActorWaitDialog(PChar, CharacterFromID("TQ_Soldier1"));
			LAi_ActorDialog(CharacterFromID("TQ_Soldier1"), PChar, "AgentQuest_to_hold", 10.0, 10.0);
		break;

		case "AgentQuest_to_hold":
			LAi_SetPlayerType(PChar);
			Locations[FindLocation("Quest_Hold1")].reload.l1.disable = 1;				// Lock link from hold to deck
			Locations[FindLocation("Quest_Hold1")].models.always.locators = "hold_l_GR_agent";
			DoQuestReloadToLocation("Quest_Hold1", "reload", "reload1", "AgentQuest_to_hold2");
		break;

		case "AgentQuest_to_hold2":
			LAi_SetActorType(PChar);
			LAi_ActorTurnToLocator(PChar, "goto", "goto1");
			LAi_QuestDelay("AgentQuest_to_hold3", 0.5);
		break;

		case "AgentQuest_to_hold3":
			LAi_SetActorType(PChar);
			Pchar.dialog.CurrentNode = "Agent_hide_in_hold";
			LAi_ActorSelfDialog(Pchar, "player_back");
		break;

		case "AgentQuest_hide_in_hold":	// Triggered by self dialog
			Pchar.quest.AgentQuest_hide_in_hold2.win_condition.l1 = "locator";
			Pchar.quest.AgentQuest_hide_in_hold2.win_condition.l1.location = "Quest_Hold1";
			Pchar.quest.AgentQuest_hide_in_hold2.win_condition.l1.locator_group = "box";
			Pchar.quest.AgentQuest_hide_in_hold2.win_condition.l1.locator = "box1";
			Pchar.quest.AgentQuest_hide_in_hold2.win_condition = "AgentQuest_hide_in_hold2";
		break;

		case "AgentQuest_hide_in_hold2":
			DoQuestReloadToLocation("Quest_Hold1", "goto", "goto1", "AgentQuest_guard_searches_hold");
		break;

		case "AgentQuest_guard_searches_hold":
			Preprocessor_AddQuestData("ship", PChar.quest.agentquest.enemy_ship.name);
			AddQuestRecord("Agent_Quest", 3);
			Preprocessor_Remove("ship");
			LAi_SetActorType(PChar);
			LAi_ActorSetSitMode(PChar);
			LAi_QuestDelay("AgentQuest_guard_searches_hold2", 2.0);
		break;

		case "AgentQuest_guard_searches_hold2":
			sld = CharacterFromID("TQ_Soldier1");
			ChangeCharacterAddressGroup(sld, "Quest_Hold1", "reload", "reload1");
			LAi_SetActorType(sld);
			LAi_ActorGoToLocator(sld, "rld", "loc2", "AgentQuest_guard_searches_hold2a", 3.0);
		break;

		case "AgentQuest_guard_searches_hold2a":
			sld = CharacterFromID("TQ_Soldier1");
			LAi_SetActorType(sld);
			LAi_ActorTurnToLocator(sld, "goto", "goto1");
			LAi_ActorAnimation(sld, "idle_6", "AgentQuest_guard_searches_hold_check", -1.0);
		break;

		case "AgentQuest_guard_searches_hold_check":
			sld = CharacterFromID("TQ_Soldier1");
			LAi_SetActorType(sld);
			if (CalcCharacterSkill(PChar, "sneak") >= (rand(5) + rand(5))) LAi_QuestDelay("AgentQuest_guard_searches_hold3", 0.0);
			else LAi_QuestDelay("AgentQuest_guard_sees_you", 0.0);
//LAi_QuestDelay("AgentQuest_guard_searches_hold3", 0.0);	// Unconditional continued search, for testing
//LAi_QuestDelay("AgentQuest_guard_sees_you", 0.0);	// Unconditional challenge, for testing
		break;

		case "AgentQuest_guard_searches_hold3":
			LAi_ActorGoToLocator(CharacterFromID("TQ_Soldier1"), "rld", "aloc2", "AgentQuest_guard_searches_hold3a", 3.0);
		break;

		case "AgentQuest_guard_searches_hold3a":
			sld = CharacterFromID("TQ_Soldier1");
			LAi_SetActorType(sld);
			LAi_ActorTurnToLocator(sld, "box", "gunpowder_1");
			LAi_ActorAnimation(sld, "idle_4", "AgentQuest_guard_searches_hold4", -1.0);
		break;

		case "AgentQuest_guard_searches_hold4":
			LAi_ActorGoToLocator(CharacterFromID("TQ_Soldier1"), "rld", "loc1", "AgentQuest_guard_searches_hold4a", 3.0);
		break;

		case "AgentQuest_guard_searches_hold4a":
			sld = CharacterFromID("TQ_Soldier1");
			LAi_SetActorType(sld);
			LAi_ActorTurnToLocator(sld, "reload", "reload2");
			LAi_ActorAnimation(sld, "idle_5", "AgentQuest_guard_leaves_hold", -1.0);
		break;

		case "AgentQuest_guard_leaves_hold":
			AddQuestRecord("Agent_Quest", 5);
			sld = CharacterFromID("TQ_Soldier1");
			LAi_SetActorType(sld);
			LAi_ActorGoToLocation(sld, "reload", "reload1", "none", "", "", "",0.0);
			LAi_QuestDelay("AgentQuest_wait_till_arrived", 0.0);
		break;

		case "AgentQuest_guard_sees_you":
			sld = CharacterFromID("TQ_Soldier1");
			LAi_SetActorType(sld);
			sld.dialog.currentnode = "discovered";
			LAi_ActorWaitDialog(PChar, sld);
			LAi_ActorDialog(sld, PChar, "AgentQuest_fight_in_hold", 10.0, 10.0);
		break;

		case "AgentQuest_fight_in_hold":
			LAi_SetPlayerType(PChar);
			ChangeCharacterAddressGroup(PChar, "Quest_Hold1", "goto", "goto2");
			sld = CharacterFromID("TQ_Soldier1");
			LAi_group_MoveCharacter(sld, "HOLD_SOLDIERS");
			LAi_group_FightGroups("HOLD_SOLDIERS", LAI_GROUP_PLAYER, true);
			LAi_group_SetCheck("HOLD_SOLDIERS", "AgentQuest_hold_fight_over");
		break;

		case "AgentQuest_hold_fight_over":
			LAi_SetActorType(PChar);
			Pchar.dialog.CurrentNode = "Agent_dispose_of_body";
			LAi_ActorSelfDialog(PChar, "player_back");
		break;

		case "AgentQuest_hide_body":		// Triggered by self dialog
			ChangeCharacterAddress(CharacterFromID("TQ_Soldier1"), "None", "");
			DoQuestReloadToLocation("Quest_Hold1", "goto", "goto2", "AgentQuest_body_hidden");
		break;

		case "AgentQuest_body_hidden":
			LAi_SetActorType(PChar);
			LAi_ActorTurnToLocator(PChar, "goto", "goto1");
			Pchar.dialog.CurrentNode = "Agent_body_hidden";
			LAi_ActorSelfDialog(PChar, "AgentQuest_back_to_hiding");
		break;

		case "AgentQuest_back_to_hiding":
			AddQuestRecord("Agent_Quest", 4);
			DoQuestReloadToLocation("Quest_Hold1", "goto", "goto1", "AgentQuest_back_to_hiding2");
		break;

		case "AgentQuest_back_to_hiding2":
			LAi_SetActorType(PChar);
			LAi_ActorSetSitMode(PChar);
			LAi_QuestDelay("AgentQuest_wait_till_arrived", 0.0);
		break;

		case "AgentQuest_wait_till_arrived":
			WaitDate("", 0, 0, 10 + rand(5), 0, 0);
			LAi_Fade("AgentQuest_ship_arrives", "AgentQuest_player_stands_up");
		break;

		case "AgentQuest_ship_arrives":
			SetCharacterShipLocation(CharacterFromID("TQ_Captain1"), PChar.quest.agentquest.port2);

			Pchar.quest.AgentQuest_back_to_deck.win_condition.l1 = "locator";
			Pchar.quest.AgentQuest_back_to_deck.win_condition.l1.location = "Quest_Hold1";
			Pchar.quest.AgentQuest_back_to_deck.win_condition.l1.locator_group = "reload";
			Pchar.quest.AgentQuest_back_to_deck.win_condition.l1.locator = "reload1";
			Pchar.quest.AgentQuest_back_to_deck.win_condition = "AgentQuest_back_to_deck";

			if (PChar.sex == "man") LAi_QuestDelay("AgentQuest_docker_in_hold", 10.0);
		break;

		case "AgentQuest_player_stands_up":
			AddQuestRecord("Agent_Quest", 6);
			LAi_SetPlayerType(PChar);
			DoQuestReloadToLocation("Quest_Hold1", "goto", "goto2", "_");
		break;

		case "AgentQuest_docker_in_hold":
			if (PChar.location == "Quest_Hold1")
			{
				PChar.quest.agentquest.leave_with_docker = true;
				NPChar = CharacterFromID("TQ_Char2");
				SetModelfromID(NPChar, "Sailor10");
				NPChar.nation = PChar.quest.agentquest.enemy_nation;
				SetRandomNameToCharacter(NPChar);
				ChangeCharacterAddressGroup(NPChar, "Quest_Hold1", "reload", "reload1");
				LAi_SetActorType(PChar);
				LAi_ActorWaitDialog(PChar, NPChar);
				LAi_SetActorType(NPChar);
				NPChar.Dialog.Filename = "Agent_docker_dialog.c";
				NPChar.Dialog.CurrentNode = "not_expecting_anyone";
				LAi_ActorDialog(NPChar, PChar, "AgentQuest_back_to_deck", 10.0, 10.0);
			}
		break;

		case "AgentQuest_back_to_deck":
			DoQuestReloadToLocation(GetCharacterShipQDeck(CharacterFromID("TQ_Captain1")), "reload", "reload3", "AgentQuest_back_to_deck2");
		break;

		case "AgentQuest_to_deck_with_docker":
			ChangeCharacterAddressGroup(CharacterFromID("TQ_Char2"), GetCharacterShipQDeck(CharacterFromID("TQ_Captain1")), "goto", "goto2");
			DoQuestReloadToLocation(GetCharacterShipQDeck(CharacterFromID("TQ_Captain1")), "reload", "reload3", "AgentQuest_back_to_deck2");
		break;

		case "AgentQuest_back_to_deck2":
			DeleteAttribute(PChar, "Ship");
			PChar.Ship.Type = SHIP_NOTUSED_TYPE_NAME;
			PChar.Ship.Name = "";

			if (CheckAttribute(PChar, "quest.agentquest.leave_with_docker"))
			{
				NPChar = CharacterFromID("TQ_Char2");
				ChangeCharacterAddressGroup(NPChar, GetCharacterShipQDeck(CharacterFromID("TQ_Captain1")), "goto", "goto2");
				LAi_SetActorType(NPChar);
				LAi_ActorFollowEverywhere(NPChar, "", 10.0);
			}
			Locations[FindLocation("Quest_Hold1")].reload.l1.disable = 0;				// Unlock link from hold to deck
			Locations[FindLocation("Quest_Hold1")].models.always.locators = "hold_ld";		// Hold locators back to normal
			StartQuestMovie(true, false, false);
			TrackQuestMovie("start","AgentQuest_back_to_deck2");
			ChangeCharacterAddressGroup(CharacterFromID("TQ_Soldier2"), GetCharacterShipQDeck(CharacterFromID("TQ_Captain1")), "goto", "goto4");
			PlaceCharacter(CharacterFromID("TQ_Soldier1"), "goto");
			LAi_SetActorType(CharacterFromID("TQ_Soldier1"));
			LAi_SetActorType(CharacterFromID("TQ_Soldier2"));
			LAi_ActorTurnToCharacter(CharacterFromID("TQ_Soldier1"), PChar);
			LAi_ActorTurnToCharacter(CharacterFromID("TQ_Soldier2"), PChar);
			LAi_SetActorType(PChar);
			LAi_ActorTurnToCharacter(PChar, CharacterFromID("TQ_Soldier2"));
			Characters[GetCharacterIndex("TQ_Soldier2")].dialog.currentnode = "second_challenge";
			LAi_ActorWaitDialog(PChar, CharacterFromID("TQ_Soldier2"));
			LAi_ActorDialog(CharacterFromID("TQ_Soldier2"), PChar, "", 10.0, 10.0);			// Exits to "AgentQuest_deck_fight" or "AgentQuest_leave_ship"

			PChar.quest.AgentQuest_got_ship.win_condition.l1 = "ship_class";
			PChar.quest.AgentQuest_got_ship.win_condition.l1.operation = ">=";
			PChar.quest.AgentQuest_got_ship.win_condition.l1.class = "1";
			PChar.quest.AgentQuest_got_ship.win_condition = "AgentQuest_got_ship";
		break;

		case "AgentQuest_got_ship":
			if (!CheckQuestAttribute("agentquest", "smuggler_ship"))
			{
				bQuestDisableSeaEnter = false;
				SetCharacterShipLocation(PChar, PChar.quest.agentquest.port2);
				PChar.location.from_sea = PChar.quest.agentquest.port2;
				SetFleetInTown(GetTownIDFromLocID(PChar.location.from_sea), "PChar");
				DeleteAttribute(PChar, "isnotcaptain");
			}
		break;

		case "AgentQuest_deck_fight":
			LAi_SetPlayerType(PChar);
			LAi_group_MoveCharacter(CharacterFromID("TQ_Soldier1"), "HOLD_SOLDIERS");
			LAi_group_MoveCharacter(CharacterFromID("TQ_Soldier2"), "HOLD_SOLDIERS");
			LAi_group_FightGroups("HOLD_SOLDIERS", LAI_GROUP_PLAYER, true);
			LAi_group_SetCheck("HOLD_SOLDIERS", "AgentQuest_leave_ship");
		break;

		case "AgentQuest_leave_ship":
			EndQuestMovie();TrackQuestMovie("end","AgentQuest_leave_ship");
			LAi_SetPlayerType(PChar);
			switch(PChar.quest.agentquest.port2)
			{
				case "QC_port":
					PChar.quest.agentquest.docker_location.group = "officers";
					PChar.quest.agentquest.docker_location.locator = "reload1_1";
					PChar.quest.agentquest.docker_depart.locator = "reload3_back";
					PChar.quest.agentquest.ship.locator = "reload1";
					if (CheckAttribute(PChar, "quest.agentquest.leave_with_docker"))
					{
						Build_at("QC_port", "box", "", -2.2, 2.2, 6.7, 0.3, "HOLD_SOLDIERS")
					}
					PChar.quest.agentquest.soldier1.id = "TQ_Soldier3";
					PChar.quest.agentquest.soldier2.id = "TQ_Soldier4";
					PChar.quest.agentquest.soldier1.location = "QC_town";
					PChar.quest.agentquest.soldier1.group = "officers";
					PChar.quest.agentquest.soldier1.locator = "reload10_1";
					PChar.quest.agentquest.soldier2.location = "QC_town";
					PChar.quest.agentquest.soldier2.group = "officers";
					PChar.quest.agentquest.soldier2.locator = "reload10_2";
					for(i = 3; i<=4; i++)
					{
						sld = CharacterFromID("TQ_Soldier" + i);
						sld.nation = PIRATE;
						SetRandomNameToCharacter(sld);
						attr = "m" + (rand(5)+1);
						SetModelfromID(sld, Nations[PIRATE].fantomModel.(attr));
						sld.Dialog.Filename = "Agent_soldier_dialog.c";
						sld.Dialog.CurrentNode = "pirate_guard";
						GiveSoldierWeapon(sld, PIRATE);
						LAi_group_MoveCharacter(sld, "QC_SOLDIERS");
						ChangeCharacterAddressGroup(sld, "QC_town", "officers", "reload10_"+(i-2));
					}
					PChar.quest.agentquest.residence.district = "QC_town";
					PChar.quest.agentquest.residence.entrance = "reload10";
					PChar.quest.agentquest.residence.inside = "QC_Residence";
					PChar.quest.agentquest.target = "box1";
				break;

				case "Muelle_port":
					PChar.quest.agentquest.docker_location.group = "officers";
					PChar.quest.agentquest.docker_location.locator = "reload3_1";
					PChar.quest.agentquest.docker_depart.locator = "reload2";
					PChar.quest.agentquest.ship.locator = "reload3_back";
					if (CheckAttribute(PChar, "quest.agentquest.leave_with_docker"))
					{
						Build_at("Muelle_port", "box", "", -7.0, 3.5, -14.8, 0.3, "HOLD_SOLDIERS")
					}
					PChar.quest.agentquest.soldier1.id = "spain_soldier_07";
					PChar.quest.agentquest.soldier2.id = "spain_soldier_08";
					PChar.quest.agentquest.soldier1.location = "Muelle_town_04";
					PChar.quest.agentquest.soldier1.group = "goto";
					PChar.quest.agentquest.soldier1.locator = "goto1";
					PChar.quest.agentquest.soldier2.location = "Muelle_town_04";
					PChar.quest.agentquest.soldier2.group = "goto";
					PChar.quest.agentquest.soldier2.locator = "goto40";
					PChar.quest.agentquest.residence.district = "Muelle_town_04";
					PChar.quest.agentquest.residence.entrance = "reload5";
					PChar.quest.agentquest.residence.inside = "Muelle_Residence";
					PChar.quest.agentquest.target = "box1";
				break;

				case "REDMOND_PORT":
					PChar.quest.agentquest.docker_location.group = "officers";
					PChar.quest.agentquest.docker_location.locator = "sea_1_1";
					PChar.quest.agentquest.docker_depart.locator = "reload_2_city";
					PChar.quest.agentquest.ship.locator = "sea_1_back";
					if (CheckAttribute(PChar, "quest.agentquest.leave_with_docker"))
					{
						Build_at("REDMOND_PORT", "box", "", 65.46, 5.07, -56.47, 0.3, "HOLD_SOLDIERS")
					}
					PChar.quest.agentquest.soldier1.id = "Eng_Soldier_5";
					PChar.quest.agentquest.soldier2.id = "Eng_Soldier_6";
					PChar.quest.agentquest.soldier3.id = "Eng_soldier_31";
					PChar.quest.agentquest.soldier4.id = "Eng_soldier_32";
					PChar.quest.agentquest.soldier1.location = "Redmond_town_01";
					PChar.quest.agentquest.soldier1.group = "goto";
					PChar.quest.agentquest.soldier1.locator = "soldier1";
					PChar.quest.agentquest.soldier2.location = "Redmond_town_01";
					PChar.quest.agentquest.soldier2.group = "goto";
					PChar.quest.agentquest.soldier2.locator = "soldier2";
					PChar.quest.agentquest.soldier3.location = "Redmond_town_01";
					PChar.quest.agentquest.soldier3.group = "goto";
					PChar.quest.agentquest.soldier3.locator = "goto11";
					PChar.quest.agentquest.soldier4.location = "Redmond_town_01";
					PChar.quest.agentquest.soldier4.group = "goto";
					PChar.quest.agentquest.soldier4.locator = "goto25";
					PChar.quest.agentquest.residence.district = "Redmond_Town_01";
					PChar.quest.agentquest.residence.entrance = "door_5";
					PChar.quest.agentquest.residence.inside = "Redmond_residence";
					PChar.quest.agentquest.target = "box1";
				break;

				case "PoPrince_Port":
					PChar.quest.agentquest.docker_location.group = "officers";
					PChar.quest.agentquest.docker_location.locator = "reload2_1";
					PChar.quest.agentquest.docker_depart.locator = "reload1";
					PChar.quest.agentquest.ship.locator = "reload2_back";
					if (CheckAttribute(PChar, "quest.agentquest.leave_with_docker"))
					{
						Build_at("PoPrince_Port", "box", "", -7.85, 3.61, 76.46, 0.3, "HOLD_SOLDIERS")
					}
					PChar.quest.agentquest.soldier1.id = "PoPrince_soldier_06";
					PChar.quest.agentquest.soldier1.location = "PoPrince_town";
					PChar.quest.agentquest.soldier1.group = "goto";
					PChar.quest.agentquest.soldier1.locator = "goto22";
					PChar.quest.agentquest.residence.district = "PoPrince_town";
					PChar.quest.agentquest.residence.entrance = "reload14";
					PChar.quest.agentquest.residence.inside = "PoPrince_townhall";
					PChar.quest.agentquest.target = "box1";
				break;

				case "Douwesen_port":
					PChar.quest.agentquest.docker_location.group = "officers";
					PChar.quest.agentquest.docker_location.locator = "reload2_1";
					PChar.quest.agentquest.docker_depart.locator = "reload3";
					PChar.quest.agentquest.ship.locator = "reload2_back";
					if (CheckAttribute(PChar, "quest.agentquest.leave_with_docker"))
					{
						Build_at("Douwesen_port", "box", "", 33.68, 3.65, -71.3, 0.3, "HOLD_SOLDIERS")
					}
					PChar.quest.agentquest.soldier1.id = "Dou_soldier_5";
					PChar.quest.agentquest.soldier2.id = "Dou_soldier_6";
					PChar.quest.agentquest.soldier1.location = "Douwesen_town";
					PChar.quest.agentquest.soldier1.group = "goto";
					PChar.quest.agentquest.soldier1.locator = "goto28";
					PChar.quest.agentquest.soldier2.location = "Douwesen_town";
					PChar.quest.agentquest.soldier2.group = "goto";
					PChar.quest.agentquest.soldier2.locator = "goto29";
					PChar.quest.agentquest.residence.district = "Douwesen_town";
					PChar.quest.agentquest.residence.entrance = "reload15";
					PChar.quest.agentquest.residence.inside = "Douwesen_townhall";
					PChar.quest.agentquest.target = "box1";
				break;

				case "Conceicao_port":
					PChar.quest.agentquest.docker_location.group = "officers";
					PChar.quest.agentquest.docker_location.locator = "reload2_1";
					PChar.quest.agentquest.docker_depart.locator = "reload1";
					PChar.quest.agentquest.ship.locator = "reload2_back";
					if (CheckAttribute(PChar, "quest.agentquest.leave_with_docker"))
					{
						Build_at("Conceicao_port", "box", "", -7.85, 3.61, 76.46, 0.3, "HOLD_SOLDIERS")
					}
					PChar.quest.agentquest.soldier1.id = "Con_soldier_5";
					PChar.quest.agentquest.soldier2.id = "Con_soldier_6";
					PChar.quest.agentquest.soldier1.location = "Conceicao_town";
					PChar.quest.agentquest.soldier1.group = "goto";
					PChar.quest.agentquest.soldier1.locator = "goto21";
					PChar.quest.agentquest.soldier2.location = "Conceicao_town";
					PChar.quest.agentquest.soldier2.group = "goto";
					PChar.quest.agentquest.soldier2.locator = "goto22";
					PChar.quest.agentquest.residence.district = "Conceicao_town";
					PChar.quest.agentquest.residence.entrance = "reload14";
					PChar.quest.agentquest.residence.inside = "Conceicao_townhall";
					PChar.quest.agentquest.target = "box1";
				break;

				case "Alice_Port":
					PChar.quest.agentquest.docker_location.group = "officers";
					PChar.quest.agentquest.docker_location.locator = "reload61_1";
					PChar.quest.agentquest.docker_depart.locator = "reload4_back";
					PChar.quest.agentquest.ship.locator = "reload61";
					if (CheckAttribute(PChar, "quest.agentquest.leave_with_docker"))
					{
						Build_at("Alice_Port", "box", "", 1.5, 0.87, 25.5, 0.3, "HOLD_SOLDIERS")
					}
					PChar.quest.agentquest.soldier1.id = "Al_soldier_19";
					PChar.quest.agentquest.soldier2.id = "Al_soldier_443";
					PChar.quest.agentquest.soldier1.location = "Alice_Port";
					PChar.quest.agentquest.soldier1.group = "soldiers";
					PChar.quest.agentquest.soldier1.locator = "soldier1";
					PChar.quest.agentquest.soldier2.location = "Alice_Port";
					PChar.quest.agentquest.soldier2.group = "soldiers";
					PChar.quest.agentquest.soldier2.locator = "soldier2";
					PChar.quest.agentquest.residence.district = "Alice_Port";
					PChar.quest.agentquest.residence.entrance = "reload3_back";
					PChar.quest.agentquest.residence.inside = "Alice_townhall";
				break;
			}
			DoQuestReloadToLocation(PChar.quest.agentquest.port2, "reload", PChar.quest.agentquest.ship.locator, "AgentQuest_prepare_find_plans");
		break;

		case "AgentQuest_prepare_find_plans":
			Preprocessor_AddQuestData("ship", PChar.quest.agentquest.enemy_ship.name);
			Preprocessor_AddQuestData("town", FindTownName(GetCurrentTownID()));
			if (PChar.quest.agentquest.port2 == "QC_port") AddQuestRecord("Agent_Quest", 8);
			else AddQuestRecord("Agent_Quest", 7);
			Preprocessor_Remove("town");
			Preprocessor_Remove("ship");
			DisableFastTravel(false);
			if (CheckAttribute(PChar, "quest.agentquest.leave_with_docker"))
			{
				NPChar = CharacterFromID("TQ_Char2");
				ChangeCharacterAddressGroup(NPChar, PChar.quest.agentquest.port2, PChar.quest.agentquest.docker_location.group, PChar.quest.agentquest.docker_location.locator);
				LAi_SetActorType(NPChar);
				LAi_type_Actor_Reset(NPChar);
				NPChar.Dialog.CurrentNode = "job_done";
				LAi_ActorDialog(NPChar, PChar, "", 10.0, 10.0);
				cc = FindLocation(PChar.quest.agentquest.port2);
				for(i = 1; i<=MAXBUILDINGS; i++)
				{
					attr = "building."+i+".aigroup"
					if (CheckAttribute(Locations[cc],attr) && Locations[cc].(attr) == "HOLD_SOLDIERS")
					{
						DeleteAttribute(&Locations[cc], "building." + i);	// Function "Building_delete" fails to remove the crate
					}
				}
			}
			LAi_group_SetLookRadius(GetCurrentSoldierGroup(), LAI_GROUP_GRD_LOOK/2);
			LAi_group_SetHearRadius(GetCurrentSoldierGroup(), LAI_GROUP_GRD_HEAR/2);
			LAi_group_SetSayRadius(GetCurrentSoldierGroup(), LAI_GROUP_GRD_SAY);

			PChar.quest.AgentQuest_breakin.win_condition.l1 = "Time";			// To break into the residence requires:
			PChar.quest.AgentQuest_breakin.win_condition.l1.time = DAY_TIME_NIGHT;		// night-time,
			PChar.quest.AgentQuest_breakin.win_condition.l2 = "item";			// you have a lockpick,
			PChar.quest.AgentQuest_breakin.win_condition.l2.character = PChar.id;
			PChar.quest.AgentQuest_breakin.win_condition.l2.item = "lockpick";
			PChar.quest.AgentQuest_breakin.win_condition.l3 = "locator";			// and you're standing at the door.
			PChar.quest.AgentQuest_breakin.win_condition.l3.location = PChar.quest.agentquest.residence.district;
			PChar.quest.AgentQuest_breakin.win_condition.l3.locator_group = "reload";
			PChar.quest.AgentQuest_breakin.win_condition.l3.locator = PChar.quest.agentquest.residence.entrance;
			for(i=1; i<=4; i++)								// And any nearby guards must be dead.
			{
				if (CheckAttribute(PChar, "quest.agentquest.soldier" + i))
				{
					level = "l" + (i+3);
					attr = GetAttribute(PChar, "quest.agentquest.soldier" + i + ".id");
					PChar.quest.AgentQuest_breakin.win_condition.(level) = "NPC_Death";
					PChar.quest.AgentQuest_breakin.win_condition.(level).character = attr;
				}
			}
			PChar.quest.AgentQuest_breakin.win_condition = "AgentQuest_breakin";
		break;

		case "AgentQuest_docker2_leaves":
			PChar.quest.AgentQuest_back_to_deck.over = "yes";
			NPChar = CharacterFromID("TQ_Char2");
			LAi_SetActorType(NPChar);
			LAi_ActorGoToLocation(NPChar, "reload", PChar.quest.agentquest.docker_depart.locator, "none", "", "", "", -1);
			NPChar.location = "none";
		break;

		case "AgentQuest_breakin":
			PlaySound("PEOPLE\lockpick2.wav");
			LAi_QuestDelay("AgentQuest_breakin2", 2.0);
			NPChar = CharacterFromID(GetTownGovernorID(GetCurrentTownID()));
			NPChar.location = "none";
			if (PChar.quest.agentquest.residence.inside == "PoPrince_townhall") LAi_SetLoginTime(CharacterFromID("Contre-Amirale"), 6.0, 21.99);
			if (PChar.quest.agentquest.residence.inside == "Muelle_Residence") LAi_SetLoginTime(CharacterFromID("Joaquin Da Saldanha"), 6.0, 21.99);
		break;

		case "AgentQuest_breakin2":
			DoQuestReloadToLocation(PChar.quest.agentquest.residence.inside, "reload", "reload1", "AgentQuest_breakin3");
		break;

		case "AgentQuest_breakin3":
			StartQuestMovie(true, true, false);TrackQuestMovie("start","AgentQuest_breakin3");
			DisableFastTravel(true);
			PChar.quest.AgentQuest_foundit.win_condition.l1 = "locator";
			PChar.quest.AgentQuest_foundit.win_condition.l1.location = PChar.quest.agentquest.residence.inside;
			PChar.quest.AgentQuest_foundit.win_condition.l1.locator_group = "box";
			PChar.quest.AgentQuest_foundit.win_condition.l1.locator = "box1";
			PChar.quest.AgentQuest_foundit.win_condition = "AgentQuest_foundit";
		break;

		case "AgentQuest_foundit":
			LAi_SetActorType(PChar);
			LAi_QuestDelay("AgentQuest_foundit2", 2.0);
		break;

		case "AgentQuest_foundit2":
			EndQuestMovie();TrackQuestMovie("end","AgentQuest_foundit2");
			LAi_SetPlayerType(PChar);
			GiveItem2Character(PChar, "plans_copy");
			Characters[GetCharacterIndex(PChar.quest.agentquest.governor)].dialog.currentnode = "agent_quest_return";
			Preprocessor_AddQuestData("town", FindTownName(PChar.quest.agentquest.original_town));
			Preprocessor_AddQuestData("nation", XI_ConvertString(GetNationDescByType(sti(PChar.quest.agentquest.enemy_nation))));
			AddQuestRecord("Agent_Quest", 9);
			Preprocessor_Remove("nation");
			Preprocessor_Remove("town");

			for(i=1; i<=4; i++)
			{
				if (CheckAttribute(PChar, "quest.agentquest.soldier" + i))
				{
					sld = CharacterFromID(GetAttribute(PChar, "quest.agentquest.soldier" + i + ".id"));
					ChangeCharacterAddress(sld, "None", "");
				}
			}
			PChar.quest.AgentQuest_breakout.win_condition.l1 = "location";
			PChar.quest.AgentQuest_breakout.win_condition.l1.location = PChar.quest.agentquest.residence.district;
			PChar.quest.AgentQuest_breakout.win_condition = "AgentQuest_breakout";
		break;

		case "AgentQuest_breakout":
			LAi_group_SetLookRadius(GetCurrentSoldierGroup(), LAI_GROUP_GRD_LOOK/2);
			LAi_group_SetHearRadius(GetCurrentSoldierGroup(), LAI_GROUP_GRD_HEAR/2);
			LAi_group_SetSayRadius(GetCurrentSoldierGroup(), LAI_GROUP_GRD_SAY);
			LAi_group_SetRelation(GetCurrentSoldierGroup(), LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);

			attr = PChar.quest.agentquest.original_island;
			i=sti(Locations[0].IslandsList.(attr).begin);
			PChar.quest.agentquest.return_port = "";
			while (i<sti(Locations[0].IslandsList.(attr).end) && PChar.quest.agentquest.return_port == "")
			{
				if(CheckAttribute(&locations[i],"townsack") && locations[i].townsack==PChar.quest.agentquest.original_town)
				{
					if(CheckAttribute(&locations[i],"id") && HasSubStr(locations[i].id,"port"))
					{
						PChar.quest.agentquest.return_port = locations[i].id;
						PChar.quest.agentquest.return_port_name = FindTownName(PChar.quest.agentquest.original_town) + " " + TranslateString("", "SeaPort");
					}
				}
				i++;
			}
			iForceDetectionFalseFlag = 1;	// Should make shopkeeper and shipyard owner refuse to do business.  Also means that if you do buy a ship and sail away, the fort will attack.
			PChar.quest.agentquest = "find_smuggler";

			PChar.quest.AgentQuest_escape_to_sea.win_condition.l1 = "MapEnter";
			PChar.quest.AgentQuest_escape_to_sea.win_condition = "AgentQuest_escape_to_sea";

			PChar.quest.AgentQuest_reset_soldiers_and_governor.win_condition.l1 = "ExitFromLocation";
			PChar.quest.AgentQuest_reset_soldiers_and_governor.win_condition.l1.location = PChar.location;
			PChar.quest.AgentQuest_reset_soldiers_and_governor.win_condition = "AgentQuest_reset_soldiers_and_governor";
		break;

		case "AgentQuest_reset_soldiers_and_governor":
			DisableFastTravel(false);
			LAi_group_SetLookRadius(GetCurrentSoldierGroup(), LAI_GROUP_GRD_LOOK);
			LAi_group_SetHearRadius(GetCurrentSoldierGroup(), LAI_GROUP_GRD_HEAR);
			LAi_group_SetSayRadius(GetCurrentSoldierGroup(), LAI_GROUP_GRD_SAY);
			NPChar = CharacterFromID(GetTownGovernorID(GetCurrentTownID()));
			NPChar.location = PChar.quest.agentquest.residence.inside;
			if (PChar.quest.agentquest.residence.inside == "PoPrince_townhall") LAi_RemoveLoginTime(CharacterFromID("Contre-Amirale"));
			if (PChar.quest.agentquest.residence.inside == "Muelle_Residence") LAi_SetLoginTime(CharacterFromID("Joaquin Da Saldanha"), 0.0, 24.0);
			for(i=1; i<=4; i++)
			{
				if (CheckAttribute(PChar, "quest.agentquest.soldier" + i))
				{
					sld = CharacterFromID(GetAttribute(PChar, "quest.agentquest.soldier"+i+".id"));
					ChangeCharacterAddressGroup(sld, GetAttribute(PChar, "quest.agentquest.soldier"+i+".location"), GetAttribute(PChar, "quest.agentquest.soldier"+i+".group"), GetAttribute(PChar, "quest.agentquest.soldier"+i+".locator"));
				}
			}
		break;

		case "AgentQuest_escape_to_sea":
			PChar.quest.agentquest = "escaped_to_sea";
			HoistFlag(GetServedNation());
			iForceDetectionFalseFlag = 0;
			if (!CheckQuestAttribute("agentquest", "smuggler_ship"))	// You escaped to sea without the help of the smugglers
			{
				DeleteAttribute(PChar, "isnotcaptain");			// so now you're a captain again
			}
		break;

		case "AgentQuest_Met_Smuggler_Agent":		// Triggered by dialog with smuggler agent
			PChar.quest.agentquest = "found_smuggler";
			Preprocessor_AddQuestData("town", FindTownName(PChar.quest.agentquest.original_town));
			Preprocessor_AddQuestData("shore", Locations[FindLocation(PChar.quest.agentquest.smuggler_beach)].name));
			AddQuestRecord("Agent_Quest", 10);
			Preprocessor_Remove("shore");
			Preprocessor_Remove("town");

			PChar.quest.AgentQuest_smuggler_beach_early.win_condition.l1 = "location";
			PChar.quest.AgentQuest_smuggler_beach_early.win_condition.l1.location = PChar.quest.agentquest.smuggler_beach;
			PChar.quest.AgentQuest_smuggler_beach_early.win_condition.l2 = "Time";
			PChar.quest.AgentQuest_smuggler_beach_early.win_condition.l2.time = DAY_TIME_NIGHT;
			PChar.quest.AgentQuest_smuggler_beach_early.win_condition = "AgentQuest_smuggler_beach_early";

			PChar.quest.AgentQuest_smuggler_goto_beach.win_condition.l1 = "Timer";
			PChar.quest.AgentQuest_smuggler_goto_beach.win_condition.l1.date.day = GetAddingDataDay(0, 0, 1);
			PChar.quest.AgentQuest_smuggler_goto_beach.win_condition.l1.date.month = GetAddingDataMonth(0, 0, 1);
			PChar.quest.AgentQuest_smuggler_goto_beach.win_condition.l1.date.year = GetAddingDataYear(0, 0, 1);
			PChar.quest.AgentQuest_smuggler_goto_beach.win_condition.l2 = "Time";
			PChar.quest.AgentQuest_smuggler_goto_beach.win_condition.l2.time = DAY_TIME_NIGHT;
			PChar.quest.AgentQuest_smuggler_goto_beach.win_condition = "AgentQuest_smuggler_goto_beach";

			PChar.quest.AgentQuest_smuggler_too_late.win_condition.l1 = "Timer";
			PChar.quest.AgentQuest_smuggler_too_late.win_condition.l1.date.day = GetAddingDataDay(0, 0, 3);
			PChar.quest.AgentQuest_smuggler_too_late.win_condition.l1.date.month = GetAddingDataMonth(0, 0, 3);
			PChar.quest.AgentQuest_smuggler_too_late.win_condition.l1.date.year = GetAddingDataYear(0, 0, 3);
			PChar.quest.AgentQuest_smuggler_too_late.win_condition = "AgentQuest_smuggler_too_late";
		break;

		case "AgentQuest_smuggler_beach_early":
			LAi_SetActorType(PChar);
			PChar.dialog.CurrentNode = "Agent_early_for_smuggler";
			LAi_ActorSelfDialog(PChar, "player_back");
		break;

		case "AgentQuest_smuggler_goto_beach":
			PChar.quest.AgentQuest_smuggler_beach_early.over = "yes";
			bQuestDisableSeaEnter = true;
			Preprocessor_AddQuestData("shore", Locations[FindLocation(PChar.quest.agentquest.smuggler_beach)].name));
			AddQuestRecord("Agent_Quest", 11);
			Preprocessor_Remove("shore");
			NPChar = CharacterFromID("TQ_Char2");
			NPChar.nation = PIRATE;
			SetModelFromID(NPChar, GetRandomModelForTypeExSubCheck(1, "Smugglers", "", PIRATE));
			SetRandomNameToCharacter(NPChar);
			if (NPChar.sex == "woman") NPChar.greeting = "Gr_f_officer";
			else NPChar.greeting = "Gr_camilo machado"; // was "Gr_Smuggler_OnShore" which is identical
			GiveShip2Character(NPChar,"Sloop4","Little Gem",-1,PIRATE,true,true);
			SetCharacterShipLocation(NPChar, PChar.quest.agentquest.smuggler_beach);
			LAi_SetStayType(NPChar);
			NPChar.Dialog.Filename = "Agent_crewman_dialog.c";
			NPChar.Dialog.Currentnode = "smuggler_meet";
			switch(PChar.quest.agentquest.smuggler_beach)
			{
				case "QC_Shore1": ChangeCharacterAddressGroup(NPChar, PChar.quest.agentquest.smuggler_beach, "goto", "citizen05"); break;
				case "Muelle_shore": ChangeCharacterAddressGroup(NPChar, PChar.quest.agentquest.smuggler_beach, "goto", "goto17"); break;
				case "Redmond_shore_02": ChangeCharacterAddressGroup(NPChar, PChar.quest.agentquest.smuggler_beach, "goto", "goto7"); break;
				case "Hispaniola_shore_02": ChangeCharacterAddressGroup(NPChar, PChar.quest.agentquest.smuggler_beach, "goto", "locator10"); break;
				case "Douwesen_shore_02": ChangeCharacterAddressGroup(NPChar, PChar.quest.agentquest.smuggler_beach, "goto", "goto1"); break;
				case "Conceicao_shore_01": ChangeCharacterAddressGroup(NPChar, PChar.quest.agentquest.smuggler_beach, "goto", "locator10"); break;
				case "Eleuthera_shore": ChangeCharacterAddressGroup(NPChar, PChar.quest.agentquest.smuggler_beach, "goto", "goto17"); break;
			}
		break;

		case "AgentQuest_smuggler_too_late":
			Preprocessor_AddQuestData("island", FindIslandName(FindIslandByLocation(PChar.location)));
			AddQuestRecord("Agent_Quest", 14);
			Preprocessor_Remove("island");
			ChangeSmugglerLiking(PChar, -10);
			ChangeCharacterAddress(CharacterFromID("TQ_Char2"), "None", "");
			SetCharacterShipLocation(CharacterFromID("TQ_Char2"), "None");
			bQuestDisableSeaEnter = false;
		break;

		case "AgentQuest_smuggler_depart":	// Triggered by dialog with smuggler on shore
			PChar.quest.AgentQuest_smuggler_too_late.over = "yes";
			PChar.quest.AgentQuest_got_ship.over = "yes";
			bQuestDisableSeaEnter = false;
			PChar.quest.agentquest = "smuggler_ship";
			GiveShip2Character(PChar,"Sloop4","Little Gem",-1,PIRATE,true,true);
			HoistFlag(GetServedNation());
			SafePortLeave(sti(PChar.quest.agentquest.enemy_nation), false);
			iForceDetectionFalseFlag = 0;
			SetCharacterShipLocation(PChar, PChar.quest.agentquest.smuggler_beach);
			if (sti(PChar.quest.agentquest.smuggler_fare) != 0)
			{
				NPChar = CharacterFromID("TQ_Char2");
				LAi_SetActorType(NPChar);
				LAi_ActorFollowEverywhere(NPChar, "", 10.0);
				LAi_SetImmortal(NPChar, true);
			}

			Preprocessor_AddQuestData("governor", GetMyFullName(CharacterFromID(PChar.quest.agentquest.governor)));
			Preprocessor_AddQuestData("port", PChar.quest.agentquest.return_port_name);
			AddQuestRecord("Agent_Quest", 12);
			Preprocessor_Remove("port");
			Preprocessor_Remove("governor");

			PChar.quest.Agentquest_smuggler_arrived.win_condition.l1 = "location";
			PChar.quest.Agentquest_smuggler_arrived.win_condition.l1.location = PChar.quest.agentquest.return_port;
			PChar.quest.Agentquest_smuggler_arrived.win_condition = "Agentquest_smuggler_arrived";
			LAi_QuestDelay("AgentQuest_smuggler_depart2", 0.0);
		break;

		case "AgentQuest_smuggler_depart2":
			switch(PChar.quest.agentquest.smuggler_beach)
			{
				case "QC_Shore1":
					PChar.Ship.Pos.save.x = -1344.263;	// Needed by "WhrWeather.c" otherwise it generates error messages
					PChar.Ship.Pos.save.z = 108;		// Probably harmless, but better not to cause errors!
					QuestToSeaLogin_PrepareLoc("QuebradasCostillas", "reload", "reload_3", false);
				break;
				case "Muelle_shore":
					PChar.Ship.Pos.save.x = -117.897;
					PChar.Ship.Pos.save.z = 652.173;
					QuestToSeaLogin_PrepareLoc("IslaMuelle", "reload", "reload_3", false);
				break;
				case "Redmond_shore_02":
					PChar.Ship.Pos.save.x = -910.59;
					PChar.Ship.Pos.save.z = -1058.522;
					QuestToSeaLogin_PrepareLoc("Redmond", "reload", "reload_3", false);
				break;
				case "Hispaniola_shore_02":
					PChar.Ship.Pos.save.x = -1317.39;
					PChar.Ship.Pos.save.z = -835.661;
					QuestToSeaLogin_PrepareLoc("Hispaniola", "reload", "reload_4", false);
				break;
				case "Douwesen_shore_02":
					PChar.Ship.Pos.save.x = 246.265;
					PChar.Ship.Pos.save.z = 633.757;
					QuestToSeaLogin_PrepareLoc("Douwesen", "reload", "reload_3", false);
				break;
				case "Conceicao_shore_01":
					PChar.Ship.Pos.save.x = -1383.991;
					PChar.Ship.Pos.save.z = -1079.602;
					QuestToSeaLogin_PrepareLoc("Conceicao", "reload", "reload_2", false);
				break;
				case "Eleuthera_shore":
					PChar.Ship.Pos.save.x = 1234.656;
					PChar.Ship.Pos.save.z = -1621.9;
					QuestToSeaLogin_PrepareLoc("QuebradasCostillas", "reload", "reload_4", false);
				break;
			}
			QuestToSeaLogin_Launch();
			SetCharacterShipLocation(CharacterFromID("TQ_Char2"), "None");
		break;

		case "Agentquest_smuggler_arrived":
			bQuestDisableSeaEnter = true;
			if (sti(PChar.quest.agentquest.smuggler_fare) != 0)
			{
				NPChar = CharacterFromID("TQ_Char2");
				if (NPChar.location != PChar.location) PlaceCharacter(NPChar, "goto");
				LAi_SetActorType(PChar);
				LAi_ActorTurnToCharacter(PChar, NPChar);
				LAi_SetActorType(NPChar);
				NPChar.dialog.currentnode = "smuggler_pay_up";
				LAi_ActorWaitDialog(PChar, NPChar);
				LAi_ActorDialog(NPChar, PChar, "Agentquest_smuggler_arrived2", 10.0, 10.0);
			}
			else ChangeSmugglerLiking(PChar, 15);
		break;

		case "Agentquest_smuggler_arrived2":
			LAi_SetPlayerType(PChar);
			LAi_SetActorType(CharacterFromID("TQ_Char2"));
			LAi_ActorFollowEverywhere(CharacterFromID("TQ_Char2"), "", 10.0);
		break;

		case "Agentquest_prepare_pay_smuggler":
			DisableFastTravel(true);
			PChar.quest.AgentQuest_pay_smuggler.win_condition.l1 = "ExitFromLocation";
			PChar.quest.AgentQuest_pay_smuggler.win_condition.l1.location = PChar.location;
			PChar.quest.AgentQuest_pay_smuggler.win_condition = "AgentQuest_pay_smuggler";
		break;

		case "AgentQuest_pay_smuggler":
			NPChar = CharacterFromID("TQ_Char2");
			if (NPChar.location != PChar.location) PlaceCharacter(NPChar, "goto");
			LAi_SetActorType(PChar);
			LAi_ActorTurnToCharacter(PChar, NPChar);
			LAi_SetActorType(NPChar);
			NPChar.dialog.currentnode = "smuggler_payoff";
			LAi_ActorWaitDialog(PChar, NPChar);
			LAi_ActorDialog(NPChar, PChar, "AgentQuest_pay_smuggler2", 10.0, 10.0);
		break;

		case "AgentQuest_pay_smuggler2":
			DisableFastTravel(false);
			LAi_SetPlayerType(PChar);
			NPChar = CharacterFromID("TQ_Char2");
			NPChar.location = "none";
			LAi_SetCitizenType(NPChar);
			ChangeSmugglerLiking(PChar, 15);
		break;

		case "Agentquest_return_ships_and_officers":
			Preprocessor_AddQuestData("governor", GetMyFullName(CharacterFromID(PChar.quest.agentquest.governor)));
			Preprocessor_AddQuestData("nation", XI_ConvertString(GetNationDescByType(sti(PChar.quest.agentquest.enemy_nation))));
			AddQuestRecord("Agent_Quest", 13);
			Preprocessor_Remove("nation");
			Preprocessor_Remove("governor");
			CloseQuestHeader("Agent_Quest");
			RestorePassengers(PChar.id);
			DeleteAttribute(PChar, "isnotcaptain");
			bQuestDisableSeaEnter = false;
			PChar.quest.AgentQuest_got_ship.over = "yes";

			cc = 0;
			for (i=1; i<COMPANION_MAX; i++)
			{
				attr = "quest.agentquest.companion" + i;
				if (GetAttribute(PChar, attr) != "*NULL*" && GetAttribute(PChar, attr) != "-1") cc++;
			}
			PChar.quest.agentquest.original_companions_number = cc;

			for (i=1; i<COMPANION_MAX; i++)
			{
				attr = "companion" + i;
				if (PChar.quest.AgentQuest.(attr) != "*NULL*")
				{
					cidx = GetCharacterIndex(PChar.quest.AgentQuest.(attr));
					SetCompanionIndex(PChar,-1, cidx)
					if (HasSubStr(PChar.quest.AgentQuest.(attr), "Enc_Officer")) LAi_UnStoreFantom(CharacterFromID(PChar.quest.AgentQuest.(attr))); // Cancel protection
				}
			}

			NPChar = CharacterFromID("TQ_Char1");
			ExchangeCharacterShip(PChar, CharacterFromID("TQ_Char1"));

			if (!CheckQuestAttribute("agentquest", "smuggler_ship") && GetCompanionQuantity(PChar) < COMPANION_MAX)	// You got here without help from the smugglers, which means you acquired a ship of your own.
			{
				iPassenger = -1;
				if (GetPassengersQuantity(PChar) > 0)
				{
					for(i = 0; i < GetPassengersQuantity(PChar); i++)
					{
						cidx = GetPassenger(PChar, i);
						NPChar = GetCharacter(cidx);
						if (CheckAttribute(NPChar, "id") && GetRemovable(NPChar) && !IsPrisoner(NPChar) && !IsCompanion(NPChar) && NPChar.id != PChar.id)
						{
							iPassenger = cidx;
						}
					}
				}
				if (iPassenger > 0)
				{
					NPChar = GetCharacter(iPassenger);
					if (IsOfficer(NPChar)) RemoveOfficersIndex(PChar, iPassenger);
					RemovePassenger(PChar, NPChar);
					ExchangeCharacterShip(NPChar, CharacterFromID("TQ_Char1"));
					SetCompanionIndex(PChar, -1, iPassenger);
				}
			}
		break;

		case "Agentquest_refused":
			PChar.quest.agentquest = "refused";
			if (ENABLE_CHEATMODE) LAi_QuestDelay("Agentquest_refused_reset", 0.0);
			else
			{
				PChar.quest.Agentquest_refused_reset.win_condition.l1 = "Timer";
				PChar.quest.Agentquest_refused_reset.win_condition.l1.date.day = GetAddingDataDay(0, 1, 0);
				PChar.quest.Agentquest_refused_reset.win_condition.l1.date.month = GetAddingDataMonth(0, 1, 0);
				PChar.quest.Agentquest_refused_reset.win_condition.l1.date.year = GetAddingDataYear(0, 1, 0);
				PChar.quest.Agentquest_refused_reset.win_condition = "PChar.quest.Agentquest_refused_reset";
			}
		break;

		case "Agentquest_refused_reset":
			DeleteAttribute(PChar, "quest.agentquest");
		break;
// <-- Trophy quest

///////////////////////////////////////////////////////////////
//    Social Climber: GR
///////////////////////////////////////////////////////////////

		case "ClimberQuest_timers":
			PChar.quest.climberquest.status = "waiting_first_reply";
			PChar.quest.Climberquest_destgov_ready.win_condition.l1 = "Timer";
			PChar.quest.Climberquest_destgov_ready.win_condition.l1.date.day = GetAddingDataDay(0, 0, 2);
			PChar.quest.Climberquest_destgov_ready.win_condition.l1.date.month = GetAddingDataMonth(0, 0, 2);
			PChar.quest.Climberquest_destgov_ready.win_condition.l1.date.year = GetAddingDataYear(0, 0, 2);
			PChar.quest.Climberquest_destgov_ready.win_condition = "ClimberQuest_destgov_ready";

			PChar.quest.ClimberQuest_destgov_timeup.win_condition.l1 = "Timer";
			PChar.quest.ClimberQuest_destgov_timeup.win_condition.l1.date.day = GetAddingDataDay(0, 0, 7);
			PChar.quest.ClimberQuest_destgov_timeup.win_condition.l1.date.month = GetAddingDataMonth(0, 0, 7);
			PChar.quest.ClimberQuest_destgov_timeup.win_condition.l1.date.year = GetAddingDataYear(0, 0, 7);
			PChar.quest.ClimberQuest_destgov_timeup.win_condition = "ClimberQuest_destgov_timeup";
		break;

		case "ClimberQuest_timer_for_reset":
			PChar.quest.Climberquest_reset.win_condition.l1 = "Timer";
			PChar.quest.Climberquest_reset.win_condition.l1.date.day = GetAddingDataDay(0, 1, 0);
			PChar.quest.Climberquest_reset.win_condition.l1.date.month = GetAddingDataMonth(0, 1, 0);
			PChar.quest.Climberquest_reset.win_condition.l1.date.year = GetAddingDataYear(0, 1, 0);
			PChar.quest.Climberquest_reset.win_condition = "Climberquest_reset";
		break;

		case "Climberquest_reset":
			NPChar = CharacterFromID(PChar.quest.climberquest.sourcegov);
			if (GetAttribute(NPChar, "quest.climber_quest.failed") == "rejected") DeleteAttribute(NPChar, "quest.climber_quest.failed");
			DeleteQuestAttribute("climberquest");
			DeleteQuestHeader("Social_Climber_Quest");
		break;

		case "ClimberQuest_set_rival":
			NPChar = CharacterFromID("TQ_Char1");
			NPChar.nation = sti(PChar.quest.climberquest.rivalnation);
			SetModelFromID(NPChar, GetRandomModelForTypeNation(-1, "Rich_Citizens", sti(NPChar.nation)));
			SetRandomNameToCharacter(NPChar);
			if(NPChar.sex == "woman")
			{
				NPChar.sound_type = "female_citizen";
				NPChar.greeting = "Gr_Arabella Silehard";
			}
			else
			{
				switch(sti(NPChar.nation))
				{
					case ENGLAND:	NPChar.greeting = "Gr_Robert Christopher Silehard"; LAi_group_MoveCharacter(NPChar, "ENGLAND_CITIZENS"); break;
					case FRANCE:	NPChar.greeting = "Gr_joseph claude le moigne"; LAi_group_MoveCharacter(NPChar, "FRANCE_CITIZENS"); break;
					case SPAIN:	NPChar.greeting = "Gr_christofor manuel de alencar"; LAi_group_MoveCharacter(NPChar, "SPAIN_CITIZENS"); break;
					case PIRATE:	NPChar.greeting = "Gr_Isenbrandt Jurcksen"; LAi_group_MoveCharacter(NPChar, "QC_CITIZENS"); break;
					case HOLLAND:	NPChar.greeting = "Gr_Reynard Grueneveldt"; LAi_group_MoveCharacter(NPChar, "DOUWESEN_CITIZENS"); break;
					case PORTUGAL:	NPChar.greeting = "Gr_Jacinto Arcibaldo Barreto"; LAi_group_MoveCharacter(NPChar, "CONCEICAO_CITIZENS"); break;
					NPChar.greeting = "Gr_Geffrey Bampfylde"; LAi_group_MoveCharacter(NPChar, "FRANCE_CITIZENS");
				}
			}
			NPChar.Dialog.Filename = "Climber_rival_dialog.c";
			
			NPChar = CharacterFromID("TQ_Char2");
			NPChar.nation = sti(PChar.quest.climberquest.rivalnation);
			SetModelFromID(NPChar, GetRandomModelForTypeNation(-1, "Upper_Citizens", sti(NPChar.nation)));
			SetRandomNameToCharacter(NPChar);
			if(NPChar.sex == "woman")
			{
				NPChar.sound_type = "female_citizen";
				NPChar.greeting = "Gr_Desiree' Muerte";
			}
			else
			{
				NPChar.greeting = "Gr_Gregor Samsa";
			}
			NPChar.Dialog.Filename = "Climber_rival_dialog.c";
		break;

		case "ClimberQuest_destgov_ready":
			PChar.quest.climberquest.status = "first_reply_ready";
			Characters[GetCharacterIndex(PChar.quest.climberquest.destgov)].dialog.currentnode = "climber_quest_reply_ready";
			if(GetDifficulty() <= DIFFICULTY_MARINER)
			{
				Preprocessor_AddQuestData("destgov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.destgov)));
				AddQuestRecord("Social_Climber_Quest", 3);
				Preprocessor_Remove("destgov");
			}
		break;

		case "ClimberQuest_destgov_timeup":
			PChar.quest.climberquest.status = "rival_got_there_first";
			Characters[GetCharacterIndex(PChar.quest.climberquest.destgov)].dialog.currentnode = "climber_quest_too_late";
		break;

		case "ClimberQuest_failed_too_late":
			if (FindTownName(PChar.quest.climberquest.rivaltown) == "") Preprocessor_AddQuestData("rival", GetNationNameByType(sti(PChar.quest.climberquest.rivalnation)));
			else Preprocessor_AddQuestData("rival", FindTownName(PChar.quest.climberquest.rivaltown));
			Preprocessor_AddQuestData("destgov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.destgov)));
			Preprocessor_AddQuestData("sourcegov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.sourcegov)));
			AddQuestRecord("Social_Climber_Quest", 4);
			Preprocessor_Remove("sourcegov");
			Preprocessor_Remove("destgov");
			Preprocessor_Remove("rival");
			Characters[GetCharacterIndex(PChar.quest.climberquest.sourcegov)].dialog.currentnode = "climber_quest_report_too_late";
		break;

		case "ClimberQuest_take_reply":
			PChar.quest.ClimberQuest_destgov_timeup.over = "yes";
			PChar.quest.climberquest.status = "got_first_reply";
			GiveItem2Character(PChar, "trade_reply");
			Preprocessor_AddQuestData("destgov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.destgov)));
			Preprocessor_AddQuestData("sourcegov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.sourcegov)));
			Preprocessor_AddQuestData("He", FirstLetterUp(XI_ConvertString(GetMyPronounSubj(CharacterFromID(PChar.quest.climberquest.destgov)))));
			AddQuestRecord("Social_Climber_Quest", 6);
			Preprocessor_Remove("He");
			Preprocessor_Remove("sourcegov");
			Preprocessor_Remove("destgov");
			Characters[GetCharacterIndex(PChar.quest.climberquest.sourcegov)].dialog.currentnode = "climber_quest_deliver_reply";
		break;

		case "ClimberQuest_take_second_letter":
			PChar.quest.climberquest.status = "second_letter";
			GiveItem2Character(PChar, "trade_offer");
			Preprocessor_AddQuestData("destgov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.destgov)));
			Preprocessor_AddQuestData("sourcegov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.sourcegov)));
			Preprocessor_AddQuestData("money", PChar.quest.climberquest.deal_money);
			AddQuestRecord("Social_Climber_Quest", 7);
			Preprocessor_Remove("money");
			Preprocessor_Remove("sourcegov");
			Preprocessor_Remove("destgov");
		break;

		case "ClimberQuest_failed_no_pay":
			Characters[GetCharacterIndex(PChar.quest.climberquest.sourcegov)].dialog.currentnode = "climber_quest_report_nopay";
		break;

		case "ClimberQuest_deal_agreed":
			PlayStereoSound("INTERFACE\took_item.wav");
			AddMoneyToCharacter(PChar, -1*sti(PChar.quest.climberquest.deal_money));

			if (CheckAttribute(PChar, "quest.climberquest.profit"))
			{
				Preprocessor_AddQuestData("destgov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.destgov)));
				Preprocessor_AddQuestData("him", XI_ConvertString(GetMyPronounObj(CharacterFromID(PChar.quest.climberquest.destgov))));
				Preprocessor_AddQuestData("sourcegov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.sourcegov)));
				Preprocessor_AddQuestData("money", PChar.quest.climberquest.deal_money);
				AddQuestRecord("Social_Climber_Quest", 8);
				Preprocessor_Remove("money");
				Preprocessor_Remove("sourcegov");
				Preprocessor_Remove("him");
				Preprocessor_Remove("destgov");
			}

			PChar.quest.climberquest.status = "waiting_to_finalise";
			PChar.quest.Climberquest_deal_ready.win_condition.l1 = "Timer";
			PChar.quest.Climberquest_deal_ready.win_condition.l1.date.day = GetAddingDataDay(0, 0, 1);
			PChar.quest.Climberquest_deal_ready.win_condition.l1.date.month = GetAddingDataMonth(0, 0, 1);
			PChar.quest.Climberquest_deal_ready.win_condition.l1.date.year = GetAddingDataYear(0, 0, 1);
			PChar.quest.Climberquest_deal_ready.win_condition = "ClimberQuest_deal_ready";

			bQuestDisableSeaEnter = true;	// No sailing away until deal is done and duel scene is set up
		break;

		case "ClimberQuest_deal_ready":
			PChar.quest.climberquest.status = "contract_ready";
			Characters[GetCharacterIndex(PChar.quest.climberquest.destgov)].dialog.currentnode = "climber_quest_take_contract";
			LAi_QuestDelay("ClimberQuest_deal_ready2", 0.5);
		break;

		case "ClimberQuest_deal_ready2":
			AddQuestRecord("Social_Climber_Quest", 9);
		break;

		case "ClimberQuest_got_contract":
			PChar.quest.climberquest.status = "got_contract";
			GiveItem2Character(PChar, "trade_contract");

			PChar.quest.climberquest.soldiergroup = GetSoldiersGroup(GetTownNation(PChar.quest.climberquest.desttown));
			for (i = 1; i <= 4; i++)
			{
				sld = CharacterFromID("TQ_Soldier"+i);
				sld.nation = GetTownNation(PChar.quest.climberquest.desttown);
				SetRandomNameToCharacter(sld);
				GiveSoldierWeapon(sld, sti(sld.nation));
				SetModelFromID(sld, LAi_SoldierModel(sti(sld.nation)));
			}
			sld = CharacterFromID("TQ_Soldier1");
			attr = GetAttribute(Nations[sti(sld.nation)], "fantomModel.m0");
			if (HasSubstr(attr, "offic") || HasSubstr(attr, "USA_lut")) SetModelFromID(sld, attr);

			GetCharacterPos(CharacterFromID(PChar.quest.climberquest.destgov), &locx, &locy, &locz);
			PChar.quest.ClimberQuest.governor_locator = LAi_FindNearestFreeLocator("goto", locx, locy, locz);
			PChar.quest.ClimberQuest.player_location = PChar.location;
			PChar.quest.ClimberQuest.player_group = GetAttribute(PChar, "location.group");
			PChar.quest.ClimberQuest.player_locator = GetAttribute(PChar, "location.locator");
			if (PChar.quest.ClimberQuest.player_group == "-1") PChar.quest.ClimberQuest.player_group = "reload";
			if (PChar.quest.ClimberQuest.player_locator == "-1")
			{
				PChar.quest.ClimberQuest.player_group = "reload";
				PChar.quest.ClimberQuest.player_locator = "reload1";
			}

			Locations[FindLocation(PChar.location.from_sea)].vcskip = true;
			DisableFastTravel(true);
			PChar.quest.ClimberQuest_ambush.win_condition.l1 = "location";
			PChar.quest.ClimberQuest_ambush.win_condition.l1.location = PChar.location.from_sea;
			PChar.quest.ClimberQuest_ambush.win_condition = "ClimberQuest_ambush";
		break;

		case "ClimberQuest_ambush":
			LAi_LocationFightDisable(&Locations[FindLocation(PChar.location)], true);
			LAi_SetFightMode(PChar, false);
			NPChar = CharacterFromID("TQ_Char2");
			PlaceCharacter(NPChar, "goto");
			if (ENABLE_WEAPONSMOD)
			{
				GiveItem2Character(NPChar, "blade13+3");
				EquipCharacterByItem(NPChar, "blade13+3");
			}
			else
			{
				GiveItem2Character(NPChar, "blade13");
				EquipCharacterByItem(NPChar, "blade13");
			}
			StartQuestMovie(true, false, false); TrackQuestMovie("start","ClimberQuest_ambush");
			LAi_SetActorType(NPChar);
			NPChar.dialog.currentnode = "challenge";
			LAi_ActorDialog(NPChar, PChar, "", 20.0, 20.0);
		break;

		case "ClimberQuest_fight":	// Triggered by dialog with "TQ_Char2"
			DeleteAttribute(Locations[FindLocation(PChar.location.from_sea)], "vcskip");
			LAi_LocationFightDisable(&Locations[FindLocation(PChar.location)], false);
			NPChar = CharacterFromID("TQ_Char2");
			if (CheckQuestAttribute("climberquest.fight_type", "battle"))
			{
				LAi_group_Register("CQ_Assistant");
				LAi_group_MoveCharacter(NPChar, "CQ_Assistant");
				LAi_group_FightGroups("CQ_Assistant", LAI_GROUP_PLAYER, true);
			}
			else
			{
				if (GetOfficersQuantity(PChar) == 0 && LANDCREWMEMBERS == false) PChar.quest.climberquest.fight_type = "solo";
				LAi_SetActorType(NPChar);
				LAi_ActorAttack(NPChar, PChar, "");
			}
			PChar.quest.ClimberQuest_arrest.win_condition.l1 = "NPC_Death";
			PChar.quest.ClimberQuest_arrest.win_condition.l1.character = "TQ_Char2";
			PChar.quest.ClimberQuest_arrest.win_condition = "ClimberQuest_arrest";

			PChar.quest.ClimberQuest_escape_to_sea.win_condition.l1 = "MapEnter";
			PChar.quest.ClimberQuest_escape_to_sea.win_condition = "ClimberQuest_escape_to_sea";
		break;

		case "ClimberQuest_escape_to_sea":
			if (CheckQuestAttribute("climberquest.status", "Arrest"))	// You can fast-travel to the ship before the arresting guard dialog
			{
				EndQuestMovie(); TrackQuestMovie("end","ClimberQuest_escape_to_sea");
			}
			PChar.quest.climberquest.status = "escaped";
			PChar.quest.ClimberQuest_trial.over = "yes";
			NPChar = CharacterFromID(PChar.quest.climberquest.destgov);
			NPChar.quest.climber_quest.failed = "escaped";	// This governor won't offer the cash for honours deal in future
			RestoreDialog(NPChar);
			if (CheckAttribute(NPChar, "quest.original_dialog_groupdialog"))
			{
				NPChar.Dialog.Filename.GroupDialog = NPChar.quest.original_dialog_groupdialog;
				DeleteAttribute(NPChar, "quest.original_dialog_groupdialog");
			}
			if (IsInServiceOf(sti(NPChar.nation))) LeaveService(PChar, sti(NPChar.nation), true);
			if (GetRMRelation(PChar, sti(NPChar.nation) > REL_WAR)) SetRMRelation(PChar, sti(NPChar.nation), REL_WAR);
			ChangeCharacterReputation(PChar, -5);		// Accused of murder, ran away, lose reputation
		break;

		case "ClimberQuest_arrest":
			string climber_group, climber_locator;
			AddQuestRecord("Social_Climber_Quest", 10);
			Characters[GetCharacterIndex("TQ_Char2")].location = "none";

			DisableFastTravel(false);
			bQuestDisableSeaEnter = false;

			LAi_LocationFightDisable(&Locations[FindLocation(PChar.location)], true);
			LAi_SetFightMode(PChar, false);
			if (CheckAttribute(PChar, "location.group") && CheckAttribute(PChar, "location.locator"))
			{
				climber_group = PChar.location.group;
				climber_locator = PChar.location.locator;
			}
			else
			{
				GetCharacterPos(PChar, &locx, &locy, &locz);
				climber_group = "reload";
				climber_locator = LAi_FindNearestFreeLocator(climber_group, locx, locy, locz);
			}

			for (i = 1; i <= 4; i++)
			{
				sld = CharacterFromID("TQ_Soldier"+i);
				ChangeCharacterAddressGroup(sld, PChar.location, climber_group, climber_locator);
				LAi_SetActorType(sld);
				if (i > 1) LAi_ActorFollow(sld, PChar, "", 20.0);
				sld.location = "none";
			}

			PChar.quest.climberquest.status = "Arrest";
			NPChar = CharacterFromID(PChar.quest.climberquest.destgov);
			StoreDialog(NPChar);
			NPChar.Dialog.Filename = "Climber_governor_dialog.c";
			NPChar.Dialog.Currentnode = "begin_trial";
			if (CheckAttribute(NPChar, "Dialog.Filename.GroupDialog"))
			{
				NPChar.quest.original_dialog_groupdialog = NPChar.Dialog.Filename.GroupDialog;
				DeleteAttribute(NPChar, "Dialog.Filename.GroupDialog");
			}

			PChar.quest.ClimberQuest_trial.win_condition.l1 = "location";
			PChar.quest.ClimberQuest_trial.win_condition.l1.location = PChar.quest.ClimberQuest.player_location;
			PChar.quest.ClimberQuest_trial.win_condition = "ClimberQuest_trial";

			sld = CharacterFromID("TQ_Soldier1");
			sld.Dialog.Filename = "Climber_soldier_dialog.c";
			sld.Dialog.Currentnode = "Arrest";
			LAi_ActorDialog(sld, PChar, "", 20.0, 20.0);	// Exits to "ClimberQuest_arrest_fight" or "ClimberQuest_arrest_surrender"
		break;

		case "ClimberQuest_arrest_fight":
			Preprocessor_AddQuestData("destisland", FindIslandName(PChar.quest.climberquest.destisland));
			Preprocessor_AddQuestData("sourcetown", FindTownName(PChar.quest.climberquest.sourcetown));
			AddQuestRecord("Social_Climber_Quest", 17);
			Preprocessor_Remove("sourcetown");
			Preprocessor_Remove("destisland");
			EndQuestMovie();TrackQuestMovie("end","ClimberQuest_arrest_fight");
			PChar.quest.climberquest.status = "accused_fought";
			for (i = 1; i <= 4; i++)
			{
				sld = CharacterFromID("TQ_Soldier"+i);
				LAi_group_MoveCharacter(sld, PChar.quest.climberquest.soldiergroup);
			}
			LAi_LocationFightDisable(&Locations[FindLocation(PChar.location)], false);
			LAi_group_SetRelation(PChar.quest.climberquest.soldiergroup, LAI_GROUP_PLAYER, LAI_GROUP_ENEMY);
			LAi_group_FightGroups(PChar.quest.climberquest.soldiergroup, LAI_GROUP_PLAYER, true);
		break;

		case "ClimberQuest_arrest_surrender":
			EndQuestMovie();TrackQuestMovie("end","ClimberQuest_surrender");
			LAi_LocationFightDisable(&Locations[FindLocation(PChar.location)], false);
			PChar.quest.climberquest.status = "accused_surrendered";
			StoreOfficers(PChar.id);
			DoQuestReloadToLocation(PChar.quest.ClimberQuest.player_location, PChar.quest.ClimberQuest.player_group, PChar.quest.ClimberQuest.player_locator, "_");
		break;

		case "ClimberQuest_trial":
			StartQuestMovie(true, false, false); TrackQuestMovie("start","ClimberQuest_trial");
			DisableFastTravel(true);
			if (CheckQuestAttribute("climberquest.status", "accused_surrendered")) PlaceCharacter(CharacterFromID("TQ_Soldier1"), "goto");

			NPChar = CharacterFromID(PChar.quest.climberquest.destgov);
			PChar.quest.ClimberQuest.governor_original_group = NPChar.location.group;
			PChar.quest.ClimberQuest.governor_original_locator = NPChar.location.locator;
			PChar.quest.ClimberQuest.governor_original_type = NPChar.chr_ai.type;
			LAi_SetActorType(NPChar);
			LAi_ActorTurnToCharacter(NPChar, Pchar);
			LAi_SetStayType(NPChar);
			ChangeCharacterAddressGroup(NPChar, PChar.location, "goto", PChar.quest.ClimberQuest.governor_locator);

			GetCharacterPos(NPChar, &locx, &locy, &locz);
			sld = CharacterFromID("TQ_Char1");
			DeleteAttribute(sld, "greeting");
			ChangeCharacterAddressGroup(sld, PChar.location, "goto", LAi_FindNearestFreeLocator("goto", locx, locy, locz));
			LAi_SetActorType(sld);
			LAi_ActorTurnToCharacter(sld, Pchar);
			sld.Dialog.Filename = "Climber_governor_dialog.c";
			sld.Dialog.CurrentNode = "representative_stands";
			sld.Dialog.TempNode = "representative_stands";
			LAi_SetStayType(sld);
			LAi_QuestDelay("ClimberQuest_trial2", 0.0);
		break;

		case "ClimberQuest_trial2":
			NPChar = CharacterFromID(PChar.quest.climberquest.destgov);
			NPChar.Dialog.Filename = "Climber_governor_dialog.c";
			NPChar.Dialog.CurrentNode = "to_representative";
			LAi_SetStayType(CharacterFromID("TQ_Char1"));
			LAi_SetActorType(PChar);		
			LAi_ActorWaitDialog(NPChar, Pchar);
			LAi_ActorDialog(PChar, NPChar,"", 10.0, 10.0);
		break;

		case "ClimberQuest_representative_accuses":
			LAi_SetPlayerType(PChar);
			sld = CharacterFromID("TQ_Char1");
			sld.Dialog.CurrentNode = "representative_accuses";
			LAi_SetActorType(sld);
			LAi_ActorDialogNow(sld, PChar, "ClimberQuest_answer_the_charge", 1.0);
		break;

		case "ClimberQuest_answer_the_charge":
			NPChar = CharacterFromID(PChar.quest.climberquest.destgov);
			NPChar.Dialog.CurrentNode = "answer_the_charge";
			LAi_SetActorType(NPChar);
			LAi_ActorDialogNow(NPChar, PChar, "", 1.0);	// Exits to "ClimberQuest_innocent" or "ClimberQuest_guilty"
		break;

		case "ClimberQuest_innocent":
			if (FindTownName(PChar.quest.climberquest.rivaltown) == "") Preprocessor_AddQuestData("rivaltown", GetNationNameByType(sti(PChar.quest.climberquest.rivalnation)));
			else Preprocessor_AddQuestData("rivaltown", FindTownName(PChar.quest.climberquest.rivaltown));
			Preprocessor_AddQuestData("rival", GetMyFullName(CharacterFromID("TQ_Char1")));
			Preprocessor_AddQuestData("destgov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.destgov)));
			Preprocessor_AddQuestData("sourcegov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.sourcegov)));
			AddQuestRecord("Social_Climber_Quest", 11);
			Preprocessor_Remove("destgov");
			Preprocessor_Remove("sourcegov");
			Preprocessor_Remove("rival");
			Preprocessor_Remove("rivaltown");
			if (CheckQuestAttribute("climberquest.status", "accused_surrendered")) RestoreOfficers(PChar.id);
			PChar.quest.climberquest.status = "innocent";

			EndQuestMovie();TrackQuestMovie("end","ClimberQuest_innocent");
			DisableFastTravel(false);
			bQuestDisableSeaEnter = false;
			PChar.quest.ClimberQuest_escape_to_sea.over = "yes";

			Characters[GetCharacterIndex("TQ_Soldier1")].location = "none";
			Characters[GetCharacterIndex("TQ_Char1")].location = "none";

			PChar.quest.ClimberQuest_reset_destgov.win_condition.l1 = "ExitFromLocation";
			PChar.quest.ClimberQuest_reset_destgov.win_condition.l1.location = PChar.location;
			PChar.quest.ClimberQuest_reset_destgov.win_condition = "ClimberQuest_reset_destgov";
		break;

		case "ClimberQuest_reset_destgov":
			NPChar = CharacterFromID(PChar.quest.climberquest.destgov);
			RestoreDialog(NPChar);
			if (CheckAttribute(NPChar, "quest.original_dialog_groupdialog"))
			{
				NPChar.Dialog.Filename.GroupDialog = NPChar.quest.original_dialog_groupdialog;
				DeleteAttribute(NPChar, "quest.original_dialog_groupdialog");
			}
			ChangeCharacterAddressGroup(NPChar, NPChar.location, PChar.quest.ClimberQuest.governor_original_group, PChar.quest.ClimberQuest.governor_original_locator);
			switch(PChar.quest.ClimberQuest.governor_original_type)
			{
				case "huber":		LAi_SetHuberType(NPChar); break;
				case "huberstay":	LAi_SetHuberStayType(NPChar); break;
				case "sit":		LAi_SetSitType(NPChar); break;
				case "warrior":		LAi_SetWarriorType(NPChar); LAi_warrior_DialogEnable(NPChar, true); LAi_warrior_SetStay(NPChar, true); break;
				LAi_SetStayType(NPChar);
			}
		break;

		case "ClimberQuest_guilty":
			if (!CheckQuestAttribute("climberquest.status", "accused_surrendered")) StoreOfficers(PChar.id);
			PChar.quest.climberquest.status = "guilty";
			PChar.quest.ClimberQuest_escape_to_sea.over = "yes";
			TakeItemFromCharacter(PChar, "trade_contract");

			Characters[GetCharacterIndex("TQ_Soldier1")].location = "none";
			Characters[GetCharacterIndex("TQ_Char1")].location = "none";

			Locations[FindLocation("Marigot_prison")].vcskip = true;
			DoQuestReloadToLocation("Marigot_prison", "goto", "goto24", "ClimberQuest_in_jail");
		break;

		case "ClimberQuest_in_jail":
			if (FindTownName(PChar.quest.climberquest.rivaltown) == "") Preprocessor_AddQuestData("rivaltown", GetNationNameByType(sti(PChar.quest.climberquest.rivalnation)));
			else Preprocessor_AddQuestData("rivaltown", FindTownName(PChar.quest.climberquest.rivaltown));
			Preprocessor_AddQuestData("rival", GetMyFullName(CharacterFromID("TQ_Char1")));
			Preprocessor_AddQuestData("destgov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.destgov)));
			AddQuestRecord("Social_Climber_Quest", 12);
			Preprocessor_Remove("destgov");
			Preprocessor_Remove("rival");
			Preprocessor_Remove("rivaltown");
			PChar.quest.climberquest.old_blade = GetCharacterEquipByGroup(PChar, BLADE_ITEM_TYPE);
			PChar.quest.climberquest.old_gun = GetCharacterEquipByGroup(PChar, GUN_ITEM_TYPE);
			RemoveCharacterEquip(PChar, BLADE_ITEM_TYPE);
			RemoveCharacterEquip(PChar, GUN_ITEM_TYPE);
			EnableEquip(pchar, BLADE_ITEM_TYPE, false);
			EnableEquip(pchar, GUN_ITEM_TYPE, false);
			TempRemoveItems(PChar);
			WaitDate("", 0,0,1,0,0);
			LAi_Fade("", "Climberquest_release_from_jail");
		break;

		case "Climberquest_release_from_jail":
			SetCurrentTime(9, 0);
			ChangeCharacterAddressGroup(CharacterfromID("TQ_Soldier3"), "Marigot_prison", "officers", "reload1_1");
			LAi_SetActorType(CharacterfromID("TQ_Soldier3"));
			LAi_ActorGoToLocator(CharacterfromID("TQ_Soldier3"), "reload", "reload12", "Climberquest_release_from_jail2", 30.0);
		break;

		case "Climberquest_release_from_jail2":
			sld = CharacterFromID("TQ_Soldier3");
			LAi_SetActorType(sld);
			LAi_ActorTurnToCharacter(sld, (Pchar));
			sld.Dialog.Filename = "Climber_soldier_dialog.c";
			sld.Dialog.CurrentNode = "Follow_to_governor";
			LAi_ActorDialogNow(sld, PChar, "Climberquest_return_to_governor", 1.0);
		break;

		case "Climberquest_return_to_governor":
			RestoreTempRemovedItems(PChar);
			EnableEquip(PChar, GUN_ITEM_TYPE, true);
			EnableEquip(PChar, BLADE_ITEM_TYPE,true);
			if (PChar.quest.climberquest.old_blade != "")
			EquipCharacterByItem(PChar, PChar.quest.climberquest.old_blade);
			if (PChar.quest.climberquest.old_gun != "") EquipCharacterByItem(PChar,PChar.quest.climberquest.old_gun);
			DeleteQuestAttribute("climberquest.old_blade");
			DeleteQuestAttribute("climberquest.old_gun");
			
			NPChar = CharacterFromID("TQ_Char2");
			NPChar.nation = Characters[GetCharacterIndex(PChar.quest.climberquest.destgov)].nation;
			SetModelFromID(NPChar, GetRandomModelForTypeExSubCheck(-1, "Upper_Citizens", "man", sti(NPChar.nation)));
			SetRandomNameToCharacter(NPChar);
			NPChar.old.name = NPChar.name;
			NPChar.old.lastname = NPChar.lastname;
			NPChar.sound_type = "male_citizen";
			DeleteAttribute(NPChar, "greeting");
			NPChar.Dialog.Filename = "Climber_rival_dialog.c";
			NPChar.Dialog.Currentnode = "check_id";

			DoQuestReloadToLocation(PChar.quest.ClimberQuest.player_location, PChar.quest.ClimberQuest.player_group, PChar.quest.ClimberQuest.player_locator, "Climberquest_return_to_governor2");
		break;

		case "Climberquest_return_to_governor2":
			NPChar = CharacterFromID(PChar.quest.climberquest.destgov);
			NPChar.Dialog.CurrentNode = "second_chance";
			LAi_SetActorType(NPChar);		
			LAi_SetActorType(PChar);
			NPChar.Dialog.Currentnode = "second_chance";		
			LAi_ActorWaitDialog(NPChar, Pchar);
			LAi_ActorDialog(PChar, NPChar,"", 10.0, 10.0);
		break;

		case "ClimberQuest_hit_setup":	// Triggered by dialog with destgov
			Preprocessor_AddQuestData("destgov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.destgov)));
			Preprocessor_AddQuestData("He", FirstLetterUp(XI_ConvertString(GetMyPronounSubj(CharacterFromID(PChar.quest.climberquest.destgov)))));
			Preprocessor_AddQuestData("enemy", GetMyFullName(CharacterFromID("TQ_Char2")));
			AddQuestRecord("Social_Climber_Quest", 13);
			Preprocessor_Remove("enemy");
			Preprocessor_Remove("He");
			Preprocessor_Remove("destgov");

			LAi_SetPlayerType(PChar);
			RestoreOfficers(PChar.id);
			PChar.quest.climberquest.status = "second_chance";

			EndQuestMovie();TrackQuestMovie("end","ClimberQuest_hit_setup");
			DisableFastTravel(false);
			bQuestDisableSeaEnter = false;
			PChar.quest.ClimberQuest_escape_to_sea.over = "yes";
			PChar.quest.ClimberQuest_arrived_smugglers.win_condition.l1 = "location";
			PChar.quest.ClimberQuest_arrived_smugglers.win_condition.l1.location = "Smugglers_Lair";
			PChar.quest.ClimberQuest_arrived_smugglers.win_condition = "ClimberQuest_arrived_smugglers";
		break;

		case "ClimberQuest_arrived_smugglers":
			NPChar = CharacterFromID("TQ_Char2");
            		ChangeCharacterAddressGroup(NPChar, "Smugglers_Lair", "goto", "goto17");
			NPChar.Dialog.Currentnode = "check_id";
			LAi_group_MoveCharacter(NPChar, "SMUGGLERS_SOLDIERS");
			LAi_SetCitizenType(NPChar);
			if (ENABLE_WEAPONSMOD)
			{
				TakeItemFromCharacter(NPChar, "blade13+3");
				GiveItem2Character(NPChar, "bladeC2+1");
				GiveItem2Character(NPChar, "pistol27+1");
				EquipCharacterByItem(NPChar, "bladeC2+1");
				EquipCharacterByItem(NPChar, "pistol27+1");
			}
			else
			{
				TakeItemFromCharacter(NPChar, "blade13");
				GiveItem2Character(NPChar, "bladeC2");
				GiveItem2Character(NPChar, "pistol27");
				EquipCharacterByItem(NPChar, "bladeC2");
				EquipCharacterByItem(NPChar, "pistol27");
			}
			if (ENABLE_AMMOMOD)
			{
				TakenItems(NPChar, "gunpowder", 1 + rand(2));
				TakenItems(NPChar, "pistolbullets", 1 + rand(2));
			}

			PChar.quest.ClimberQuest_arrest.win_condition.l1 = "NPC_Death";
			PChar.quest.ClimberQuest_arrest.win_condition.l1.character = "TQ_Char2";
			PChar.quest.ClimberQuest_arrest.win_condition = "ClimberQuest_hit_done";
		break;

		case "ClimberQuest_hit":		 // Triggered by dialog with "TQ_Char2"
			LAi_group_MoveCharacter(CharacterFromID("TQ_Char2"), "SMUGGLERS_SOLDIERS");
			LAi_group_FightGroups("SMUGGLERS_SOLDIERS", LAI_GROUP_PLAYER, true);
		break;

		case "ClimberQuest_to_smugglers_tavern": // Triggered by dialog with "TQ_Char2"
			NPChar = CharacterFromID("TQ_Char2");
			LAi_SetActorType(NPChar);		
			LAi_ActorGoToLocation(NPChar, "reload", "reload6", "Smugglers_Tavern", "goto", "goto17", "ClimberQuest_in_smugglers_tavern", 20.0);
		break;

		case "ClimberQuest_in_smugglers_tavern":
			NPChar = CharacterFromID("TQ_Char2");
			LAi_LocationFightDisable(&Locations[FindLocation("Smugglers_Tavern")], false);
			LAi_SetCitizenType(NPChar);
			NPChar.Dialog.Currentnode = "in_tavern";
		break;

		case "ClimberQuest_hit_done":
			NPChar = CharacterFromID("TQ_Char2");
			Preprocessor_AddQuestData("enemy", GetMyFullName(NPChar));
			Preprocessor_AddQuestData("destgov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.destgov)));
			AddQuestRecord("Social_Climber_Quest", 14);
			Preprocessor_Remove("destgov");
			Preprocessor_Remove("enemy");

			if (PChar.location == "Smugglers_Tavern")
			{
				LAi_LocationFightDisable(&Locations[FindLocation("Smugglers_Tavern")], true);
				LAi_group_SetRelation("SMUGGLERS_SOLDIERS", LAI_GROUP_PLAYER, LAI_GROUP_NEUTRAL);
			}
			NPChar.location = "none";

			sld = CharacterFromID(PChar.quest.climberquest.destgov);
			sld.Dialog.CurrentNode = "return_from_hit";
			LAi_SetStayType(sld);
		break;

		case "ClimberQuest_hit_complete":	// Triggered by dialog with destgov
			Preprocessor_AddQuestData("destgov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.destgov)));
			Preprocessor_AddQuestData("his", XI_ConvertString(GetMyPronounPossessive(CharacterFromID(PChar.quest.climberquest.destgov))));
			Preprocessor_AddQuestData("sourcegov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.sourcegov)));
			AddQuestRecord("Social_Climber_Quest", 15);
			Preprocessor_Remove("sourcegov");
			Preprocessor_Remove("his");
			Preprocessor_Remove("destgov");

			GiveItem2Character(PChar, "trade_contract");
			PChar.quest.climberquest.status = "assassin";
			PChar.quest.ClimberQuest_reset_destgov.win_condition.l1 = "ExitFromLocation";
			PChar.quest.ClimberQuest_reset_destgov.win_condition.l1.location = PChar.location;
			PChar.quest.ClimberQuest_reset_destgov.win_condition = "ClimberQuest_reset_destgov";
		break;

		case "ClimberQuest_got_title":
			Preprocessor_AddQuestData("sourcegov", GetMyFullName(CharacterFromID(PChar.quest.climberquest.sourcegov)));
			Preprocessor_AddQuestData("title", GetMyAddressForm(CharacterFromID(PChar.quest.climberquest.sourcegov), PChar, ADDR_TITLE, false, false));
			AddQuestRecord("Social_Climber_Quest", 16);
			Preprocessor_Remove("title");
			Preprocessor_Remove("sourcegov");
			CloseQuestHeader("Social_Climber_Quest");
		break;

		PChar.questnotfound = true; // PB: Testing
	}
}
