//#include "DIALOGS\Climber_governor_dialog.h"
void ProcessDialogEvent()
{
	ref NPChar;
	aref Link, Diag; //NextDiag;

	DeleteAttribute(&Dialog,"Links");

	makeref(NPChar,CharacterRef);
	makearef(Link, Dialog.Links);
	makearef(Diag, NPChar.Dialog);

	ref PChar;
	PChar = GetMainCharacter();
	int iNation = sti(NPChar.nation);
	
	switch(Dialog.CurrentNode)
	{
		// -----------------------------------  -  
		
		case "exit":
			Diag.CurrentNode = Diag.TempNode; //"First time";
			DialogExit();
		break;

	
		case "First time":
			Dialog.defAni = "dialog_stay1";
			Dialog.defCam = "1";
			Dialog.defSnd = "dialogs\0\017";
			Dialog.defLinkAni = "dialog_1";
			Dialog.defLinkCam = "1";
			Dialog.defLinkSnd = "dialogs\woman\024";
			Dialog.ani = "dialog_stay2";
			Dialog.cam = "1";
			Dialog.snd = "dialogs\0\009";

			dialog.text = DLG_TEXT[0] + GetMyFullName(NPChar) + DLG_TEXT[1] + GetMyAddressForm(NPChar, PChar, ADDR_CIVIL, false, false) + DLG_TEXT[2];		// changed from .spa to .por by KAM
			Link.l1 = DLG_TEXT[3] + GetMyFullName(PChar) + DLG_TEXT[4];
			Link.l1.go = "node_1";
			Diag.TempNode = "second time";
		break;

		case "node_1":
			dialog.text = DLG_TEXT[5];
			link.l1 = DLG_TEXT[7];
			link.l1.go = "quests";
			link.l1 = DLG_TEXT[8] + GetCharacterAddressForm(NPChar, ADDR_POLITE, false, false) + DLG_TEXT[9];
			link.l1.go = "node_2";
		break;

		case "node_2":
			dialog.text = DLG_TEXT[10];
			link.l1 = DLG_TEXT[11];
			link.l1.go = "exit";
		break;

		case "second time":
			dialog.text = DLG_TEXT[6];
			link.l1 = DLG_TEXT[7];
			link.l1.go = "quests";
			link.l2 = DLG_TEXT[8];
			link.l2.go = "node_2";
		break;

		case "quests":
			dialog.text = DLG_TEXT[12] + GetMyAddressForm(NPChar, PChar, ADDR_CIVIL, false, false) + DLG_TEXT[13];		// changed from .spa to .por by KAM
			link.l99 = DLG_TEXT[14];
			link.l99.go = "exit";
		break;

		case "begin_trial":
			Preprocessor_Add("pronoun2", XI_ConvertString(GetMyPronounObj(CharacterFromID("TQ_Char2"))));
			dialog.text = DLG_TEXT[58] + GetMyAddressForm(NPChar, PChar, ADDR_CIVIL, false, true) + DLG_TEXT[59] + FindTownName(PChar.quest.climberquest.rivaltown) + DLG_TEXT[60];
			link.l1 = DLG_TEXT[21] + GetCharacterAddressForm(NPChar, ADDR_POLITE, false, false) + DLG_TEXT[22];
			link.l1.go = "judgement";
		break;

		case "representative_stands":
			if (NPChar.sex == "woman") PlaySound("VOICE\ENGLISH\Eng_f_c_008.wav");
			else PlaySound("VOICE\ENGLISH\Eng_m_c_053.wav");
			dialog.text = DLG_TEXT[15];
			link.l1 = DLG_TEXT[16];
			link.l1.go = "exit";
		break;

		case "to_representative":
			dialog.text = DLG_TEXT[17];
			if (PChar.quest.climberquest.rivaltown == DLG_TEXT[57]) dialog.text = dialog.text + GetNationNameByType(sti(PChar.quest.climberquest.rivalnation)) + DLG_TEXT[18];
			else dialog.text = dialog.text + FindTownName(PChar.quest.climberquest.rivaltown) + DLG_TEXT[18];
			link.l1 = "...";
			AddDialogExitQuest("ClimberQuest_representative_accuses");
			link.l1.go = "exit";
		break;

		case "representative_accuses":
			if (NPChar.sex == "woman") PlaySound("VOICE\ENGLISH\Eng_f_c_010.wav");
			else PlaySound("VOICE\ENGLISH\Eng_m_c_052.wav");
			Preprocessor_Add("person", XI_ConvertString(PChar.sex));
			dialog.text = DLG_TEXT[19];
			link.l1 = "...";
			link.l1.go = "exit";
		break;

		case "answer_the_charge":
			dialog.text = DLG_TEXT[20];
			Preprocessor_Add("pronoun2", XI_ConvertString(GetMyPronounObj(CharacterFromID("TQ_Char2"))));
			link.l1 = DLG_TEXT[21] + GetCharacterAddressForm(NPChar, ADDR_POLITE, false, false) + DLG_TEXT[22];
			link.l1.go = "judgement";
		break;

		case "judgement":
			dialog.text = DLG_TEXT[23];
			link.l1 = "";
			link.l1.go = "judgement2";
		break;

		case "judgement2":
			int verdict = 0;
			Preprocessor_Add("person", XI_ConvertString(PChar.sex));
			Preprocessor_Add("nation", XI_ConvertString(GetNationNameByType(iNation)));
			if (CheckQuestAttribute("climberquest.status", "accused_surrendered"))		// You surrendered to the arresting soldiers
			{
				verdict += 10;
				dialog.text = DLG_TEXT[24];
			}
			if (CheckQuestAttribute("climberquest.status", "accused_fought"))		// You resisted arrest
			{
				verdict -= 12;
				dialog.text = DLG_TEXT[25];
			}
			if (HasSubstr(PChar.location.from_sea, "port"))					// You're moored in port
			{
				verdict += 12;
				dialog.text= dialog.text + DLG_TEXT[26];
				if (CheckQuestAttribute("climberquest.fight_type", "battle"))		// You fought with help from officers or crew
				{
					verdict -= 3;
					dialog.text = dialog.text + DLG_TEXT[35];
				}
				if (CheckQuestAttribute("climberquest.fight_type", "duel"))		// You fought in single combat despite having officers or crew
				{
					verdict += 3;
					dialog.text = dialog.text + DLG_TEXT[36];
				}
			}
			if (HasSubstr(PChar.location.from_sea, "shore"))				// You're moored at a beach
			{
				verdict -= 10;
				dialog.text= dialog.text + DLG_TEXT[27];
			}
			if (verdict > -5 && verdict < 5)						// Surrendered + in port = innocent, resisted + at beach = guilty, otherwise look at more factors
			{
				if (sti(PChar.reputation) >= REPUTATION_VERYGOOD)			// Reputation "Dashing" or better
				{
					verdict += makeint((sti(PChar.reputation) - REPUTATION_GOOD)/5.0 + 0.5)
					dialog.text = dialog.text + DLG_TEXT[28];
				}
				if (sti(PChar.reputation) <= REPUTATION_BASTARD)			// Reputation "Bloody Terror" or worse
				{
					verdict += makeint((sti(PChar.reputation) - REPUTATION_SWINDLER)/5.0 + 0.5)
					dialog.text = dialog.text + DLG_TEXT[29];
				}
				if (GetServedNation() == iNation)					// You are in the sole service of this governor's nation
				{
					verdict += 5;
					dialog.text = dialog.text + DLG_TEXT[32];
				}
				if (GetNationRelation2MainCharacter(iNation) == RELATION_ENEMY)		// You are a known enemy of the governor's nation
				{
					verdict -= 5;
					dialog.text = dialog.text + DLG_TEXT[33];
				}
				if (GetServedNation() == PIRATE)					// You're a pirate
				{
					verdict -= 3;
					dialog.text = dialog.text + DLG_TEXT[34];
				}
				if (HaveLetterOfMarque(iNation))					// You have a LoM from the governor's nation
				{
					verdict += 2;
					dialog.text = dialog.text + DLG_TEXT[30];
				}
				int checknation = 0;
				while (checknation >= 0 && checknation < CheckNationsQuantity(GetCurrentPeriod()))
				{
					if (GetNationRelation(iNation, checknation) == RELATION_ENEMY && HaveLetterOfMarque(checknation)) checknation = -5;
					else checknation += 1;
				}
				if (checknation == -5)							// You have a LoM from an enemy nation
				{
					verdict -= 3;
					dialog.text = dialog.text + DLG_TEXT[31];
				}
			}

			dialog.text = dialog.text + DLG_TEXT[37];
			PChar.quest.climberquest.verdict = verdict;
			if (verdict > 0)
			{
				dialog.text = dialog.text + DLG_TEXT[38] + GetMyFullName(CharacterFromID(PChar.quest.climberquest.sourcegov)) + DLG_TEXT[39];
				if (PChar.quest.climberquest.rivaltown == DLG_TEXT[57]) dialog.text = dialog.text + GetNationNameByType(sti(PChar.quest.climberquest.rivalnation)) + DLG_TEXT[40];
				else dialog.text = dialog.text + FindTownName(PChar.quest.climberquest.rivaltown) + DLG_TEXT[40];
				link.l1 = DLG_TEXT[41] + GetCharacterAddressForm(NPChar, ADDR_POLITE, false, false) + DLG_TEXT[42];
				AddDialogExitQuest("ClimberQuest_innocent");
				link.l1.go = "exit";
			}
			else
			{
				dialog.text = dialog.text + DLG_TEXT[43];
				if (PChar.quest.climberquest.rivaltown == DLG_TEXT[57]) dialog.text = dialog.text + GetNationNameByType(sti(PChar.quest.climberquest.rivalnation)) + DLG_TEXT[44];
				else dialog.text = dialog.text + FindTownName(PChar.quest.climberquest.rivaltown) + DLG_TEXT[44];
				link.l1 = "...",
				AddDialogExitQuest("ClimberQuest_guilty");
				link.l1.go = "exit";
			}
		break;

		case "second_chance":
			dialog.text = DLG_TEXT[45] + GetMyAddressForm(NPChar, PChar, ADDR_CIVIL, false, true) + DLG_TEXT[46];
			link.l1 = DLG_TEXT[47];
			link.l1.go = "second_chance_interested";
			link.l2 = DLG_TEXT[48];
			link.l2.go = "if_i_refuse";
		break;

		case "if_i_refuse":
			dialog.text = DLG_TEXT[49];
			link.l1 = DLG_TEXT[50];
			link.l1.go = "second_chance_interested";
		break;

		case "second_chance_interested":
			dialog.text = DLG_TEXT[51];
			link.l1 = DLG_TEXT[52];
			link.l1.go = "who_is_he";
		break;

		case "who_is_he":
			dialog.text = DLG_TEXT[53] + GetMyFullName(CharacterFromID("TQ_Char2")) + DLG_TEXT[54];
			link.l1 = DLG_TEXT[55] + GetMyFullName(CharacterFromID("TQ_Char2")) + DLG_TEXT[56];
			AddDialogExitQuest("ClimberQuest_hit_setup");
			link.l1.go = "exit";
		break;

		case "return_from_hit":
			dialog.text = DLG_TEXT[63] + GetMyAddressForm(NPChar, PChar, ADDR_CIVIL, false, true) + DLG_TEXT[64];
			link.l1 = DLG_TEXT[65] + GetCharacterAddressForm(NPChar, ADDR_POLITE, false, false) + DLG_TEXT[66] + GetMySimpleName(CharacterFromID("TQ_Char2")) + DLG_TEXT[67];
			link.l1.go = "contract_returned";
		break;

		case "contract_returned":
			dialog.text = DLG_TEXT[68];
			link.l1 = DLG_TEXT[69] + GetCharacterAddressForm(NPChar, ADDR_POLITE, false, false) + DLG_TEXT[70] + GetMyFullName(CharacterFromID(PChar.quest.climberquest.sourcegov)) + DLG_TEXT[71];
			AddDialogExitQuest("ClimberQuest_hit_complete");
			link.l1.go = "exit";
		break;

	}
}