// ccc Buildingset, new file	
/*
ccc Dec06:
Unlike most other files in this folder this one contains not only a textarray but code and English text merged.

The buildingset has recently been messed up by the attempt to localize my original all-English dialogfiles. 
Instead of spending weeks with fixing and testing the new files I restored my original files. 
However, the localization project has changed the structure of PotC for good : 
Upon loading a  "x-dialog.c" codefile the program now automatically includes a  "x-dialog.h" text array file from the dialogs\english subfolder(or from the Russian folder if you use that language). 
There the dialogtext is supposed to be.

However, I prefer to have code AND plain text in one file, for 3 reasons:
-It is much easier to write
-You have much less bugs with not matching texts
-It is much easier to read and understand the file for debuggers and people who would like to change it
The last point is especially important for me cause the Buildingset is supposed to be a tool for people who want to start modding.
That's why I stick to the original "code plus English text" dialogfiles.

As a concession to the localization project I put these files NOT into the \dialogs rootfolder but into the \dialogs\English subfolder.
So if you want to translate this dialog you can simply copy the "code plus English text" into the subfolder for your language and translate the English text there.
That will certainly be less work and trouble than messing up my files again. 
Not mention the work and trouble that the debuging always causes.
*/
void ProcessDialogEvent()
{
	ref NPChar;
	aref Link, NextDiag;

	DeleteAttribute(&Dialog,"Links");

	makeref(NPChar,CharacterRef);
	makearef(Link, Dialog.Links);
	makearef(NextDiag, NPChar.Dialog);

	ref PChar;
	PChar = GetMainCharacter();
	ref lcn = &Locations[FindLocation(PChar.location)];

	string nr = NPChar.lastname;

	string buildingstr = NPChar.equip.blade;
	aref buildingref;
	Items_FindItem(buildingstr,&buildingref);

	string interiorstr = "";
	if(CheckAttribute(Npchar,"equip.gun"))
	{
	interiorstr = NPChar.equip.gun;
	aref interiorref;
	Items_FindItem(interiorstr,&interiorref);
	}

	int planks = 0;
	int money = 0;
	int crew = 0;

	int grgbonus = 0;

	int iDYear = sti(lcn.building.(nr).taxyear);
	int iDMonth = sti(lcn.building.(nr).taxMonth);
	int iDDay = sti(lcn.building.(nr).taxDay);
	int taxdays = GetPastTime("day", iDYear, iDMonth, iDDay, 1, GetDataYear(), GetDataMonth(), GetDataDay(), 1);
	int tax = 0;

	string adress;
	if(NPChar.chr_ai.group==LAI_GROUP_PLAYER ){adress = " Commander, Sir, ";}else{adress = "";}

	switch(Dialog.CurrentNode)
	{
		case "First time":
			Dialog.defAni = "dialog_stay1";
			Dialog.defCam = "1";
			Dialog.defSnd = "dialogs\0\017";
			Dialog.defLinkAni = "dialog_1";
			Dialog.defLinkCam = "1";
			Dialog.defLinkSnd = "dialogs\woman\024";
			Dialog.ani = "dialog_stay2";
			Dialog.cam = "1";
			Dialog.snd = "voice\PADI\PADI001";

			if(rand(100)<30) // chance for random attack, decrease last figure for fewer attacks
			{
				ChangeCharacterReputation(Pchar, -2);  // punishment: reputationloss. Will be offset if accept the fight
				PlayStereoSound("voice\Eng_m_a_070.wav");	
				Dialog.text = adress + LinkRandPhrase(" forces hostiles aperues. Formez-vous en haut pour dfendre.", " mouvements ennemis dans notre secteur! Beat to quarters!", "Mouvements suspect dans notre primtre, au poste de combat!");

				link.l1 = "Je veux un rapport dtaill, marin, MAINTENANT.";
				if(rand(100)>50) {Link.l1.go = "attack1";}
				else{Link.l1.go = "attack2";}

				link.l9 = "Laissez-moi seul avec lui, c'est VOTRE travail! Enfin c'est pour quoi je vous ai engags : comme canonnier.. er.. chargeur canon. Je n'ai pas le temps de toute faon : on doit se mettre en arrire  la maison blanche, mettre ma veste et livrer quelques railleries de toughsounding  l'lectorat..";
				link.l9.go = "exit";
			}
			else
			{
				PlayStereoSound("objects\duel\reload2.wav");
	      		PlayStereoSound("voice\ENGLISH\Eng_m_c_044.wav");
				Dialog.text =  "Rapport " + buildingstr + " fini et prt pour la bataille ," + adress + " tous est calme dans ce secteur.";

				if(NPChar.chr_ai.group==LAI_GROUP_PLAYER)
				{
					link.l1 = "Nous nous retirons de cette position. Dmontez moi a " + buildingstr + ", chargez les planches dans notre cale et faite un rapport au Sergent de mes Fusiliers marins sur les devoirs du navire.";
					link.l1.go = "dismantle";

					if(sti(pchar.money)>5000 && !CheckCharacterItem(NPChar,"cannon") )
					{
					link.l21 = "Cette fortification serait formidable avec un canon. Sans parler de l'augmentation de puissance de feu. Ici, soldat, prenez ces 5000 or et prenez un fusil et tenez votre position.";
					link.l21.go = "cannon";
					}

					if(CheckCharacterItem(PChar,"pistolgrenade") && !CheckCharacterItem(NPChar,"pistolgrenade") )
					{
					link.l22 = "Soldat, J'ai une tche spciale pour vous : Ici, prenez cette grenade au cas ou l'ennemi voudrais prendre cette position d'assaut...";
					link.l22.go = "grenade";
					}
				}
				else
				{
					link.l1 = "Je passais juste par l... ";
					link.l1.go = "exit";
				}

				Link.l4 = "Trs bien, Soldat, continuer.";
				Link.l4.go = "exit";

				link.l6 = "Soldat, cette fortification trop basse et trop faible arrtera un assaut ?";
				link.l6.go = "odd";

				link.l5 = "Hey, why do stand here so motionless? " + LinkRandPhrase("Avez-vous a aval un manche  balai...", "Dtenez-vous, mettez vous, un peu...  L'AISE!", "Je m'attendais  un peu plus d'activit de mes marines, tu m'entends ?");
				link.l5.go = "motion";

				link.l9 = "Hey, you there in front of the keyboard! This is a building that YOU created, so how about creating your own dialog as well? Just use Notepad to open the file program\dialogs\ " + NPchar.dialog.filename + " and overwrite this text with your own. Then follow the instructions in the comments.";
				link.l9.go = "your_dialog"; //this is the case that runs if you choose the dialogoption l9. It is right below.
			}
		break;
                
		case "your_dialog":
			Dialog.text = "Overwrite this with the dialogtext of the NPC." ;

			link.l1 = "Text of the player dialogoption link.l1 which ends the dialog ";
			link.l1.go = "exit";	// link l1 exits the dialog

			link.l2 = "Text of the player dialogoption link.l2 which leads to another exchange ";
			link.l2.go = "your_dialog2";	// l2 leads to the case your_dialog2
		break;	// end of case "your_dialog"
                
		case "your_dialog2":
			Dialog.text = "Overwrite this with the dialogtext of the NPC." ;

			link.l1 = "Text of the player dialogoption link.l1 which ends the dialog";
			link.l1.go = "exit";	// link l1 exits the dialog

			// Here are some codelines that give you money, items, goods or experience. To activate them delete the comment slashes '//' in front of the code. You can change the amounts to your liking.

			// AddMoneyToCharacter(Pchar, 1000);

			// GiveItem2Character(Pchar, "Spyglass3");
			// GiveItem2Character(Pchar, "Jewelry5");
			// GiveItem2Character(Pchar, "Mineral3");
			// TakenItems(Pchar, "potion1", 3);

 			// AddCharacterGoods(pchar, GOOD_SANDAL, 10 );
			// AddCharacterGoods(pchar, GOOD_SILK, 10 );
			// AddCharacterGoods(pchar, GOOD_RUM, 20 );
			// AddCharacterGoods(pchar, GOOD_WHEAT, 20 );

			// AddPartyExp(PChar, 100 );


		break;	// end of case "your_dialog2"

// give grenade to building for selfdefense                
		case "grenade":
			Dialog.text = "...Qu'ils viennent. Je connais mon devoir, Commandant!" ;
			link.l1 = "C'est l'esprit, marines! Avec votre sens du devoir vous deviendrez bientt caporal. (.. si vous vivez assez longtemps..)";
			link.l1.go = "exit";
			TakeItemFromCharacter(pchar, "pistolgrenade" );
			GiveItem2Character(NPchar, "pistolgrenade");
		break;

		case "cannon":
			PlayStereoSound("INTERFACE\took_item.wav");
			AddMoneyToCharacter(Pchar, -5000);
			Pchar.Ship.crew.quantity = sti(Pchar.Ship.crew.quantity) -3;
			lcn.building.(nr).interior = "cannon";
			Dialog.text = "Oui, Monsieur, je connais le sergent matre du magazine local trs bien. Pour 5000 Or il vendrait son ordonnance entire. Donnez-moi juste quelques heures." ;
			link.l1 = "C'est l'esprit, marines! Avec votre comprhension de la logistique vous deviendrez bientt caporal. (.. si vous vivez assez longtemps..)";
			link.l1.go = "exit";
		break;


// random attacks
		case "attack1":
			Dialog.text = "Des cannibales sauvage Akellani s'approchant, Monsieur! Oh, si seulement nous avions plus de ces bastions, palissades, mines et canon...";
			link.l1 = RandSwear() + " Attention, soldat! Tenez votre position cote que cote. Continuez  tir, ne laissez pas l'ennemi vous entraner dans un combat rapproch. Je m'occuperai du reste avec ma lame...";
			link.l1.go = "exit_attack1";
		break;

		case "attack2":
			Dialog.text = "Francisco Pizarro est le Plus jeune de sa horde de mauradeur conquistadore approche, Monsieur! Convoiter pour le sang, le pillage et le viol... Oh, si nous avions seulement plus de ces bastions, palissades, mines et canon...";
			link.l1 = RandSwear() + " Attention, soldat! Tenez votre position cote que cote. Continuez  tir, ne laissez pas l'ennemi vous entraner dans un combat rapproch. Je m'occuperai du reste avec ma lame...";
			link.l1.go = "exit_attack2";
		break;

		case "Exit_attack1":
		// PB: To prevent the fight from starting before the dialog is closed
			Ambush("natives", 3+sti(pchar.skill.fencing), "enemy", "enemy","");
			ChangeCharacterReputation(Pchar, 4);  // reward: reputation. Change figure to your liking
			if(AUTO_SKILL_SYSTEM) { AddPartyExpChar(PChar, "Fencing", (3+sti(pchar.skill.fencing)) * 100 ); }
			else { AddPartyExp(PChar, (3+sti(pchar.skill.fencing)) * 100 ); }  // reward: experience. Change last figure to your liking

			DialogExit();
			NextDiag.CurrentNode = NextDiag.TempNode;
		break;

		case "Exit_attack2":
		// PB: To prevent the fight from starting before the dialog is closed
			Ambush("Soldier_Spa2",  3+sti(pchar.skill.fencing), "enemy", "enemy","");
			ChangeCharacterReputation(Pchar, 4);  // reward: reputation. Change figure to your liking
			if(AUTO_SKILL_SYSTEM) { AddPartyExpChar(PChar, "Fencing", (3+sti(pchar.skill.fencing)) * 100 ); }
			else { AddPartyExp(PChar, (3+sti(pchar.skill.fencing)) * 100 ); }  // reward: experience. Change last figure to your liking

			DialogExit();
			NextDiag.CurrentNode = NextDiag.TempNode;
		break;

// dismantling of this building
		case "dismantle":
			DialogExit();
			planks += sti(buildingref.building.planks);
			crew += sti(buildingref.building.crew);

			if(CheckAttribute(Npchar,"equip.gun"))
			{
				planks += sti(interiorref.building.planks);
				crew += sti(interiorref.building.crew);
			}
			AddCharacterGoods(pchar, GOOD_PLANKS, planks);
			AddCharacterCrew(pchar, crew);   // ccc mar06
			Lai_KillCharacter(npchar);
		break;

// info about modding                
		case "odd":
			if(buildingstr == "bastion")
			{
				Dialog.text = "Trop bas ? Semble que vous ayez les mmes vues dmodes sur l'architecture militaire comme ces tailleurs de pierres russes qui construisent tous ces murs municipaux mdivaux et forts de gratte-ciel ici. Mais l'invention de poudre  canon a rendu des murs haut crnels obsoltes. Le profil bas de ce bastion offre  l'artillerie de sige moins d'une cible. Ne faites pas attention que l'infanterie ennemie puisse tre capable d'escalader des embrasures basses, aussi longtemps que notre artillerie continue  tirer ils ne vivront pas longtemps." ;
			} else {
				Dialog.text = "Umm, ainsi, tous les bois dcent va dans les chantiers navals, nous avons donc d construire cette palissade de troncs de bois flott et cassants. Certes, il ya des espaces assez large ou l'ennemi peut s'introduire. Mais aussi longtemps que notre artillerie continue  tir, ils ne vivront pas longtemps aprs.";
			}
			link.l2 = "Ainsi l'artillerie la cl de tout ? Comment puis-je dployer mes canons de la meilleure faon ?";
			link.l2.go = "odd2";
		break;

		case "odd2":
			Dialog.text = "Un groupe plusieurs fortifications avec un ensemble de canon vera un puissant soutien, mais pas si ils viennent attaquer en mme temps. Dans la ligne de front un fort bastion qui prend le poids de l'attaque et derrire cela les palissades moins chres qui peuvent lancer les attaquants occups avec le bastion. Mais faites attention qu'aucun de vos hommes n'entre dans la ligne de feu.  la longue gamme nos coquilles tuent chacun prs de la cible. Ne vous mlez pas de la lutte compltement ou du sjour prs des fusils o notre but est mieux." ;
			link.l1 = "Ummm, je ne suis pas sr si je peux me permettre a ... Mais Merci pour la leon sur les fortifications du 17e sicle.";
			link.l1.go = "exit";
		break;

		case "motion":
			Dialog.text = LinkRandPhrase("Sir, we always stand to attention in a superiors presence. That's the drill, and the drill is everything.", "I have my eye on a suspicious target, and I don't want too loose it. 'Keep your aim, never flinch, never blink' our drillseargeant used to say.", "First rule of camouflage: movement attracts attention. So never move if you don't have to.");
			link.l1 = "Bon, je comprends ... Continuez.";
			link.l1.go = "exit";
		break;


// dialogexits
		case "moraledrop":
			lcn.building.(nr).taxyear = GetDataYear();
			lcn.building.(nr).taxMonth = GetDataMonth();
			lcn.building.(nr).taxDay = GetDataDay();
			pchar.ship.crew.morale=makeint(stf(pchar.ship.crew.morale) -5 );  // punishment: crew moraledrop. Change figure to your liking
			DialogExit();
			NextDiag.CurrentNode = NextDiag.TempNode;
		break;

		case "Exit":
			DialogExit();
			NextDiag.CurrentNode = NextDiag.TempNode;
		break;
	}
}
