// ccc Buildingset, new file	
/*
ccc Dec06:
Unlike most other files in this folder this one contains not only a textarray but code and English text merged.

The buildingset has recently been messed up by the attempt to localize my original all-English dialogfiles. 
Instead of spending weeks with fixing and testing the new files I restored my original files. 
However, the localization project has changed the structure of PotC for good : 
Upon loading a  "x-dialog.c" codefile the program now automatically includes a  "x-dialog.h" text array file from the dialogs\english subfolder(or from the Russian folder if you use that language). 
There the dialogtext is supposed to be.

However, I prefer to have code AND plain text in one file, for 3 reasons:
-It is much easier to write
-You have much less bugs with not matching texts
-It is much easier to read and understand the file for debuggers and people who would like to change it
The last point is especially important for me cause the Buildingset is supposed to be a tool for people who want to start modding.
That's why I stick to the original "code plus English text" dialogfiles.

As a concession to the localization project I put these files NOT into the \dialogs rootfolder but into the \dialogs\English subfolder.
So if you want to translate this dialog you can simply copy the "code plus English text" into the subfolder for your language and translate the English text there.
That will certainly be less work and trouble than messing up my files again. 
Not mention the work and trouble that the debuging always causes.
*/
void ProcessDialogEvent()
{
	ref NPChar;
	aref Link, NextDiag;

	DeleteAttribute(&Dialog,"Links");

	makeref(NPChar,CharacterRef);
	makearef(Link, Dialog.Links);
	makearef(NextDiag, NPChar.Dialog);

	ref PChar;
	PChar = GetMainCharacter();
	
	string natname = GetNationNameByType(sti(npchar.nation));

	switch(natname)
	{
		case "portugal":
			PlayStereoSound("voice\ENGLISH\por_m_a_038.wav"); 
		break;

		case "holland":
			PlayStereoSound("voice\ENGLISH\dut_m_a_040.wav");
		break;

		case "britain":
			PlayStereoSound("voice\ENGLISH\eng_m_a_051.wav");
		break;

		case "france":
			PlayStereoSound("voice\ENGLISH\fre_m_a_042.wav");
		break;

		case "spain":
			PlayStereoSound("voice\ENGLISH\spa_m_a_039.wav");
		break;
	}

	npchar.bribe = (sti(pchar.skill.fencing)+sti(pchar.skill.leadership)+sti(pchar.skill.accuracy))*1000;
	switch(Dialog.CurrentNode)
	{
		case "First time":
			Dialog.defAni = "dialog_stay1";
			Dialog.defCam = "1";
			Dialog.defSnd = "dialogs\0\017";
			Dialog.defLinkAni = "dialog_1";
			Dialog.defLinkCam = "1";
			Dialog.defLinkSnd = "dialogs\woman\024";
			Dialog.ani = "dialog_stay2";
			Dialog.cam = "1";
			NextDiag.TempNode = "first time";
			dialog.text = "Ah, ma chrie "+ GetMyAddressForm(NPChar, PChar, ADDR_CIVIL, false, false) + " " + PChar.lastname +  "! Enfin je rencontre en personne le hros que j'ai si souvent entendu parler! Les meilleurs histoires, bien sr. La parole de vos exploits ont atteint les plus hautes sphres de la cour de " + natname + ", qui ont t si impressionns par votre personnage, mme la " + GetNationRoyalByType(sti(npchar.nation)) + " ont exprim son dsir de surmonter les .. err .. malentendus qui ont peu .. err .. jeter une ombre sur les relations entre " + natname + " et vous. Donc oublions le pass et ayons un avenir commun. Si vous tes prt  combattre pour notre fire et gnreuse nation, nous vous accordons une amnistie et d'une lettre de Marquee royale. Et en considration de votre commandement et de la lutte contre les ennemis, nous vous offrons mme une somme de " + npchar.bribe + " Or!";

			if(sti(pchar.money)>sti(npchar.bribe))
			{
			link.l1 = "Pardon? Tu pense que tu peux m'acheter? Qui pense-tu que je suis? Je n'ai pas besoin de ton argent sale de la corruption, je mprise ces petits montants. Tiens, prends " + npchar.bribe + " pices d'or, ammene les  ta Majest et dit lui de bouger son cul royal. Je suis sr que tu trouvera un moyen diplomatique pour faire a, hein? Et maintenant hors de ma vue!";
			link.l1.go = "exit_reput";
			}

			link.l2 = "Quoi, tu crois que tu peux m'acheter? Qui pense-tu que je suis? Un tratre? Un objet  louer? Eh bien, tu es alors devant l'homme qu'il faut. Merci beaucoup pour l'argent, et mes salutations  " + GetNationRoyalByType(sti(npchar.nation)) + ". Dis lui que je vais couler quelques navires spcialement pour lui. Au revoir.";
			link.l2.go = "exit_change";

			link.l3 = "Hum, je crains que mon travail .. heu .. ma patrie bien-aime, je veux dire, ne sera pas trs contente si je change de camp. Et je ne peux pas se permettre d'avoir " + GetNationNameByType(sti(pchar.nation)) + " comme l'ennemi. Je dois penser  ma reputaion. Donc ce n'est pas pour aujourd'hui, dsol. ";
			link.l3.go = "exit";
		break;


		case "exit":
			LAi_SetActorType(NPchar);
			LAi_ActorGoToLocation(NPchar, "reload", LAi_FindRandomLocator("reload"), "none", "", "", "", 25.0);
			DialogExit();
			NextDiag.CurrentNode = NextDiag.TempNode;
		break;

		case "exit_reput":
			PlayStereoSound("INTERFACE\took_item.wav");
			AddMoneyToCharacter(pchar, -sti(npchar.bribe));
			ChangeCharacterReputation(pchar, 3);
			if(AUTO_SKILL_SYSTEM) { AddPartyExpChar(PChar, "Leadership", sti(npchar.bribe)/10/2 ); AddPartyExpChar(PChar, "Sneak", sti(npchar.bribe)/10/2 ); }
			else { AddPartyExp(PChar, sti(npchar.bribe)/10 ); }

			LAi_SetActorType(NPchar);
			LAi_ActorRunToLocation(NPchar, "reload", LAi_FindRandomLocator("reload"), "none", "", "", "", 25.0);
			DialogExit();
			NextDiag.CurrentNode = NextDiag.TempNode;
		break;

		case "exit_change":

    	switch(natname)
    	{
    		case "portugal":
    			PlayStereoSound("voice\ENGLISH\por_m_a_038.wav"); 
    		break;

    		case "holland":
    			PlayStereoSound("voice\ENGLISH\dut_m_a_040.wav");
    		break;

    		case "britain":
    			PlayStereoSound("voice\ENGLISH\eng_m_a_051.wav");
    		break;

    		case "france":
    			PlayStereoSound("voice\ENGLISH\fre_m_a_042.wav");
    		break;

    		case "spain":
    			PlayStereoSound("voice\ENGLISH\spa_m_a_039.wav");
    		break;
    	}

			SetRMRelation(pchar, sti(pchar.nation), REL_WAR);
			SetNationRelation2Blaze(sti(pchar.nation), RELATION_ENEMY); // ccc Dec 06
			pchar.nation = Npchar.nation;
			RMAmnesty(pchar, sti(Npchar.nation));
			SetRMRelation(pchar, sti(pchar.nation), 1);
			SetNationRelation2Blaze(sti(pchar.nation), RELATION_FRIEND); // ccc Dec 06
			UpdateRelations();
			RefreshBattleInterface();

			PlayStereoSound("INTERFACE\took_item.wav");
			AddMoneyToCharacter(pchar, sti(npchar.bribe));
			ChangeCharacterReputation(pchar, -6);
			if(AUTO_SKILL_SYSTEM) { AddPartyExpChar(PChar, "Leadership", sti(npchar.bribe)/10/2 ); AddPartyExpChar(PChar, "Sneak", sti(npchar.bribe)/10/2 ); }
			else { AddPartyExp(PChar, sti(npchar.bribe)/10 ); }

			LAi_SetActorType(NPchar);
			LAi_ActorGoToLocation(NPchar, "reload", LAi_FindRandomLocator("reload"), "none", "", "", "", 25.0);
			DialogExit();
			NextDiag.CurrentNode = NextDiag.TempNode;
		break;

	}
}
