/* Estharos Modification March, 2009
- Towns with no codes after there name, means no street merchant for this town
- Add specific named street merchant into this file for easier acces
- All StreetMerchant models have been reassigned
- Organise the characters per town in alphabetic order from Antigua to Willemstad for easier search
*/

void CreateStreetMerchantsCharacters(ref n)
{	
	object chobj;
	ref ch;

	makeref(ch, chobj);
	//===============================| Alice Town |===============================//

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Al_Street_merchant_1";
	ch.model	= "Man1_2"; // Estharos Change from Man1_2 to this model
	ch.sex = "man";
	ch.location = "Alice_Port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Redmond Citizen"; // better english sound merchant than french for those nations
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Alice";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

    ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Al_Street_merchant_2";
	ch.model = "bocman10"; // Estharos Change from fatman1 to this model
	ch.sex = "man";
	ch.sound_type = "merchant";
	ch.location	= "Alice_Port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.Dialog.Filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Redmond Citizen"; // better english sound merchant than french for those nations
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "50";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "3";
	ch.skill.Sneak = "1";
	ch.quest.area = "Alice";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	AddGameCharacter(n, ch);

    ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Al_Street_merchant_3";
	ch.model	= "bocman8"; 
	ch.sex = "man";
	ch.location = "Alice_Port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant3";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Oxbay Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Alice";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Al_Street_merchant_4";
	ch.model	= "towngirl3"; 
	ch.sex = "woman";
	ch.location = "Alice_Port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant4";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Alice";
	ch.money = "10";
	ch.greeting = "Gr_Woman_English Citizen";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	//===============================| Antigua Town |===============================//
	//===========================| Buccaneers Camp Town |===========================//
	//=============================| Charlestown Town |=============================//

	ch.old.name = "Edward";
	ch.old.lastname = "Pear";
	ch.name = TranslateString("","Edward");
	ch.lastname = TranslateString("","Pear");
	ch.id		= "Ed Pear";
	ch.model	= "Sailor1"; // Estharos Change from sailor2 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Charlestown_Port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant3";
	ch.Dialog.Filename = "Item Trader_dialog.c";
	ch.greeting = "Gr_Oxbay Citizen";
	ch.rank 	= 1;
	ch.nation = ENGLAND;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "1";
	ch.skill.Sneak = "1";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "ENGLAND_CITIZENS");
	AddGameCharacter(n, ch);

	//==============================| Conceicao Town |==============================//

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Conceicao_Street_merchant_1";
	ch.model	= "fisherman"; // Estharos Change from Sailor3 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Conceicao_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Conceicao Citizen";
	ch.nation = PORTUGAL;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Conceicao";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	//===============================| Douwesen Town |==============================//

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Douwesen_Street_merchant_1";
	ch.model	= "man1_1"; // Estharos Change from Sailor3 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Douwesen_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Douwesen Citizen";
	ch.nation = HOLLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Conceicao";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Douwesen_Street_merchant_2";
	ch.model	= "chelovek"; // Estharos Change from Chelovek1 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Douwesen_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Douwesen Citizen";
	ch.nation = HOLLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Conceicao";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	//==============================| Eleuthera Town |==============================//

    ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "El_Street_merchant_1";
	ch.model	= "towngirl6"; 
	ch.sex = "woman";
	ch.location = "Eleuthera_Port";
	ch.location.group = "barmen";
	ch.location.locator = "bar1";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Eleuthera";
	ch.money = "10";
	ch.greeting = "Gr_Woman_English Citizen";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

    ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "El_Street_merchant_2";
	ch.model	= "chelovek1"; // Estharos Change from Man1_2 to this model
	ch.sex = "man";
	ch.location = "Eleuthera_Port";
	ch.location.group = "barmen";//"barmen";
	ch.location.locator = "bar2";//"bar2";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Redmond Citizen"; // better english sound merchant than french for those nations
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Eleuthera";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

    ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "El_Street_merchant_3";
	ch.model	= "Sailor1"; 
	ch.sex = "man";
	ch.location = "Eleuthera_Port";
	ch.location.group = "barmen";//"merchant";
	ch.location.locator = "bar3";//"merchant3";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Oxbay Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Eleuthera";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "El_Street_Merchant_4";
	ch.model = "sailor6"; // Estharos Change from fatman1 to this model
	ch.sex = "man";
	ch.sound_type = "merchant";
	ch.location	= "Eleuthera_Port";
	ch.location.group = "barmen";
	ch.location.locator = "bar4";
	ch.Dialog.Filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Redmond Citizen"; // better english sound merchant than french for those nations
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "50";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "3";
	ch.skill.Sneak = "1";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	AddGameCharacter(n, ch);

	//==========================| Falaise De Fleur Town |===========================//

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "FF_Street_merchant_1";
	ch.model	= "chelovek1"; // Estharos Change from Man1_2 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Falaise_De_Fleur_Location_03";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_falaise de fleur citizen";
	ch.nation = FRANCE;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "FalaiseDeFleur";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Patric";
	ch.old.lastname = "Cardone";
	ch.name = TranslateString("","Patric");
	ch.lastname = TranslateString("","Cardone");
	ch.id		= "Patric Cardone";
	ch.model = "bocman4"; // Estharos Change from fatman1 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.sound_type = "merchant";
	ch.location	= "Falaise_de_fleur_location_03";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.Dialog.Filename = "patric cardone_dialog.c"; //NK reenable Patric, needed for smuggler quest
	ch.nation = FRANCE;
	ch.rank 	= 1;
	ch.reputation = "50";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "3";
	ch.skill.Sneak = "1";
	ch.money = "10";
	ch.money.quest = "0";
	ch.quest.meeting = "0";
	ch.quest.teodoro = "0";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "FRANCE_CITIZENS");
	ch.greeting = "Gr_Patric Cardone";
	AddGameCharacter(n, ch);

	//=============================| Grand Cayman Town |============================//
	//==============================| Greenford Town |==============================//

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Greenford_Street_merchant_1";
	ch.model	= "fatman1"; 
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Greenford_town";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Oxbay Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Greenford";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Greenford_Street_merchant_2";
	ch.model	= "Mongol"; // Estharos Change from towngirl3 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Greenford_town";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Oxbay Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Greenford";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Greenford_Street_merchant_3";
	ch.model	= "Pirat1"; // Estharos Change from towngirl5 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Greenford_town";
	ch.location.group = "merchant";
	ch.location.locator = "merchant3";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Oxbay Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Greenford";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Greenford_Street_merchant_4";
	ch.model	= "Pirat12"; // Estharos Change from man3_1 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Greenford_town";
	ch.location.group = "merchant";
	ch.location.locator = "merchant4";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Oxbay Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Greenford";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	//=============================| Isla Muelle Town |=============================//

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Muelle_Street_merchant_1";
	ch.model	= "Man4"; // Estharos Change from Man2 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Muelle_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_isla muelle citizen";
	ch.nation = SPAIN;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "IslaMuelle";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Muelle_Street_merchant_2";
	ch.model	= "Man5_1"; // Estharos Change from Man5 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Muelle_town_01";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_isla muelle citizen";
	ch.nation = SPAIN;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "IslaMuelle";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Muelle_Street_merchant_3";
	ch.model	= "Sailor4"; // Estharos Change from Sailor6 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Muelle_town_01";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_isla muelle citizen";
	ch.nation = SPAIN;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "IslaMuelle";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Muelle_Street_merchant_4";
	ch.model	= "sailor5"; // Estharos Change from Old_man1 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Muelle_town_01";
	ch.location.group = "merchant";
	ch.location.locator = "merchant3";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_isla muelle citizen";
	ch.nation = SPAIN;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "IslaMuelle";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	//==============================| La Havana Town |==============================//
	//===============================| Marigot Town |===============================//
	//==============================| Oranjestad Town |=============================//
	//================================| Oxbay Town |================================//

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Oxbay_Street_merchant_1";
	ch.model	= "fisherman1"; // Estharos Change from Fatman2_1 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Oxbay_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Oxbay Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Oxbay";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Oxbay_Street_merchant_2"; // KK
	ch.model	= "Man5_1"; // Estharos Change from Man1_2 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Oxbay_town";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Oxbay Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Oxbay";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);
	
	ch.old.name = "Flann";
	ch.old.lastname = "Vickers";
	ch.name 	= TranslateString("","Flann");
	ch.lastname 	= TranslateString("","Vickers");
	ch.id		= "Flann Vickers";
	ch.model	= "Pirat5"; // Estharos Change from sailor2 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Oxbay_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.Dialog.Filename = "Item Trader_dialog.c";
	ch.greeting = "Gr_Oxbay Citizen";
	ch.rank 	= 1;
	ch.nation = ENGLAND;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "1";
	ch.skill.Sneak = "1";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "ENGLAND_CITIZENS");
	AddGameCharacter(n, ch);

	//=============================| Philipsburg Town |=============================//
	//============================| Point a Pitre Town |============================//

	ch.old.name = "Louis";
	ch.old.lastname = "Rouge";
	ch.name 	= TranslateString("","Louis");
	ch.lastname 	= TranslateString("","Rouge");
	ch.id		= "Louis Rouge";
	ch.model	= "Pirat4"; // Estharos Change from Man2 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Guadeloupe_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.Dialog.Filename = "Item Trader_dialog.c";
	ch.greeting = "Gr_arnaud matton";
	ch.rank 	= 1;
	ch.nation = FRANCE;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "1";
	ch.skill.Sneak = "1";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "FRANCE_CITIZENS");
	AddGameCharacter(n, ch);

	ch.old.name = "Rober";
	ch.old.lastname = "Artouis";
	ch.name 	= TranslateString("","Rober");
	ch.lastname 	= TranslateString("","Artouis");
	ch.id		= "Rober Artouis";
	ch.model	= "Sailor3"; // Estharos Change from sailor2 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Guadeloupe_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.Dialog.Filename = "Item Trader_dialog.c";
	ch.greeting = "Gr_arnaud matton";
	ch.rank 	= 1;
	ch.nation = FRANCE;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "1";
	ch.skill.Sneak = "1";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "FRANCE_CITIZENS");
	AddGameCharacter(n, ch);

	ch.old.name = "Cloude";
	ch.old.lastname = "Labush";
	ch.name 	= TranslateString("","Cloude");
	ch.lastname 	= TranslateString("","Labush");
	ch.id		= "Cloude Labush";
	ch.model	= "Pirat6"; // Estharos Change from Fatman2 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Guadeloupe_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant3";
	ch.Dialog.Filename = "Item Trader_dialog.c";
	ch.greeting = "Gr_arnaud matton";
	ch.rank 	= 1;
	ch.nation = FRANCE;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "1";
	ch.skill.Sneak = "1";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "FRANCE_CITIZENS");
	AddGameCharacter(n, ch);

	//============================| Port o Prince Town |============================//
	//=========================| Quebradas Costillas Town |=========================//
	//===============================| Redmond Town |===============================//

	ch.old.name = "Randolf";
	ch.old.lastname = "Potter";
	ch.name = TranslateString("","Randolf");
	ch.lastname = TranslateString("","Potter");
	ch.id		= "Randolf Potter";
	ch.model	= "Sailor19"; // Estharos Change from man4 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Redmond_port";
	ch.location.group = "goto";
	ch.location.locator = "cityzen_5";
	ch.Dialog.Filename = "Item trader_dialog.c";
	ch.greeting = "Gr_Redmond Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "1";
	ch.skill.Sneak = "1";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "ENGLAND_CITIZENS");
	AddGameCharacter(n, ch);

	ch.old.name = "Brian";
	ch.old.lastname = "Prew";
	ch.name = TranslateString("","Brian");
	ch.lastname = TranslateString("","Prew");
	ch.id		= "Brian Prew";
	ch.model	= "man1_2"; // Estharos Change from searcher to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Redmond_port";
	ch.location.group = "goto";
	ch.location.locator = "cityzen_4";
	ch.Dialog.Filename = "Item trader_dialog.c";
	ch.greeting = "Gr_Redmond Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "1";
	ch.skill.Sneak = "1";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "ENGLAND_CITIZENS");
	AddGameCharacter(n, ch);

	ch.old.name = "Greg";
	ch.old.lastname = "Dawson";
	ch.name = TranslateString("","Greg");
	ch.lastname = TranslateString("","Dawson");
	ch.id		= "Greg Dawson";
	ch.model	= "ancient"; // Estharos Change from towngirl3_1 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Redmond_town_04";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.Dialog.Filename = "Item Trader_dialog.c";
	ch.greeting = "Gr_Redmond Citizen";
	ch.nation = ENGLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "1";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "1";
	ch.skill.Sneak = "1";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "ENGLAND_CITIZENS");
	AddGameCharacter(n, ch);

	//===============================| Santiago Town |==============================//
	//============================| Santo Domingo Town |============================//
	//==============================| Smugglers Town |==============================//
	//===============================| Tortuga Town |===============================//

	ch.old.name = "Brennan";
	ch.old.lastname = "Vickers";
	ch.name = TranslateString("","Brennan");
	ch.lastname = TranslateString("","Vickers");
	ch.id = "Brennan Vickers";
	ch.model = "Pirat7"; // Estharos Change from sailor2 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Tortuga_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.Dialog.Filename = "Item Trader_dialog.c";
	ch.Dialog.CurrentNode = "First time";
	ch.greeting = "Gr_Redmond Citizen";		//JRH
	ch.rank= 5;
	ch.nation = FRANCE;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "6";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "5";
	ch.skill.Sneak = "2";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "TORTUGA_CITIZENS");
	AddGameCharacter(n, ch);
//JRH -->
	ch.old.name = "Gillis";
	ch.old.lastname = "Caspers";
	ch.name = TranslateString("","Gillis");
	ch.lastname = TranslateString("","Caspers");
	ch.id		= "Tortuga_Street_merchant_3";
	ch.model = "Mou_19";
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Tortuga_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant3";
	ch.Dialog.Filename = "Item Trader_dialog.c";
	ch.Dialog.CurrentNode = "First time";
	ch.greeting = "Gr_Tortuga_Street_merchant_3";
	ch.rank= 5;
	ch.nation = FRANCE;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "6";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "5";
	ch.skill.Sneak = "2";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "TORTUGA_CITIZENS");
	AddGameCharacter(n, ch);

	ch.old.name = "Owen";
	ch.old.lastname = "Tripper";
	ch.name = TranslateString("","Owen");
	ch.lastname = TranslateString("","Tripper");
	ch.id		= "Tortuga_Street_merchant_4";
	ch.model = "Mou_9";
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Tortuga_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant4";
	ch.Dialog.Filename = "Item Trader_dialog.c";
	ch.Dialog.CurrentNode = "First time";
	ch.greeting = "Gr_Tortuga_Street_merchant_4";
	ch.rank= 5;
	ch.nation = FRANCE;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "6";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "5";
	ch.skill.Sneak = "2";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "TORTUGA_CITIZENS");
	AddGameCharacter(n, ch);

	ch.old.name = "Natalia";
	ch.old.lastname = "Dempster";
	ch.name = TranslateString("","Natalia");
	ch.lastname = TranslateString("","Dempster");
	ch.id		= "Tortuga_Street_merchant_5";
	ch.model = "Mou_12";
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location	= "Tortuga_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant5";
	ch.Dialog.Filename = "Item Trader_dialog.c";
	ch.Dialog.CurrentNode = "First time";
	ch.greeting = "Gr_Tortuga_Street_merchant_5";
	ch.rank= 5;
	ch.nation = FRANCE;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "1";
	ch.skill.Fencing = "6";
	ch.skill.Sailing = "1";
	ch.skill.Accuracy = "1";
	ch.skill.Cannons = "1";
	ch.skill.Grappling = "1";
	ch.skill.Repair = "1";
	ch.skill.Defence = "1";
	ch.skill.Commerce = "5";
	ch.skill.Sneak = "2";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_group_MoveCharacter(ch, "TORTUGA_CITIZENS");
	AddGameCharacter(n, ch);
//<-- JRH

	//================================| Turks Town |================================//
	//==============================| Willemstad Town |=============================//

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Willemstad_Street_merchant_1";
	ch.model	= "fatman"; 
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Willemstad_town";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Douwesen Citizen";
	ch.nation = HOLLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Willemstad";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Willemstad_Street_merchant_2";
	ch.model	= "Chameleon"; // Estharos Change from towngirl2 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Willemstad_town";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_Douwesen Citizen";
	ch.nation = HOLLAND;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Willemstad";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);
	
	//=============================| Cartagena Town |=============================//

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Cartagena_Street_merchant_1";
	ch.model	= "Man4";
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Cartagena_Center";
	ch.location.group = "merchant";
	ch.location.locator = "merchant3";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_isla muelle citizen";
	ch.nation = SPAIN;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Cartagena";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Cartagena_Street_merchant_2";
	ch.model	= "Man5_1";
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Cartagena_Center";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_isla muelle citizen";
	ch.nation = SPAIN;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Cartagena";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Cartagena_Street_merchant_3";
	ch.model	= "Sailor4";
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Cartagena_Center";
	ch.location.group = "merchant";
	ch.location.locator = "merchant2";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_isla muelle citizen";
	ch.nation = SPAIN;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Cartagena";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Cartagena_Street_merchant_4";
	ch.model	= "sailor5"; // Estharos Change from Old_man1 to this model
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Palace";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_isla muelle citizen";
	ch.nation = SPAIN;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Cartagena";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);

	//=============================| Santiago Port |=============================//

	ch.old.name = "Street";
	ch.old.lastname = "Merchant";
	ch.name = TranslateString("","Street");
	ch.lastname = TranslateString("","Merchant");
	ch.id		= "Santiago_Street_merchant_1";
	ch.model	= "Old_man1"; // GR: Took up residence in Santiago after being kicked out of IslaMuelle
	ch.sound_type = "merchant";
	ch.sex = "man";
	ch.location = "Santiago_port";
	ch.location.group = "merchant";
	ch.location.locator = "merchant1";
	ch.dialog.filename = "Item Trader_Dialog.c";
	ch.greeting = "Gr_isla muelle citizen";
	ch.nation = SPAIN;
	ch.rank 	= 1;
	ch.reputation = "None";
	ch.experience = "0";
	ch.skill.Leadership = "6";
	ch.skill.Fencing = "3";
	ch.skill.Sailing = "4";
	ch.skill.Accuracy = "9";
	ch.skill.Cannons = "5";
	ch.skill.Grappling = "5";
	ch.skill.Repair = "6";
	ch.skill.Defence = "8";
	ch.skill.Commerce = "7";
	ch.skill.Sneak = "8";
	ch.quest.area = "Santiago";
	ch.money = "10";
	LAi_SetMerchantType(ch);
	LAi_SetHP(ch, 80.0, 80.0);
	AddGameCharacter(n, ch);	
}
